/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp.traces;

import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshaler;
import io.opentelemetry.exporter.internal.marshal.StatelessMarshalerUtil;
import io.opentelemetry.exporter.internal.otlp.AttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanEventStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanFlags;
import io.opentelemetry.exporter.internal.otlp.traces.SpanLinkStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanStatusStatelessMarshaler;
import io.opentelemetry.proto.trace.v1.internal.Span;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.io.IOException;

final class SpanStatelessMarshaler
implements StatelessMarshaler<SpanData> {
    static final SpanStatelessMarshaler INSTANCE = new SpanStatelessMarshaler();

    private SpanStatelessMarshaler() {
    }

    @Override
    public void writeTo(Serializer output, SpanData span2, MarshalerContext context) throws IOException {
        output.serializeTraceId(Span.TRACE_ID, span2.getTraceId(), context);
        output.serializeSpanId(Span.SPAN_ID, span2.getSpanId(), context);
        byte[] traceStateUtf8 = context.getData(byte[].class);
        output.serializeString(Span.TRACE_STATE, traceStateUtf8);
        String parentSpanId = span2.getParentSpanContext().isValid() ? span2.getParentSpanContext().getSpanId() : null;
        output.serializeSpanId(Span.PARENT_SPAN_ID, parentSpanId, context);
        output.serializeStringWithContext(Span.NAME, span2.getName(), context);
        output.serializeEnum(Span.KIND, SpanMarshaler.toProtoSpanKind(span2.getKind()));
        output.serializeFixed64(Span.START_TIME_UNIX_NANO, span2.getStartEpochNanos());
        output.serializeFixed64(Span.END_TIME_UNIX_NANO, span2.getEndEpochNanos());
        output.serializeRepeatedMessageWithContext(Span.ATTRIBUTES, span2.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = span2.getTotalAttributeCount() - span2.getAttributes().size();
        output.serializeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        output.serializeRepeatedMessageWithContext(Span.EVENTS, span2.getEvents(), SpanEventStatelessMarshaler.INSTANCE, context);
        int droppedEventsCount = span2.getTotalRecordedEvents() - span2.getEvents().size();
        output.serializeUInt32(Span.DROPPED_EVENTS_COUNT, droppedEventsCount);
        output.serializeRepeatedMessageWithContext(Span.LINKS, span2.getLinks(), SpanLinkStatelessMarshaler.INSTANCE, context);
        int droppedLinksCount = span2.getTotalRecordedLinks() - span2.getLinks().size();
        output.serializeUInt32(Span.DROPPED_LINKS_COUNT, droppedLinksCount);
        output.serializeMessageWithContext(Span.STATUS, span2.getStatus(), SpanStatusStatelessMarshaler.INSTANCE, context);
        output.serializeFixed32(Span.FLAGS, SpanFlags.withParentIsRemoteFlags(span2.getSpanContext().getTraceFlags(), span2.getParentSpanContext().isRemote()));
    }

    @Override
    public int getBinarySerializedSize(SpanData span2, MarshalerContext context) {
        int size = 0;
        size += MarshalerUtil.sizeTraceId(Span.TRACE_ID, span2.getTraceId());
        size += MarshalerUtil.sizeSpanId(Span.SPAN_ID, span2.getSpanId());
        byte[] traceStateUtf8 = SpanMarshaler.encodeSpanTraceState(span2);
        context.addData(traceStateUtf8);
        size += MarshalerUtil.sizeBytes(Span.TRACE_STATE, traceStateUtf8);
        String parentSpanId = span2.getParentSpanContext().isValid() ? span2.getParentSpanContext().getSpanId() : null;
        size += MarshalerUtil.sizeSpanId(Span.PARENT_SPAN_ID, parentSpanId);
        size += StatelessMarshalerUtil.sizeStringWithContext(Span.NAME, span2.getName(), context);
        size += MarshalerUtil.sizeEnum(Span.KIND, SpanMarshaler.toProtoSpanKind(span2.getKind()));
        size += MarshalerUtil.sizeFixed64(Span.START_TIME_UNIX_NANO, span2.getStartEpochNanos());
        size += MarshalerUtil.sizeFixed64(Span.END_TIME_UNIX_NANO, span2.getEndEpochNanos());
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Span.ATTRIBUTES, span2.getAttributes(), AttributeKeyValueStatelessMarshaler.INSTANCE, context);
        int droppedAttributesCount = span2.getTotalAttributeCount() - span2.getAttributes().size();
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_ATTRIBUTES_COUNT, droppedAttributesCount);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Span.EVENTS, span2.getEvents(), SpanEventStatelessMarshaler.INSTANCE, context);
        int droppedEventsCount = span2.getTotalRecordedEvents() - span2.getEvents().size();
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_EVENTS_COUNT, droppedEventsCount);
        size += StatelessMarshalerUtil.sizeRepeatedMessageWithContext(Span.LINKS, span2.getLinks(), SpanLinkStatelessMarshaler.INSTANCE, context);
        int droppedLinksCount = span2.getTotalRecordedLinks() - span2.getLinks().size();
        size += MarshalerUtil.sizeUInt32(Span.DROPPED_LINKS_COUNT, droppedLinksCount);
        size += StatelessMarshalerUtil.sizeMessageWithContext(Span.STATUS, span2.getStatus(), SpanStatusStatelessMarshaler.INSTANCE, context);
        return size += MarshalerUtil.sizeFixed32(Span.FLAGS, SpanFlags.withParentIsRemoteFlags(span2.getSpanContext().getTraceFlags(), span2.getParentSpanContext().isRemote()));
    }
}

