/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.workspace.storage.impl.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0012\u0012\u0004\u0012\u0002H\u00010\u0002j\b\u0012\u0004\u0012\u0002H\u0001`\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u0012J\u001f\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0096\u0080\bJ \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0096\u0080\bJ\n\u0010\u0018\u001a\u00020\u000eH\u0096\u0080\u0004J\u0017\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u001a\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0096\u0080\bJ\u0018\u0010\u001b\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0096\u0080\bJ\u0018\u0010\u001c\u001a\u00020\u00102\u000e\u0010\u001d\u001a\n\u0012\u0006\b\u0000\u0012\u00028\u00000\u001eH\u0016J\u0017\u0010\u001f\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\b\u00a2\u0006\u0002\u0010 J\u001f\u0010!\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00028\u0000H\u0096\u0082\b\u00a2\u0006\u0002\u0010\"J\u0016\u0010#\u001a\u00020\u000e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00028\u00000%H\u0016J/\u0010&\u001a\u00020\u000e2'\u0010'\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e0\tJ\u0006\u0010(\u001a\u00020\u000eJ\b\u0010)\u001a\u00020\u000eH\u0002J\b\u0010*\u001a\u00020\u000eH\u0002R1\u0010\b\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/platform/workspace/storage/impl/containers/MutableWorkspaceList;", "E", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "collection", "", "<init>", "(Ljava/util/Collection;)V", "updateAction", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "value", "", "add", "", "element", "(Ljava/lang/Object;)Z", "index", "", "(ILjava/lang/Object;)V", "addAll", "elements", "clear", "remove", "removeAll", "retainAll", "removeIf", "filter", "Ljava/util/function/Predicate;", "removeAt", "(I)Ljava/lang/Object;", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "replaceAll", "operator", "Ljava/util/function/UnaryOperator;", "setModificationUpdateAction", "updater", "cleanModificationUpdateAction", "callForOutsideUpdate", "checkModificationAllowed", "intellij.platform.workspace.storage"})
@ApiStatus.Internal
public final class MutableWorkspaceList<E>
extends ArrayList<E> {
    @Nullable
    private Function1<? super List<? extends E>, Unit> updateAction;

    public MutableWorkspaceList(@NotNull Collection<? extends E> collection) {
        Intrinsics.checkNotNullParameter(collection, (String)"collection");
        super(collection);
    }

    @Override
    public boolean add(E element) {
        this.checkModificationAllowed();
        boolean result = super.add(element);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public void add(int index, E element) {
        this.checkModificationAllowed();
        super.add(index, element);
        this.callForOutsideUpdate();
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.checkModificationAllowed();
        boolean result = super.addAll(elements);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.checkModificationAllowed();
        boolean result = super.addAll(index, elements);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public void clear() {
        this.checkModificationAllowed();
        super.clear();
        this.callForOutsideUpdate();
    }

    @Override
    public boolean remove(Object element) {
        this.checkModificationAllowed();
        boolean result = super.remove(element);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.checkModificationAllowed();
        boolean result = super.removeAll(elements);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.checkModificationAllowed();
        boolean result = super.retainAll(elements);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super E> filter2) {
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        this.checkModificationAllowed();
        boolean result = super.removeIf(filter2);
        this.callForOutsideUpdate();
        return result;
    }

    public E removeAt(int index) {
        this.checkModificationAllowed();
        Object result = super.remove(index);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public E set(int index, E element) {
        this.checkModificationAllowed();
        E result = super.set(index, element);
        this.callForOutsideUpdate();
        return result;
    }

    @Override
    public void replaceAll(@NotNull UnaryOperator<E> operator) {
        Intrinsics.checkNotNullParameter(operator, (String)"operator");
        this.checkModificationAllowed();
        super.replaceAll(operator);
        this.callForOutsideUpdate();
    }

    public final void setModificationUpdateAction(@NotNull Function1<? super List<? extends E>, Unit> updater) {
        Intrinsics.checkNotNullParameter(updater, (String)"updater");
        this.updateAction = updater;
    }

    public final void cleanModificationUpdateAction() {
        this.updateAction = null;
    }

    private final void callForOutsideUpdate() {
        block0: {
            Function1<? super List<? extends E>, Unit> function1 = this.updateAction;
            if (function1 == null) break block0;
            function1.invoke((Object)this);
        }
    }

    private final void checkModificationAllowed() {
        if (this.updateAction == null) {
            throw new IllegalStateException("Modifications are allowed inside `modifyEntity` method only!");
        }
    }
}

