/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RefactoringActionContextUtil {
    public static boolean isJavaClassHeader(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class, (boolean)false);
        return psiClass != null && (element == psiClass || element == psiClass.getNameIdentifier() || PsiTreeUtil.isAncestor((PsiElement)psiClass.getModifierList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getExtendsList(), (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)psiClass.getImplementsList(), (PsiElement)element, (boolean)false));
    }

    public static boolean isOutsideModuleAndCodeBlock(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            RefactoringActionContextUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            RefactoringActionContextUtil.$$$reportNull$$$0(1);
        }
        if (PsiUtil.isModuleFile((PsiFile)file)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiCodeBlock.class) == null;
    }

    public static boolean isClassWithExtendsOrImplements(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        return RefactoringActionContextUtil.isNotEmpty(psiClass.getExtendsList()) || RefactoringActionContextUtil.isNotEmpty(psiClass.getImplementsList());
    }

    private static boolean isNotEmpty(@Nullable PsiReferenceList referenceList) {
        return referenceList != null && referenceList.getReferenceElements().length > 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/actions/RefactoringActionContextUtil";
        objectArray[2] = "isOutsideModuleAndCodeBlock";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

