/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.turnRefsToSuper.TurnRefsToSuperProcessor;
import com.intellij.refactoring.ui.YesNoPreviewUsagesDialog;
import org.jetbrains.annotations.NotNull;

public final class ExtractClassUtil {
    public static void askAndTurnRefsToSuper(Project project, SmartPsiElementPointer classPointer, SmartPsiElementPointer interfacePointer) {
        PsiElement classElement = classPointer.getElement();
        PsiElement interfaceElement = interfacePointer.getElement();
        if (classElement instanceof PsiClass && interfaceElement instanceof PsiClass) {
            ExtractClassUtil.askAndTurnRefsToSuper((PsiClass)classElement, (PsiClass)interfaceElement);
        }
    }

    public static void askAndTurnRefsToSuper(@NotNull PsiClass subClass, @NotNull PsiClass superClass) {
        if (subClass == null) {
            ExtractClassUtil.$$$reportNull$$$0(0);
        }
        if (superClass == null) {
            ExtractClassUtil.$$$reportNull$$$0(1);
        }
        String superClassName = superClass.getName();
        String className = subClass.getName();
        String createdString = superClass.isInterface() ? JavaRefactoringBundle.message((String)"interface.has.been.successfully.created", (Object[])new Object[]{superClassName}) : JavaRefactoringBundle.message((String)"class.has.been.successfully.created", (Object[])new Object[]{superClassName});
        String message = createdString + "\n" + JavaRefactoringBundle.message((String)"use.super.references.prompt", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName(), className, superClassName});
        YesNoPreviewUsagesDialog dialog = new YesNoPreviewUsagesDialog(JavaRefactoringBundle.message((String)"analyze.and.replace.usages", (Object[])new Object[0]), message, JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES, null, subClass.getProject());
        if (dialog.showAndGet()) {
            boolean isPreviewUsages;
            JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_PREVIEW_USAGES = isPreviewUsages = dialog.isPreviewUsages();
            TurnRefsToSuperProcessor processor = new TurnRefsToSuperProcessor(subClass.getProject(), subClass, superClass, false);
            processor.setPreviewUsages(isPreviewUsages);
            processor.run();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "subClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "superClass";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/extractInterface/ExtractClassUtil";
        objectArray[2] = "askAndTurnRefsToSuper";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

