/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.openapi.project.Project;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.newImpl.structures.DataOutput;
import com.intellij.refactoring.extractMethod.newImpl.structures.ExtractOptions;
import com.intellij.refactoring.extractMethod.newImpl.structures.FlowOutput;
import com.intellij.refactoring.extractMethod.newImpl.structures.InputParameter;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J1\u0010\r\u001a\u0012\u0012\u000e\u0012\f0\u000f\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u00100\u000e2\u0012\u0010\u0011\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u0012\"\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u0013J\"\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010 \u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020!H\u0002J&\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010%\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J4\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010%\u001a\u00020!2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000eH\u0002J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0012\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010,\u001a\u00020-2\u0006\u00102\u001a\u000203R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/CallBuilder;", "", "context", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "factory", "Lcom/intellij/psi/PsiElementFactory;", "expressionOf", "Lcom/intellij/psi/PsiExpression;", "Lorg/jetbrains/annotations/NotNull;", "expression", "", "statementsOf", "", "Lcom/intellij/psi/PsiStatement;", "Lkotlin/jvm/internal/EnhancedNullability;", "statements", "", "([Ljava/lang/String;)Ljava/util/List;", "createDeclaration", "type", "Lcom/intellij/psi/PsiType;", "name", "initializer", "variableDeclaration", "methodCall", "dataOutput", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/DataOutput;", "conditionalExit", "flow", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput$ConditionalFlow;", "exitStatementOf", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput;", "unconditionalExit", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/FlowOutput$UnconditionalFlow;", "createFlowStatements", "flowOutput", "buildCall", "exposedDeclarations", "Lcom/intellij/psi/PsiVariable;", "buildExpressionCall", "createMethodCall", "Lcom/intellij/psi/PsiMethodCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "parameters", "findParentClass", "Lcom/intellij/psi/PsiClass;", "createCall", "dependencies", "Lcom/intellij/refactoring/extractMethod/newImpl/structures/ExtractOptions;", "intellij.java.impl.refactorings"})
@SourceDebugExtension(value={"SMAP\nCallBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallBuilder.kt\ncom/intellij/refactoring/extractMethod/newImpl/CallBuilder\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,163:1\n11705#2:164\n12052#2,3:165\n1#3:168\n1586#4:169\n1661#4,3:170\n1586#4:173\n1661#4,3:174\n1586#4:177\n1661#4,3:178\n*S KotlinDebug\n*F\n+ 1 CallBuilder.kt\ncom/intellij/refactoring/extractMethod/newImpl/CallBuilder\n*L\n41#1:164\n41#1:165,3\n116#1:169\n116#1:170,3\n149#1:173\n149#1:174,3\n161#1:177\n161#1:178,3\n*E\n"})
public final class CallBuilder {
    @NotNull
    private final PsiElement context;
    @NotNull
    private final PsiElementFactory factory;

    public CallBuilder(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)this.context.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(...)");
        this.factory = psiElementFactory;
    }

    private final PsiExpression expressionOf(String expression) {
        PsiExpression psiExpression = this.factory.createExpressionFromText(expression, this.context);
        Intrinsics.checkNotNullExpressionValue((Object)psiExpression, (String)"createExpressionFromText(...)");
        return psiExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiStatement> statementsOf(String ... statements) {
        void $this$mapTo$iv$iv;
        String[] $this$map$iv = statements;
        boolean $i$f$map = false;
        String[] stringArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void statement;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.factory.createStatementFromText((String)statement, this.context));
        }
        return (List)destination$iv$iv;
    }

    private final PsiStatement createDeclaration(PsiType type, String name, String initializer) {
        PsiStatement psiStatement;
        if (type != null) {
            PsiDeclarationStatement psiDeclarationStatement = this.factory.createVariableDeclarationStatement(name, type, this.expressionOf(initializer));
            Intrinsics.checkNotNull((Object)psiDeclarationStatement);
            psiStatement = (PsiStatement)psiDeclarationStatement;
        } else {
            PsiStatement psiStatement2 = this.factory.createStatementFromText(name + " = " + initializer + ";", this.context);
            Intrinsics.checkNotNull((Object)psiStatement2);
            psiStatement = psiStatement2;
        }
        return psiStatement;
    }

    private final List<PsiStatement> variableDeclaration(String methodCall, DataOutput dataOutput) {
        PsiVariable declaredVariable;
        Object[] declarationStatement;
        PsiStatement psiStatement;
        DataOutput dataOutput2 = dataOutput;
        if (dataOutput2 instanceof DataOutput.VariableOutput) {
            PsiType psiType;
            PsiType psiType2 = psiType = ((DataOutput.VariableOutput)dataOutput).getType();
            CallBuilder callBuilder = this;
            boolean bl = false;
            boolean bl2 = ((DataOutput.VariableOutput)dataOutput).getDeclareType();
            psiStatement = callBuilder.createDeclaration((PsiType)(bl2 ? psiType : null), ((DataOutput.VariableOutput)dataOutput).getName(), methodCall);
        } else if (dataOutput2 instanceof DataOutput.ExpressionOutput) {
            PsiType psiType = ((DataOutput.ExpressionOutput)dataOutput).getType();
            String string = ((DataOutput.ExpressionOutput)dataOutput).getName();
            Intrinsics.checkNotNull((Object)string);
            psiStatement = this.createDeclaration(psiType, string, methodCall);
        } else if (Intrinsics.areEqual((Object)dataOutput2, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE) || dataOutput2 instanceof DataOutput.EmptyOutput) {
            psiStatement = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PsiStatement declaration = psiStatement;
        Object[] objectArray = declarationStatement = declaration instanceof PsiDeclarationStatement ? (Object[])declaration : null;
        PsiElement it = declarationStatement != null && (objectArray = objectArray.getDeclaredElements()) != null ? (PsiElement)ArraysKt.firstOrNull((Object[])objectArray) : null;
        PsiVariable psiVariable = declaredVariable = it instanceof PsiVariable ? (PsiVariable)it : null;
        if (declaredVariable != null) {
            boolean isInferredVar;
            PsiVariable outputVariable;
            JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
            DataOutput.VariableOutput variableOutput = dataOutput instanceof DataOutput.VariableOutput ? (DataOutput.VariableOutput)dataOutput : null;
            PsiVariable psiVariable2 = outputVariable = variableOutput != null ? variableOutput.getVariable() : null;
            boolean declareFinal = (psiVariable2 != null ? psiVariable2.hasModifierProperty("final") : false) || Intrinsics.areEqual((Object)settings.INTRODUCE_LOCAL_CREATE_FINALS, (Object)true);
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiModifierListOwner)declaredVariable), (String)"final", (boolean)declareFinal);
            PsiVariable psiVariable3 = outputVariable;
            boolean bl = psiVariable3 != null && (psiVariable3 = psiVariable3.getTypeElement()) != null ? psiVariable3.isInferredType() : (isInferredVar = false);
            if (isInferredVar || PsiUtil.isAvailable((JavaFeature)JavaFeature.LVTI, (PsiElement)this.context) && Intrinsics.areEqual((Object)settings.INTRODUCE_LOCAL_CREATE_VAR_TYPE, (Object)true)) {
                IntroduceVariableUtil.expandDiamondsAndReplaceExplicitTypeWithVar((PsiTypeElement)declaredVariable.getTypeElement(), (PsiElement)((PsiElement)declaredVariable));
            }
        }
        return CollectionsKt.listOfNotNull((Object)declaration);
    }

    private final List<PsiStatement> conditionalExit(String methodCall, FlowOutput.ConditionalFlow flow, DataOutput dataOutput) {
        String string;
        String[] stringArray = dataOutput;
        if (stringArray instanceof DataOutput.VariableOutput) {
            string = "if (" + ((DataOutput.VariableOutput)dataOutput).getName() + " == null) " + ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
        } else if (stringArray instanceof DataOutput.ExpressionOutput) {
            string = "if (" + ((DataOutput.ExpressionOutput)dataOutput).getName() + " != null) " + this.exitStatementOf(flow) + " " + ((DataOutput.ExpressionOutput)dataOutput).getName() + ";";
        } else if (Intrinsics.areEqual((Object)stringArray, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE)) {
            string = "if (" + methodCall + ") " + ((PsiStatement)CollectionsKt.first(flow.getStatements())).getText();
        } else {
            if (stringArray instanceof DataOutput.EmptyOutput) {
                throw new IllegalArgumentException();
            }
            throw new NoWhenBranchMatchedException();
        }
        String exit = string;
        stringArray = new String[]{exit};
        return this.statementsOf(stringArray);
    }

    private final String exitStatementOf(FlowOutput flow) {
        return CollectionsKt.firstOrNull(flow.getStatements()) instanceof PsiYieldStatement ? "yield" : "return";
    }

    private final List<PsiStatement> unconditionalExit(String methodCall, FlowOutput.UnconditionalFlow flow, DataOutput dataOutput) {
        List<PsiStatement> list;
        DataOutput dataOutput2 = dataOutput;
        if (dataOutput2 instanceof DataOutput.VariableOutput) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)((PsiStatement)CollectionsKt.first(flow.getStatements())).getText(), (String)"getText(...)");
            list = this.statementsOf(stringArray);
        } else if (dataOutput2 instanceof DataOutput.ExpressionOutput) {
            String[] stringArray = new String[]{this.exitStatementOf(flow) + " " + methodCall + ";"};
            list = this.statementsOf(stringArray);
        } else {
            if (Intrinsics.areEqual((Object)dataOutput2, (Object)DataOutput.ArtificialBooleanOutput.INSTANCE)) {
                throw new IllegalStateException();
            }
            if (dataOutput2 instanceof DataOutput.EmptyOutput) {
                if (flow.isDefaultExit()) {
                    String[] stringArray = new String[]{methodCall + ";"};
                    list = this.statementsOf(stringArray);
                } else {
                    String[] stringArray = new String[2];
                    stringArray[0] = methodCall + ";";
                    Intrinsics.checkNotNullExpressionValue((Object)((PsiStatement)CollectionsKt.first(flow.getStatements())).getText(), (String)"getText(...)");
                    list = this.statementsOf(stringArray);
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return list;
    }

    private final List<PsiStatement> createFlowStatements(String methodCall, FlowOutput flowOutput, DataOutput dataOutput) {
        List<PsiStatement> list;
        FlowOutput flowOutput2 = flowOutput;
        if (flowOutput2 instanceof FlowOutput.ConditionalFlow) {
            list = this.conditionalExit(methodCall, (FlowOutput.ConditionalFlow)flowOutput, dataOutput);
        } else if (flowOutput2 instanceof FlowOutput.UnconditionalFlow) {
            list = this.unconditionalExit(methodCall, (FlowOutput.UnconditionalFlow)flowOutput, dataOutput);
        } else if (Intrinsics.areEqual((Object)flowOutput2, (Object)FlowOutput.EmptyFlow.INSTANCE)) {
            if (!(dataOutput instanceof DataOutput.VariableOutput)) {
                String[] stringArray = new String[]{methodCall + ";"};
                list = this.statementsOf(stringArray);
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiStatement> buildCall(String methodCall, FlowOutput flowOutput, DataOutput dataOutput, List<? extends PsiVariable> exposedDeclarations) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<PsiStatement> variableDeclaration = !(flowOutput instanceof FlowOutput.ConditionalFlow) && dataOutput instanceof DataOutput.ExpressionOutput ? CollectionsKt.emptyList() : this.variableDeclaration(methodCall, dataOutput);
        Iterable iterable = exposedDeclarations;
        Collection collection = CollectionsKt.plus((Collection)variableDeclaration, (Iterable)this.createFlowStatements(methodCall, flowOutput, dataOutput));
        boolean $i$f$map = false;
        void var8_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiVariable psiVariable = (PsiVariable)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(ExtractMethodHelper.INSTANCE.createDeclaration((PsiVariable)it));
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
    }

    private final List<PsiElement> buildExpressionCall(String methodCall, DataOutput dataOutput) {
        if (!(dataOutput instanceof DataOutput.ExpressionOutput)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        String expression = ((DataOutput.ExpressionOutput)dataOutput).getName() != null ? ((DataOutput.ExpressionOutput)dataOutput).getName() + " = " + methodCall : methodCall;
        return CollectionsKt.listOf((Object)this.factory.createExpressionFromText(expression, this.context));
    }

    private final PsiMethodCallExpression createMethodCall(PsiMethod method, List<? extends PsiExpression> parameters) {
        String string;
        if (method.isConstructor()) {
            string = "this";
        } else {
            String string2 = method.getName();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        }
        String name = string;
        String callText = name + "(" + CollectionsKt.joinToString$default((Iterable)parameters, null, null, null, (int)0, null, CallBuilder::createMethodCall$lambda$0, (int)31, null) + ")";
        PsiElementFactory factory = PsiElementFactory.getInstance((Project)method.getProject());
        PsiExpression psiExpression = factory.createExpressionFromText(callText, this.context);
        Intrinsics.checkNotNull((Object)psiExpression, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMethodCallExpression");
        PsiMethodCallExpression callElement = (PsiMethodCallExpression)psiExpression;
        PsiClass psiClass = this.findParentClass((PsiElement)method);
        Intrinsics.checkNotNull((Object)psiClass);
        PsiClass methodClass = psiClass;
        if (!(Intrinsics.areEqual((Object)methodClass, (Object)this.findParentClass(this.context)) || callElement.resolveMethod() == null || Intrinsics.areEqual((Object)callElement.resolveMethod(), (Object)method) || method.isConstructor())) {
            PsiExpression psiExpression2;
            if (method.hasModifierProperty("static")) {
                var9_8 = factory.createReferenceExpression(methodClass);
                Intrinsics.checkNotNull((Object)var9_8);
                psiExpression2 = (PsiExpression)var9_8;
            } else {
                var9_8 = RefactoringChangeUtil.createThisExpression((PsiManager)method.getManager(), (PsiClass)methodClass);
                Intrinsics.checkNotNull((Object)var9_8);
                psiExpression2 = (PsiExpression)var9_8;
            }
            PsiExpression ref = psiExpression2;
            callElement.getMethodExpression().setQualifierExpression(ref);
        }
        return callElement;
    }

    private final PsiClass findParentClass(PsiElement context) {
        PsiElement psiElement = JavaResolveUtil.findParentContextOfClass((PsiElement)context, PsiClass.class, (boolean)false);
        return psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiElement> createCall(@NotNull PsiMethod method, @NotNull ExtractOptions dependencies) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List<PsiElement> list;
        PsiExpression expressionElement;
        void it;
        Collection collection;
        Object $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        Iterable $this$map$iv2 = dependencies.getInputParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        CodeStyleManager codeStyleManager = $this$mapTo$iv$iv2.iterator();
        while (codeStyleManager.hasNext()) {
            Object item$iv$iv = codeStyleManager.next();
            InputParameter inputParameter = (InputParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((PsiExpression)CollectionsKt.first(it.getReferences()));
        }
        List parameters = (List)destination$iv$iv;
        String methodCall = this.createMethodCall(method, parameters).getText();
        $this$mapTo$iv$iv2 = CollectionsKt.singleOrNull(dependencies.getElements());
        PsiExpression psiExpression = expressionElement = $this$mapTo$iv$iv2 instanceof PsiExpression ? (PsiExpression)$this$mapTo$iv$iv2 : null;
        if (expressionElement != null) {
            Intrinsics.checkNotNull((Object)methodCall);
            list = this.buildExpressionCall(methodCall, dependencies.getDataOutput());
        } else {
            Intrinsics.checkNotNull((Object)methodCall);
            list = this.buildCall(methodCall, dependencies.getFlowOutput(), dependencies.getDataOutput(), dependencies.getExposedLocalVariables());
        }
        List<PsiElement> callElements = list;
        CodeStyleManager styleManager = CodeStyleManager.getInstance((Project)dependencies.getProject());
        Iterable $i$f$mapTo22 = callElements;
        Intrinsics.checkNotNull((Object)styleManager);
        codeStyleManager = styleManager;
        boolean $i$f$map2 = false;
        it = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            PsiElement psiElement = (PsiElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(codeStyleManager.reformat((PsiElement)p0));
        }
        return (List)destination$iv$iv2;
    }

    private static final CharSequence createMethodCall$lambda$0(PsiExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return string;
    }
}

