/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.preview;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.java.JavaPluginDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.extractMethod.ExtractMethodProcessor;
import com.intellij.refactoring.extractMethod.preview.PreviewPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import javax.swing.JComponent;

@Service(value={Service.Level.PROJECT})
public final class ExtractMethodPreviewManager {
    private final Project myProject;
    private ContentManager myContentManager;

    public ExtractMethodPreviewManager(Project project) {
        this.myProject = project;
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> {
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)this.myProject);
            ToolWindow toolWindow = toolWindowManager.registerToolWindow("Extract Method", true, ToolWindowAnchor.BOTTOM, (Disposable)JavaPluginDisposable.getInstance((Project)this.myProject));
            this.myContentManager = toolWindow.getContentManager();
            ContentManagerWatcher.watchContentManager((ToolWindow)toolWindow, (ContentManager)this.myContentManager);
        });
    }

    public void showPreview(ExtractMethodProcessor processor) {
        PsiFile psiFile = processor.getElements()[0].getContainingFile();
        String title = (String)(psiFile != null ? psiFile.getName() + ": " : "") + processor.getMethodName() + "()";
        PreviewPanel panel = new PreviewPanel(processor);
        Content content = this.myContentManager.getFactory().createContent((JComponent)((Object)panel), title, true);
        Disposer.register((Disposable)content, (Disposable)panel);
        this.myContentManager.addContent(content);
        this.myContentManager.setSelectedContent(content);
        panel.setContent(content);
        ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Extract Method").activate(panel::initLater);
    }

    public void closeContent(Content content) {
        this.myContentManager.removeContent(content, true);
    }

    public static ExtractMethodPreviewManager getInstance(Project project) {
        return (ExtractMethodPreviewManager)project.getService(ExtractMethodPreviewManager.class);
    }
}

