/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.introduceField.AbstractInplaceIntroduceFieldPopup;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldDialog;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.introduceField.IntroduceFieldPopupPanel;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.refactoring.util.JavaNameSuggestionUtil;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InplaceIntroduceFieldPopup
extends AbstractInplaceIntroduceFieldPopup {
    private final boolean myStatic;
    private final IntroduceFieldPopupPanel myIntroduceFieldPanel;

    public InplaceIntroduceFieldPopup(PsiLocalVariable localVariable, PsiClass parentClass, boolean aStatic, boolean currentMethodConstructor, PsiExpression[] occurrences, PsiExpression initializerExpression, TypeSelectorManagerImpl typeSelectorManager, Editor editor, boolean allowInitInMethod, boolean allowInitInMethodIfAll, PsiElement anchorElement2, PsiElement anchorElementIfAll, Project project) {
        super(project, editor, initializerExpression, (PsiVariable)localVariable, occurrences, typeSelectorManager, IntroduceFieldHandler.getRefactoringNameText(), parentClass, anchorElement2, anchorElementIfAll);
        this.myStatic = aStatic;
        this.myIntroduceFieldPanel = new IntroduceFieldPopupPanel(parentClass, initializerExpression, localVariable, currentMethodConstructor, localVariable != null, aStatic, (PsiExpression[])this.myOccurrences, allowInitInMethod, allowInitInMethodIfAll, (TypeSelectorManager)typeSelectorManager);
        GridBagConstraints constraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0);
        this.myWholePanel.add((Component)this.getPreviewComponent(), constraints);
        JComponent centerPanel = this.myIntroduceFieldPanel.createCenterPanel();
        this.myWholePanel.add((Component)centerPanel, constraints);
        this.myIntroduceFieldPanel.initializeControls(initializerExpression, IntroduceFieldDialog.ourLastInitializerPlace);
    }

    protected void showBalloon() {
        super.showBalloon();
        if (this.myBalloon != null) {
            this.myIntroduceFieldPanel.setupSelection((Disposable)this.myBalloon);
        }
    }

    protected PsiField createFieldToStartTemplateOn(String[] names, PsiType defaultType) {
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiField field = (PsiField)WriteAction.compute(() -> (PsiField)DumbService.getInstance((Project)this.myProject).computeWithAlternativeResolveEnabled(() -> {
            PsiField field1 = elementFactory.createField(this.chooseName(names, this.getParentClass().getLanguage()), defaultType);
            PsiUtil.setModifierProperty((PsiModifierListOwner)field1, (String)"final", (boolean)this.myIntroduceFieldPanel.isDeclareFinal());
            PsiUtil.setModifierProperty((PsiModifierListOwner)field1, (String)"static", (boolean)this.myStatic);
            String visibility = this.myIntroduceFieldPanel.getFieldVisibility();
            if (visibility != null) {
                PsiUtil.setModifierProperty((PsiModifierListOwner)field1, (String)visibility, (boolean)true);
            }
            field1 = (PsiField)this.getParentClass().add((PsiElement)field1);
            if (this.myExprText != null) {
                this.updateInitializer(elementFactory, field1);
            }
            this.updateVariable((PsiVariable)field1);
            return field1;
        }));
        PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(this.myEditor.getDocument());
        return field;
    }

    @Override
    protected SuggestedNameInfo suggestNames(PsiType defaultType, String propName) {
        PsiExpression expression = this.myExpr != null && ((PsiExpression)this.myExpr).isValid() ? (PsiExpression)this.myExpr : null;
        PsiLocalVariable variable = (PsiLocalVariable)this.getLocalVariable();
        return JavaNameSuggestionUtil.suggestFieldName((PsiType)defaultType, (PsiLocalVariable)variable, (PsiExpression)expression, (boolean)this.myStatic, (PsiClass)this.getParentClass());
    }

    @Override
    protected VariableKind getVariableKind() {
        return VariableKind.FIELD;
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.myIntroduceFieldPanel.setReplaceAllOccurrences(replaceAllOccurrences);
    }

    protected void updateTitle(@Nullable PsiVariable variable, String value) {
        if (variable == null || !variable.hasInitializer()) {
            super.updateTitle((PsiNameIdentifierOwner)variable, value);
        } else {
            PsiExpression initializer = variable.getInitializer();
            assert (initializer != null);
            String text = variable.getText().replace(variable.getName(), value);
            text = text.replace(initializer.getText(), PsiExpressionTrimRenderer.render((PsiExpression)initializer));
            this.setPreviewText(text);
            this.revalidate();
        }
    }

    protected void updateTitle(@Nullable PsiVariable variable) {
        if (variable != null) {
            this.updateTitle(variable, variable.getName());
        }
    }

    protected String getRefactoringId() {
        return "refactoring.extractField";
    }

    public boolean isReplaceAllOccurrences() {
        return this.myIntroduceFieldPanel.isReplaceAllOccurrences();
    }

    @Override
    protected void saveSettings(@NotNull PsiVariable psiVariable) {
        if (psiVariable == null) {
            InplaceIntroduceFieldPopup.$$$reportNull$$$0(0);
        }
        super.saveSettings(psiVariable);
        JavaRefactoringSettings.getInstance().INTRODUCE_FIELD_VISIBILITY = this.myIntroduceFieldPanel.getFieldVisibility();
        this.myIntroduceFieldPanel.saveFinalState();
    }

    @Override
    protected boolean startsOnTheSameElement(RefactoringActionHandler handler, PsiElement element) {
        return handler instanceof IntroduceFieldHandler && super.startsOnTheSameElement(handler, element);
    }

    protected JComponent getComponent() {
        this.myIntroduceFieldPanel.addOccurrenceListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                InplaceIntroduceFieldPopup.this.restartInplaceIntroduceTemplate();
            }
        });
        return this.myWholePanel;
    }

    private void updateInitializer(PsiElementFactory elementFactory, PsiField variable) {
        if (variable != null) {
            if (this.myIntroduceFieldPanel.getInitializerPlace() == BaseExpressionToFieldHandler.InitializationPlace.IN_FIELD_DECLARATION) {
                variable.setInitializer(elementFactory.createExpressionFromText(this.myExprText, (PsiElement)variable));
            } else {
                variable.setInitializer(null);
            }
        }
    }

    protected String getActionName() {
        return "IntroduceField";
    }

    public BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace() {
        return this.myIntroduceFieldPanel.getInitializerPlace();
    }

    protected void performIntroduce() {
        IntroduceFieldDialog.ourLastInitializerPlace = this.myIntroduceFieldPanel.getInitializerPlace();
        PsiType forcedType = this.getType();
        LOG.assertTrue(forcedType == null || forcedType.isValid(), (Object)forcedType);
        BaseExpressionToFieldHandler.Settings settings = new BaseExpressionToFieldHandler.Settings(this.getInputName(), (PsiExpression)this.getExpr(), (PsiExpression[])this.getOccurrences(), this.myIntroduceFieldPanel.isReplaceAllOccurrences(), this.myStatic, this.myIntroduceFieldPanel.isDeclareFinal(), this.myIntroduceFieldPanel.getInitializerPlace(), this.myIntroduceFieldPanel.getFieldVisibility(), (PsiLocalVariable)this.getLocalVariable(), forcedType, this.myIntroduceFieldPanel.isDeleteVariable(), this.getParentClass(), false, false);
        this.performIntroduce(settings);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/introduceField/InplaceIntroduceFieldPopup", "saveSettings"));
    }
}

