/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceparameterobject.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.psi.MutationUtils;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceParameterIncrementDecrement
extends FixableUsageInfo {
    private final PsiUnaryExpression expression;
    private final String newParameterName;
    private final String parameterSetterName;
    private final String parameterGetterName;

    public ReplaceParameterIncrementDecrement(PsiExpression element, String newParameterName, String parameterSetterName, String parameterGetterName) {
        super((PsiElement)element);
        this.parameterSetterName = parameterSetterName;
        this.parameterGetterName = parameterGetterName;
        this.newParameterName = newParameterName;
        this.expression = (PsiUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiUnaryExpression.class);
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiJavaToken sign = this.expression.getOperationSign();
        String operator = sign.getText();
        String strippedOperator = operator.substring(0, operator.length() - 1);
        String newExpression = this.newParameterName + "." + this.parameterSetterName + "(" + this.newParameterName + "." + this.parameterGetterName + "()" + strippedOperator + "1)";
        if (this.expression.getParent() instanceof PsiBinaryExpression) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.expression.getProject());
            PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)this.expression, PsiStatement.class);
            statement.getParent().addBefore((PsiElement)factory.createStatementFromText(newExpression + ";", (PsiElement)this.expression), (PsiElement)statement);
            this.expression.replace((PsiElement)factory.createExpressionFromText(this.newParameterName + "." + this.parameterGetterName + "()", (PsiElement)this.expression));
        } else {
            MutationUtils.replaceExpression(newExpression, (PsiExpression)this.expression);
        }
    }
}

