/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.invertBoolean;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.RecursiveCallLineMarkerProvider;
import com.intellij.codeInspection.dataFlow.ContractReturnValue;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.invertBoolean.InvertBooleanDelegate;
import com.intellij.refactoring.invertBoolean.InvertBooleanHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.BoolUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaInvertBooleanDelegate
extends InvertBooleanDelegate {
    public boolean isVisibleOnElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaInvertBooleanDelegate.$$$reportNull$$$0(0);
        }
        return element instanceof PsiVariable || element instanceof PsiMethod;
    }

    public boolean isAvailableOnElement(@NotNull PsiElement element) {
        if (element == null) {
            JavaInvertBooleanDelegate.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            return PsiTypes.booleanType().equals((Object)var.getType());
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            return PsiTypes.booleanType().equals((Object)method.getReturnType());
        }
        return false;
    }

    public PsiElement adjustElement(PsiElement element, Project project, Editor editor) {
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            if (!PsiTypes.booleanType().equals((Object)var.getType())) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"invert.boolean.wrong.type", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InvertBooleanHandler.getRefactoringName(), (String)"refactoring.invertBoolean");
                return null;
            }
            if (var instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)var;
                PsiElement declarationScope = parameter.getDeclarationScope();
                if (declarationScope instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)declarationScope;
                    PsiMethod superMethod = SuperMethodWarningUtil.checkSuperMethod((PsiMethod)method);
                    if (superMethod == null) {
                        return null;
                    }
                    var = superMethod.getParameterList().getParameters()[method.getParameterList().getParameterIndex(parameter)];
                } else if (declarationScope instanceof PsiForeachStatement) {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"invert.boolean.foreach", (Object[])new Object[0]), (String)InvertBooleanHandler.getRefactoringName(), (String)"refactoring.invertBoolean");
                    return null;
                }
            }
            return var;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (!PsiTypes.booleanType().equals((Object)method.getReturnType())) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)JavaRefactoringBundle.message((String)"invert.boolean.wrong.type", (Object[])new Object[0]));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)InvertBooleanHandler.getRefactoringName(), (String)"refactoring.invertBoolean");
                return null;
            }
            return SuperMethodWarningUtil.checkSuperMethod((PsiMethod)method);
        }
        return null;
    }

    public void collectRefsToInvert(PsiElement namedElement, Collection<? super PsiElement> elementsToInvert) {
        Query query;
        if (namedElement instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)namedElement;
            query = MethodReferencesSearch.search((PsiMethod)m);
        } else {
            query = ReferencesSearch.search((PsiElement)namedElement);
        }
        Query query2 = query;
        for (PsiReference ref : query2.findAll()) {
            PsiMethod method;
            PsiElement element = ref.getElement();
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
            if (parent instanceof PsiReturnStatement && (method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class})) != null && JavaPsiRecordUtil.getRecordComponentForAccessor((PsiMethod)method) != null || this.collectElementsToInvert(namedElement, element, elementsToInvert)) continue;
            JavaInvertBooleanDelegate.collectForeignElementsToInvert((PsiElement)namedElement, (PsiElement)element, (Language)JavaLanguage.INSTANCE, elementsToInvert);
        }
    }

    public boolean collectElementsToInvert(PsiElement namedElement, PsiElement expression, Collection<? super PsiElement> elementsToInvert) {
        boolean toInvert = super.collectElementsToInvert(namedElement, expression, elementsToInvert);
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiAssignmentExpression && !(parent.getParent() instanceof PsiExpressionStatement) || JavaInvertBooleanDelegate.isOperatorAssignment(parent)) {
            elementsToInvert.add((PsiElement)parent);
        }
        return toInvert;
    }

    public PsiElement getElementToInvert(PsiElement namedElement, PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiMethodCallExpression call;
            PsiElement gParent;
            PsiAssignmentExpression assign;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)element;
            PsiElement parent = refExpr.getParent();
            if (parent instanceof PsiAssignmentExpression && refExpr.equals((Object)(assign = (PsiAssignmentExpression)parent).getLExpression())) {
                return assign.getOperationTokenType() == JavaTokenType.EQ ? assign.getRExpression() : parent;
            }
            if (namedElement instanceof PsiParameter && (gParent = refExpr.getParent().getParent()) instanceof PsiMethodCallExpression && !JavaInvertBooleanDelegate.canInvertReferenceElement((PsiElement)(call = (PsiMethodCallExpression)gParent).getMethodExpression(), true)) {
                return null;
            }
            return refExpr;
        }
        return null;
    }

    private static boolean canInvertReferenceElement(PsiElement expression, boolean recursive) {
        PsiExpression qualifierExpression;
        if (expression instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)expression;
            v0 = ref.getQualifierExpression();
        } else {
            v0 = qualifierExpression = null;
        }
        if (qualifierExpression == null || !"super".equals(qualifierExpression.getText())) {
            PsiElement parent = expression.getParent();
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)parent;
                return !recursive || !RecursiveCallLineMarkerProvider.isRecursiveMethodCall((PsiMethodCallExpression)call);
            }
            return true;
        }
        return false;
    }

    public void replaceWithNegatedExpression(@NotNull PsiElement expression) {
        PsiPrefixExpression prefix;
        PsiElement psiElement;
        if (expression == null) {
            JavaInvertBooleanDelegate.$$$reportNull$$$0(2);
        }
        if (!(expression instanceof PsiExpression)) {
            return;
        }
        if (expression.getParent() instanceof PsiMethodCallExpression) {
            expression = expression.getParent();
        }
        while ((psiElement = expression.getParent()) instanceof PsiPrefixExpression && (prefix = (PsiPrefixExpression)psiElement).getOperationTokenType() == JavaTokenType.EXCL) {
            expression = expression.getParent();
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            PsiMethodReferenceExpression ref = (PsiMethodReferenceExpression)expression;
            PsiExpression callExpression = LambdaRefactoringUtil.convertToMethodCallInLambdaBody((PsiMethodReferenceExpression)ref);
            if (callExpression instanceof PsiCallExpression) {
                PsiExpression negatedExpression = JavaPsiFacade.getElementFactory((Project)callExpression.getProject()).createExpressionFromText(BoolUtils.getNegatedExpressionText((PsiExpression)callExpression), (PsiElement)callExpression);
                callExpression.replace((PsiElement)negatedExpression);
            }
        } else if (!(expression.getParent() instanceof PsiExpressionStatement) || JavaInvertBooleanDelegate.isOperatorAssignment(expression)) {
            PsiExpression negatedExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(BoolUtils.getNegatedExpressionText((PsiExpression)((PsiExpression)expression)), expression);
            expression.replace((PsiElement)negatedExpression);
        }
    }

    private static boolean isOperatorAssignment(@NotNull PsiElement expression) {
        PsiAssignmentExpression assignment;
        if (expression == null) {
            JavaInvertBooleanDelegate.$$$reportNull$$$0(3);
        }
        return expression instanceof PsiAssignmentExpression && (assignment = (PsiAssignmentExpression)expression).getOperationTokenType() != JavaTokenType.EQ;
    }

    public void invertElementInitializer(PsiElement element) {
        PsiField field;
        if (element instanceof PsiField && (field = (PsiField)element).getInitializer() == null && !field.hasModifierProperty("final")) {
            field.setInitializer(JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("true", element));
        } else if (element instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)element;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                this.replaceWithNegatedExpression((PsiElement)initializer);
            }
        } else if (element instanceof PsiMethod) {
            PsiMethod m = (PsiMethod)element;
            JavaInvertBooleanDelegate.updateContract(m);
        }
    }

    private static void updateContract(@NotNull PsiMethod method) {
        List contracts;
        PsiAnnotation annotation;
        if (method == null) {
            JavaInvertBooleanDelegate.$$$reportNull$$$0(4);
        }
        if ((annotation = JavaMethodContractUtil.findContractAnnotation((PsiMethod)method)) == null || annotation.getOwner() != method.getModifierList()) {
            return;
        }
        String text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)annotation, null);
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        try {
            contracts = StandardMethodContract.parseContract((String)text);
        }
        catch (StandardMethodContract.ParseException ignore) {
            return;
        }
        List newContracts = ContainerUtil.map((Collection)contracts, contract -> {
            StandardMethodContract standardMethodContract;
            ContractReturnValue value = contract.getReturnValue();
            if (value instanceof ContractReturnValue.BooleanReturnValue) {
                ContractReturnValue.BooleanReturnValue v = (ContractReturnValue.BooleanReturnValue)value;
                standardMethodContract = contract.withReturnValue((ContractReturnValue)v.negate());
            } else {
                standardMethodContract = contract;
            }
            return standardMethodContract;
        });
        if (newContracts.equals(contracts)) {
            return;
        }
        PsiAnnotation newAnnotation = JavaMethodContractUtil.updateContract((PsiAnnotation)annotation, (List)newContracts);
        if (newAnnotation != null) {
            annotation.replace((PsiElement)newAnnotation);
        }
    }

    public void collectRefElements(PsiElement element, @Nullable RenameProcessor renameProcessor, @NotNull String newName, final Collection<? super PsiElement> elementsToInvert) {
        block18: {
            PsiParameter param;
            Collection overriders;
            block17: {
                if (newName == null) {
                    JavaInvertBooleanDelegate.$$$reportNull$$$0(5);
                }
                this.collectRefsToInvert(element, elementsToInvert);
                if (element instanceof PsiRecordComponent) {
                    PsiElement parent;
                    PsiMethod accessor;
                    PsiRecordComponent component = (PsiRecordComponent)element;
                    if (renameProcessor != null && (accessor = JavaPsiRecordUtil.getAccessorForRecordComponent((PsiRecordComponent)component)) != null) {
                        renameProcessor.addElement((PsiElement)accessor, newName);
                    }
                    if ((parent = component.getParent()) instanceof PsiRecordHeader) {
                        PsiRecordHeader header = (PsiRecordHeader)parent;
                        PsiRecordComponent @NotNull [] components = header.getRecordComponents();
                        int index = -1;
                        for (int i = 0; i < components.length; ++i) {
                            if (component != components[i]) continue;
                            index = i;
                            break;
                        }
                        if (index < 0) {
                            return;
                        }
                        PsiClass recordClass = header.getContainingClass();
                        if (recordClass == null) {
                            return;
                        }
                        JavaInvertBooleanDelegate.collectConstructorParameterReferences(JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)recordClass), index, elementsToInvert);
                    }
                }
                if (!(element instanceof PsiMethod)) break block17;
                PsiMethod method = (PsiMethod)element;
                overriders = OverridingMethodsSearch.search((PsiMethod)method).findAll();
                if (renameProcessor != null) {
                    for (Object overrider : overriders) {
                        renameProcessor.addElement((PsiElement)overrider, newName);
                    }
                }
                HashSet<PsiMethod> allMethods = new HashSet<PsiMethod>(overriders);
                allMethods.add(method);
                for (PsiMethod m : allMethods) {
                    m.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(this){

                        public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
                            PsiExpression returnValue;
                            if (statement == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if ((returnValue = statement.getReturnValue()) != null && PsiTypes.booleanType().equals((Object)returnValue.getType())) {
                                elementsToInvert.add(returnValue);
                            }
                        }

                        public void visitClass(@NotNull PsiClass aClass) {
                            if (aClass == null) {
                                1.$$$reportNull$$$0(1);
                            }
                        }

                        public void visitLambdaExpression(@NotNull PsiLambdaExpression expression) {
                            if (expression == null) {
                                1.$$$reportNull$$$0(2);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "statement";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "aClass";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "expression";
                                    break;
                                }
                            }
                            objectArray2[1] = "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate$1";
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitReturnStatement";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitClass";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[2] = "visitLambdaExpression";
                                    break;
                                }
                            }
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                break block18;
            }
            if (!(element instanceof PsiParameter) || !((overriders = (param = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod)) break block18;
            PsiMethod method = (PsiMethod)overriders;
            int index = method.getParameterList().getParameterIndex(param);
            assert (index >= 0);
            for (PsiReference reference : MethodReferencesSearch.search((PsiMethod)method).findAll()) {
                PsiReferenceExpression ref;
                PsiExpression psiExpression;
                PsiExpression[] args;
                PsiExpressionList argumentList;
                PsiReferenceExpression methodExpression;
                PsiElement parent = reference.getElement().getParent();
                if (parent instanceof PsiAnonymousClass) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof PsiCall)) continue;
                PsiCall call = (PsiCall)parent;
                if (call instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression m = (PsiMethodCallExpression)call;
                    v0 = m.getMethodExpression();
                } else {
                    v0 = methodExpression = null;
                }
                if ((argumentList = call.getArgumentList()) == null || index >= (args = argumentList.getExpressions()).length || methodExpression != null && !JavaInvertBooleanDelegate.canInvertReferenceElement((PsiElement)methodExpression, (psiExpression = args[index]) instanceof PsiReferenceExpression && (ref = (PsiReferenceExpression)psiExpression).resolve() == element)) continue;
                elementsToInvert.add((PsiElement)args[index]);
            }
            for (Object overrider : OverridingMethodsSearch.search((PsiMethod)method).findAll()) {
                PsiParameter overriderParameter = overrider.getParameterList().getParameters()[index];
                if (renameProcessor != null) {
                    renameProcessor.addElement((PsiElement)overriderParameter, newName);
                }
                this.collectRefsToInvert((PsiElement)overriderParameter, elementsToInvert);
            }
        }
    }

    private static void collectConstructorParameterReferences(PsiMethod constructor, int index, Collection<? super PsiElement> result) {
        if (constructor == null) {
            return;
        }
        for (PsiReference reference : MethodReferencesSearch.search((PsiMethod)constructor).findAll()) {
            PsiReferenceExpression ref;
            PsiElement psiElement;
            PsiCall call;
            PsiExpressionList argumentList;
            PsiElement refElement = reference.getElement().getParent();
            if (!(refElement instanceof PsiCall) || (argumentList = (call = (PsiCall)refElement).getArgumentList()) == null) continue;
            PsiExpression expression = argumentList.getExpressions()[index];
            if (JavaInvertBooleanDelegate.isThisCall(refElement) && expression instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)expression).resolve()) instanceof PsiParameter) {
                PsiParameter param = (PsiParameter)psiElement;
                PsiElement scope = param.getDeclarationScope();
                if (!(scope instanceof PsiMethod)) continue;
                PsiMethod method = (PsiMethod)scope;
                int newIndex = method.getParameterList().getParameterIndex(param);
                JavaInvertBooleanDelegate.collectConstructorParameterReferences(method, newIndex, result);
                continue;
            }
            result.add((PsiElement)expression);
        }
    }

    private static boolean isThisCall(PsiElement element) {
        PsiKeyword keyword;
        PsiMethodCallExpression call;
        PsiElement psiElement;
        return element instanceof PsiMethodCallExpression && (psiElement = (call = (PsiMethodCallExpression)element).getMethodExpression().getLastChild()) instanceof PsiKeyword && PsiUtil.isJavaToken((PsiElement)(keyword = (PsiKeyword)psiElement), (IElementType)JavaTokenType.THIS_KEYWORD);
    }

    public void findConflicts(UsageInfo[] usageInfos, MultiMap<PsiElement, String> conflicts) {
        for (UsageInfo info : usageInfos) {
            PsiElement element = info.getElement();
            if (!(element instanceof PsiMethodReferenceExpression)) continue;
            conflicts.putValue((Object)element, (Object)JavaRefactoringBundle.message((String)"expand.method.reference.warning", (Object[])new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/invertBoolean/JavaInvertBooleanDelegate";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVisibleOnElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceWithNegatedExpression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isOperatorAssignment";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "updateContract";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectRefElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

