/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveMembers.MoveMembersDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.HashSet;

public final class MoveMembersImpl {
    public static void doMove(Project project, PsiElement[] elements, PsiElement targetContainer, MoveCallback moveCallback) {
        if (elements.length == 0) {
            return;
        }
        PsiElement first = elements[0];
        if (!(first instanceof PsiMember) || ((PsiMember)first).getContainingClass() == null) {
            return;
        }
        PsiClass sourceClass = ((PsiMember)first).getContainingClass();
        HashSet<PsiMember> preselectMembers = new HashSet<PsiMember>();
        for (PsiElement element : elements) {
            PsiClass aClass;
            if (element instanceof PsiMember) {
                PsiMember member = (PsiMember)element;
                preselectMembers.add(member);
                if (!sourceClass.equals((Object)member.getContainingClass())) {
                    String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"members.to.be.moved.should.belong.to.the.same.class"));
                    CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)project);
                    return;
                }
            }
            if (element instanceof PsiField) {
                PsiField field = (PsiField)element;
                if (field.hasModifierProperty("static")) continue;
                String fieldName = PsiFormatUtil.formatVariable((PsiVariable)field, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                String message = RefactoringBundle.message((String)"field.0.is.not.static", (Object[])new Object[]{fieldName, MoveMembersImpl.getRefactoringName()});
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)project);
                return;
            }
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                String methodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
                if (method.isConstructor()) {
                    String message = RefactoringBundle.message((String)"0.refactoring.cannot.be.applied.to.constructors", (Object[])new Object[]{MoveMembersImpl.getRefactoringName()});
                    CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)project);
                    return;
                }
                if (method.hasModifierProperty("static")) continue;
                String message = RefactoringBundle.message((String)"method.0.is.not.static", (Object[])new Object[]{methodName, MoveMembersImpl.getRefactoringName()});
                CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)project);
                return;
            }
            if (!(element instanceof PsiClass) || (aClass = (PsiClass)element).hasModifierProperty("static")) continue;
            String message = JavaRefactoringBundle.message((String)"inner.class.0.is.not.static", (Object[])new Object[]{aClass.getQualifiedName(), MoveMembersImpl.getRefactoringName()});
            CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)sourceClass)) {
            return;
        }
        PsiClass initialTargerClass = targetContainer instanceof PsiClass ? (PsiClass)targetContainer : null;
        MoveMembersDialog dialog = new MoveMembersDialog(project, sourceClass, initialTargerClass, preselectMembers, moveCallback);
        dialog.show();
    }

    @NlsContexts.DialogTitle
    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.members.title");
    }
}

