/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveMembers;

import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractSuperclass.ExtractSuperClassUtil;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveMemberViewDescriptor;
import com.intellij.refactoring.move.moveMembers.MoveMemberHandler;
import com.intellij.refactoring.move.moveMembers.MoveMembersImpl;
import com.intellij.refactoring.move.moveMembers.MoveMembersOptions;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringConflictsUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveMembersProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveMembersProcessor.class);
    private PsiClass myTargetClass;
    private final Set<PsiMember> myMembersToMove = new LinkedHashSet<PsiMember>();
    private final MoveCallback myMoveCallback;
    private final boolean myOpenInEditor;
    private String myNewVisibility;
    private @NlsContexts.Command String myCommandName = MoveMembersImpl.getRefactoringName();
    private MoveMembersOptions myOptions;

    public MoveMembersProcessor(Project project, MoveMembersOptions options2) {
        this(project, null, options2);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options2) {
        this(project, moveCallback, options2, false);
    }

    public MoveMembersProcessor(Project project, @Nullable MoveCallback moveCallback, MoveMembersOptions options2, boolean openInEditor) {
        super(project);
        this.myMoveCallback = moveCallback;
        this.myOpenInEditor = openInEditor;
        this.setOptions(options2);
    }

    @NlsContexts.Command
    @NotNull
    protected String getCommandName() {
        String string = this.myCommandName;
        if (string == null) {
            MoveMembersProcessor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move.members";
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        PsiMember[] selectedMembers = this.myOptions.getSelectedMembers();
        RefactoringEventData data = new RefactoringEventData();
        data.addElement((PsiElement)selectedMembers[0].getContainingClass());
        data.addElements((PsiElement[])selectedMembers);
        return data;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveMembersProcessor.$$$reportNull$$$0(1);
        }
        return ExtractSuperClassUtil.createAfterData(this.myTargetClass);
    }

    private void setOptions(MoveMembersOptions dialog) {
        this.myOptions = dialog;
        Object[] members = dialog.getSelectedMembers();
        this.myMembersToMove.clear();
        ContainerUtil.addAll(this.myMembersToMove, (Object[])members);
        this.setCommandName((PsiMember[])members);
        this.myNewVisibility = dialog.getMemberVisibility();
    }

    private void setCommandName(PsiMember[] members) {
        this.myCommandName = RefactoringBundle.message((String)"move.0.title", (Object[])new Object[]{StringUtil.join((Object[])members, member -> UsageViewUtil.getType((PsiElement)member) + " " + UsageViewUtil.getShortName((PsiElement)member), (String)", ")});
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveMembersProcessor.$$$reportNull$$$0(2);
        }
        return new MoveMemberViewDescriptor(PsiUtilCore.toPsiElementArray(this.myMembersToMove));
    }

    protected UsageInfo @NotNull [] findUsages() {
        String targetClassName = this.myOptions.getTargetClassName();
        this.myTargetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(targetClassName, GlobalSearchScope.projectScope((Project)this.myProject));
        LOG.assertTrue(this.myTargetClass != null, (Object)("target class: " + targetClassName));
        ArrayList<MoveMembersUsageInfo> usagesList = new ArrayList<MoveMembersUsageInfo>();
        for (PsiMember member : this.myMembersToMove) {
            for (PsiReference psiReference : ReferencesSearch.search((PsiElement)member).asIterable()) {
                PsiElement ref = psiReference.getElement();
                MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(ref.getLanguage());
                MoveMembersUsageInfo usage = null;
                if (handler != null && this.myTargetClass != null) {
                    usage = handler.getUsage(member, psiReference, this.myMembersToMove, this.myTargetClass);
                }
                if (usage != null) {
                    usagesList.add(usage);
                    continue;
                }
                if (RefactoringUtil.isInMovedElement(ref, this.myMembersToMove)) continue;
                usagesList.add(new MoveMembersUsageInfo(member, ref, null, ref, psiReference));
            }
        }
        UsageInfo[] usageInfos = usagesList.toArray(UsageInfo.EMPTY_ARRAY);
        if ((usageInfos = UsageViewUtil.removeDuplicatedUsages((UsageInfo[])usageInfos)) == null) {
            MoveMembersProcessor.$$$reportNull$$$0(3);
        }
        return usageInfos;
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveMembersProcessor.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(this.myMembersToMove.size() == elements.length);
        this.myMembersToMove.clear();
        for (PsiElement resolved : elements) {
            this.myMembersToMove.add((PsiMember)resolved);
        }
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiClass targetClass;
        if (usages == null) {
            MoveMembersProcessor.$$$reportNull$$$0(5);
        }
        if ((targetClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.myOptions.getTargetClassName(), GlobalSearchScope.projectScope((Project)this.myProject))) == null) {
            return;
        }
        Map<PsiMember, SmartPsiElementPointer<PsiMember>> movedMembers = this.performMove(targetClass, this.myMembersToMove, ContainerUtil.map((Object[])usages, MoveMembersUsageInfo.class::cast));
        this.afterAllMovements(movedMembers);
    }

    private Map<PsiMember, SmartPsiElementPointer<PsiMember>> performMove(PsiClass targetClass, Set<PsiMember> membersToMove, List<MoveMembersUsageInfo> usages) {
        HashMap<PsiMember, SmartPsiElementPointer> anchors = new HashMap<PsiMember, SmartPsiElementPointer>();
        HashMap<PsiMember, PsiMember> anchorsInSourceClass = new HashMap<PsiMember, PsiMember>();
        for (PsiMember psiMember : membersToMove) {
            MoveMemberHandler moveMemberHandler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(psiMember.getLanguage());
            if (moveMemberHandler == null) continue;
            PsiElement anchor = moveMemberHandler.getAnchor(psiMember, targetClass, membersToMove);
            if (anchor instanceof PsiMember && membersToMove.contains((PsiMember)anchor)) {
                anchorsInSourceClass.put(psiMember, (PsiMember)anchor);
                continue;
            }
            anchors.put(psiMember, anchor == null ? null : SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer(anchor));
        }
        ArrayList<MoveMembersUsageInfo> otherUsages = new ArrayList<MoveMembersUsageInfo>();
        for (MoveMembersUsageInfo moveMembersUsageInfo : usages) {
            MoveMemberHandler handler2;
            if (!moveMembersUsageInfo.reference.isValid() || (handler2 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(moveMembersUsageInfo.getElement().getLanguage())) != null && handler2.changeExternalUsage(this.myOptions, moveMembersUsageInfo)) continue;
            otherUsages.add(moveMembersUsageInfo);
        }
        HashMap<PsiMember, SmartPsiElementPointer<PsiMember>> hashMap = new HashMap<PsiMember, SmartPsiElementPointer<PsiMember>>();
        for (PsiMember member : membersToMove) {
            PsiMember memberInSourceClass;
            ArrayList<PsiReference> refsToBeRebind = new ArrayList<PsiReference>();
            Iterator iterator = otherUsages.iterator();
            while (iterator.hasNext()) {
                MoveMembersUsageInfo info = (MoveMembersUsageInfo)((Object)iterator.next());
                if (!member.equals((Object)info.member)) continue;
                PsiReference ref = info.getReference();
                if (ref != null) {
                    refsToBeRebind.add(ref);
                }
                iterator.remove();
            }
            this.getTransaction().getElementListener((PsiElement)member);
            MoveMemberHandler handler3 = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler3 == null) continue;
            SmartPsiElementPointer anchor = anchorsInSourceClass.containsKey(member) ? ((memberInSourceClass = (PsiMember)anchorsInSourceClass.get(member)) != null ? (SmartPsiElementPointer)hashMap.get(memberInSourceClass) : null) : (SmartPsiElementPointer)anchors.get(member);
            PsiMember newMember = handler3.doMove(this.myOptions, member, anchor == null ? null : anchor.getElement(), targetClass);
            hashMap.put(member, (SmartPsiElementPointer<PsiMember>)SmartPointerManager.createPointer((PsiElement)newMember));
            this.fixModifierList(member, newMember, usages);
            for (PsiReference reference : refsToBeRebind) {
                try {
                    reference.bindToElement((PsiElement)newMember);
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
        MoveMemberHandler moveMemberHandler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(targetClass.getLanguage());
        if (moveMemberHandler != null) {
            moveMemberHandler.decodeContextInfo((PsiElement)targetClass);
        }
        return hashMap;
    }

    private void afterAllMovements(Map<PsiMember, SmartPsiElementPointer<PsiMember>> movedMembers) {
        PsiMember item;
        for (Map.Entry<PsiMember, SmartPsiElementPointer<PsiMember>> entry : movedMembers.entrySet()) {
            PsiMember newMember = (PsiMember)entry.getValue().getElement();
            if (newMember == null) continue;
            PsiMember oldMember = entry.getKey();
            this.getTransaction().getElementListener((PsiElement)oldMember).elementMoved((PsiElement)newMember);
        }
        this.myMembersToMove.clear();
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
        if (this.myOpenInEditor && (item = (PsiMember)JBIterable.from(movedMembers.values()).map(SmartPsiElementPointer::getElement).filter(Objects::nonNull).first()) != null) {
            EditorHelper.openInEditor((PsiElement)item);
        }
    }

    private void fixModifierList(PsiMember member, PsiMember newMember, List<MoveMembersUsageInfo> usages) throws IncorrectOperationException {
        PsiModifierList modifierList = newMember.getModifierList();
        if (modifierList != null && this.myTargetClass.isInterface()) {
            modifierList.setModifierProperty("public", false);
            modifierList.setModifierProperty("protected", false);
            modifierList.setModifierProperty("private", false);
            if (newMember instanceof PsiClass) {
                modifierList.setModifierProperty("static", false);
            }
            return;
        }
        if (this.myNewVisibility == null) {
            return;
        }
        ArrayList<MoveMembersUsageInfo> filtered = new ArrayList<MoveMembersUsageInfo>();
        for (MoveMembersUsageInfo usage : usages) {
            if (member != usage.member) continue;
            filtered.add(usage);
        }
        UsageInfo[] infos = filtered.toArray(UsageInfo.EMPTY_ARRAY);
        VisibilityUtil.fixVisibility((PsiElement[])UsageViewUtil.toElements((UsageInfo[])infos), (PsiMember)newMember, (String)this.myNewVisibility);
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveMembersProcessor.$$$reportNull$$$0(6);
        }
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        String newVisibility = this.myOptions.getExplicitMemberVisibility();
        HashMap<PsiMember, PsiModifierList> modifierListCopies = new HashMap<PsiMember, PsiModifierList>();
        for (PsiMember member : this.myMembersToMove) {
            PsiModifierList modifierListCopy = member.getModifierList();
            if (modifierListCopy != null) {
                modifierListCopy = (PsiModifierList)modifierListCopy.copy();
            }
            if (modifierListCopy != null && newVisibility != null) {
                try {
                    VisibilityUtil.setVisibility((PsiModifierList)modifierListCopy, (String)newVisibility);
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            modifierListCopies.put(member, modifierListCopy);
        }
        MoveMembersProcessor.analyzeConflictsOnUsages(usages, this.myMembersToMove, this.myTargetClass, modifierListCopies, this.myOptions, (MultiMap<PsiElement, String>)conflicts);
        MoveMembersProcessor.analyzeConflictsOnMembers(this.myMembersToMove, newVisibility, this.myTargetClass, modifierListCopies, (MultiMap<PsiElement, String>)conflicts);
        VirtualFile vFile = PsiUtilCore.getVirtualFile((PsiElement)this.myTargetClass);
        if (vFile != null) {
            RefactoringConflictsUtil.getInstance().analyzeModuleConflicts(this.myProject, this.myMembersToMove, usages, vFile, conflicts);
        }
        return this.showConflicts(conflicts, usages);
    }

    private static void analyzeConflictsOnUsages(UsageInfo[] usages, Set<PsiMember> membersToMove, @NotNull PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MoveMembersOptions options2, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (targetClass == null) {
            MoveMembersProcessor.$$$reportNull$$$0(7);
        }
        for (UsageInfo usage : usages) {
            if (!(usage instanceof MoveMembersUsageInfo)) continue;
            MoveMembersUsageInfo usageInfo = (MoveMembersUsageInfo)usage;
            PsiMember member = usageInfo.member;
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnUsage(usageInfo, modifierListCopies.get(member), targetClass, membersToMove, options2, conflicts);
        }
    }

    private static void analyzeConflictsOnMembers(Set<PsiMember> membersToMove, String newVisibility, PsiClass targetClass, Map<PsiMember, PsiModifierList> modifierListCopies, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        for (PsiMember member : membersToMove) {
            MoveMemberHandler handler = (MoveMemberHandler)MoveMemberHandler.EP_NAME.forLanguage(member.getLanguage());
            if (handler == null) continue;
            handler.checkConflictsOnMember(member, newVisibility, modifierListCopies.get(member), targetClass, membersToMove, conflicts);
        }
    }

    public void doRun() {
        if (this.myMembersToMove.isEmpty()) {
            String message = RefactoringBundle.message((String)"no.members.selected");
            CommonRefactoringUtil.showErrorMessage((String)MoveMembersImpl.getRefactoringName(), (String)message, (String)"refactoring.moveMembers", (Project)this.myProject);
            return;
        }
        super.doRun();
    }

    public List<PsiElement> getMembers() {
        return new ArrayList<PsiMember>(this.myMembersToMove);
    }

    public PsiClass getTargetClass() {
        return this.myTargetClass;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveMembers/MoveMembersProcessor";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveMembers/MoveMembersProcessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "analyzeConflictsOnUsages";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static class MoveMembersUsageInfo
    extends MoveRenameUsageInfo {
        public final PsiClass qualifierClass;
        public final PsiElement reference;
        public final PsiMember member;

        public MoveMembersUsageInfo(PsiMember member, PsiElement element, PsiClass qualifierClass, PsiElement highlightElement, PsiReference ref) {
            super(highlightElement, ref, (PsiElement)member);
            this.member = member;
            this.qualifierClass = qualifierClass;
            this.reference = element;
        }
    }
}

