/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class InheritorRenamer
extends AutomaticRenamer {
    public InheritorRenamer(PsiClass aClass, String newClassName) {
        for (PsiClass inheritor : ClassInheritorsSearch.search((PsiClass)aClass).findAll()) {
            if (InheritorRenamer.getPresentationName((PsiNamedElement)inheritor) == null) continue;
            this.myElements.add(inheritor);
        }
        this.suggestAllNames(InheritorRenamer.getPresentationName((PsiNamedElement)aClass), newClassName);
    }

    public String getDialogTitle() {
        return RefactoringBundle.message((String)"rename.inheritors.title");
    }

    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.inheritors.with.the.following.names.to.title", (Object[])new Object[0]);
    }

    public String entityName() {
        return JavaRefactoringBundle.message((String)"entity.name.inheritor", (Object[])new Object[0]);
    }
}

