/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.SealedUtils;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class SafeDeletePermitsClassUsageInfo
extends SafeDeleteReferenceUsageInfo {
    private final PsiClass myParentClass;
    private final boolean myChangeParentModifier;

    public SafeDeletePermitsClassUsageInfo(PsiJavaCodeReferenceElement reference, PsiClass refClass, PsiClass parentClass, boolean changeParentModifier) {
        super((PsiElement)reference, (PsiElement)refClass, true);
        this.myParentClass = parentClass;
        this.myChangeParentModifier = changeParentModifier;
    }

    public PsiClass getReferencedElement() {
        return (PsiClass)super.getReferencedElement();
    }

    public void deleteElement() throws IncorrectOperationException {
        PsiClass refClass = this.getReferencedElement();
        if (this.myChangeParentModifier) {
            SealedUtils.removeFromPermitsList((PsiClass)this.myParentClass, (PsiClass)refClass);
        } else {
            PsiJavaCodeReferenceElement exChildRef = this.findReference();
            if (exChildRef != null) {
                exChildRef.delete();
            }
        }
    }

    public boolean isSafeDelete() {
        return this.findReference() != null;
    }

    @Nullable
    private PsiJavaCodeReferenceElement findReference() {
        PsiReferenceList permitsList = this.myParentClass.getPermitsList();
        if (permitsList == null) {
            return null;
        }
        Object[] childRefs = permitsList.getReferenceElements();
        if (childRefs.length < 1) {
            return null;
        }
        return (PsiJavaCodeReferenceElement)ContainerUtil.find((Object[])childRefs, ref -> ref.resolve() == this.getReferencedElement());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SafeDeletePermitsClassUsageInfo info = (SafeDeletePermitsClassUsageInfo)((Object)o);
        return this.myChangeParentModifier == info.myChangeParentModifier && Objects.equals(this.myParentClass, info.myParentClass);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.myParentClass, this.myChangeParentModifier);
    }
}

