/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classRefs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.refactoring.util.classRefs.ClassReferenceVisitor;

public abstract class ClassReferenceScanner {
    protected PsiClass myClass;
    private PsiReference[] myReferences;

    public abstract PsiReference[] findReferences();

    public ClassReferenceScanner(PsiClass aClass) {
        this.myClass = aClass;
    }

    public void processReferences(ClassReferenceVisitor visitor2) {
        if (this.myReferences == null) {
            this.myReferences = this.findReferences();
        }
        for (PsiReference reference : this.myReferences) {
            ClassReferenceScanner.processUsage(reference.getElement(), visitor2);
        }
    }

    private static void processUsage(PsiElement ref, ClassReferenceVisitor visitor2) {
        if (ref instanceof PsiReferenceExpression) {
            PsiReferenceExpression refExpr = (PsiReferenceExpression)ref;
            visitor2.visitReferenceExpression(refExpr);
            return;
        }
        PsiElement parent = ref.getParent();
        if (parent instanceof PsiTypeElement) {
            PsiTypeElement typeElement = (PsiTypeElement)parent;
            PsiElement pparent = parent.getParent();
            while (pparent instanceof PsiTypeElement) {
                parent = pparent;
                pparent = parent.getParent();
            }
            ClassReferenceVisitor.TypeOccurence occurence = new ClassReferenceVisitor.TypeOccurence(ref, typeElement.getType());
            if (pparent instanceof PsiLocalVariable) {
                PsiLocalVariable var = (PsiLocalVariable)pparent;
                visitor2.visitLocalVariableDeclaration(var, occurence);
            } else if (pparent instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)pparent;
                visitor2.visitParameterDeclaration(parameter, occurence);
            } else if (pparent instanceof PsiField) {
                PsiField field = (PsiField)pparent;
                visitor2.visitFieldDeclaration(field, occurence);
            } else if (pparent instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)pparent;
                visitor2.visitMethodReturnType(method, occurence);
            } else if (pparent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression cast = (PsiTypeCastExpression)pparent;
                visitor2.visitTypeCastExpression(cast, occurence);
            }
        } else if (parent instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            visitor2.visitNewExpression(newExpression, new ClassReferenceVisitor.TypeOccurence(ref, newExpression.getType()));
        } else {
            visitor2.visitOther(ref);
        }
    }
}

