/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.library;

import com.intellij.java.library.JavaLibraryHolder;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.Libraries;
import com.intellij.java.library.LibraryWithMavenCoordinatesProperties;
import com.intellij.java.library.MavenCoordinates;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.Interner;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.jar.Attributes;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public final class JavaLibraryUtil {
    private static final Key<CachedValue<Map<String, Boolean>>> LIBRARY_CLASSES_PRESENCE_KEY = Key.create((String)"LIBRARY_CLASSES_PRESENCE");
    private static final Key<ParameterizedCachedValue<Libraries, Module>> MAVEN_LIBRARIES_MODULE_KEY = Key.create((String)"MAVEN_LIBRARY_PRESENCE");
    private static final ParameterizedCachedValueProvider<Libraries, Module> MAVEN_LIBRARIES_MODULE_PROVIDER = module -> {
        String externalSystemId = ExternalSystemModulePropertyManager.getInstance((Module)module).getExternalSystemId();
        Libraries libraries = JavaLibraryUtil.fillLibraries(OrderEnumerator.orderEntries((Module)module), JavaLibraryUtil.isUnsupportedBuildSystem(externalSystemId));
        return CachedValueProvider.Result.create((Object)libraries, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject())});
    };
    private static final Interner<String> INTERNER = Interner.createStringInterner();
    private static final List<String> BAZEL_PREFIXES = List.of("processed_", "header_");

    private JavaLibraryUtil() {
    }

    @NotNull
    private static synchronized String intern(@NotNull String str) {
        if (str == null) {
            JavaLibraryUtil.$$$reportNull$$$0(0);
        }
        String string = (String)INTERNER.intern((Object)str);
        if (string == null) {
            JavaLibraryUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static MavenCoordinates getMavenCoordinates(@NotNull Library library) {
        LibraryProperties libraryProperties;
        if (library == null) {
            JavaLibraryUtil.$$$reportNull$$$0(2);
        }
        if (library instanceof LibraryEx && (libraryProperties = ((LibraryEx)library).getProperties()) instanceof LibraryWithMavenCoordinatesProperties) {
            return ((LibraryWithMavenCoordinatesProperties)libraryProperties).getMavenCoordinates();
        }
        ProgressManager.checkCanceled();
        String name = library.getName();
        if (name == null) {
            return null;
        }
        String coordinatesString = StringUtil.substringAfter((String)name, (String)": ");
        if (coordinatesString == null) {
            return null;
        }
        List parts = StringUtil.split((String)coordinatesString, (String)":");
        if (parts.size() < 3) {
            return null;
        }
        return new MavenCoordinates(JavaLibraryUtil.intern((String)parts.get(0)), JavaLibraryUtil.intern((String)parts.get(1)), JavaLibraryUtil.intern((String)parts.getLast()));
    }

    @RequiresReadLock
    public static boolean hasLibraryClass(@Nullable Project project, @NotNull String classFqn) {
        if (classFqn == null) {
            JavaLibraryUtil.$$$reportNull$$$0(3);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (project == null || project.isDisposed()) {
            return false;
        }
        if (project.isDefault()) {
            return false;
        }
        return JavaLibraryUtil.getLibraryClassMap(project).getOrDefault(classFqn, Boolean.FALSE);
    }

    @RequiresReadLock
    public static boolean hasLibraryClass(@Nullable Module module, @NotNull String classFqn) {
        if (classFqn == null) {
            JavaLibraryUtil.$$$reportNull$$$0(4);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (module.getProject().isDefault()) {
            return false;
        }
        return JavaLibraryUtil.getLibraryClassMap(module).getOrDefault(classFqn, Boolean.FALSE);
    }

    private static Map<String, Boolean> getLibraryClassMap(@NotNull Project project) {
        if (project == null) {
            JavaLibraryUtil.$$$reportNull$$$0(5);
        }
        if (DumbService.isDumb((Project)project)) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, LIBRARY_CLASSES_PRESENCE_KEY, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(classFqn -> {
                boolean hasClass = JavaPsiFacade.getInstance((Project)project).hasClass(classFqn, GlobalSearchScope.allScope((Project)project));
                return hasClass;
            });
            return JavaLibraryUtil.createResultWithDependencies(map, project);
        }, false);
    }

    private static Map<String, Boolean> getLibraryClassMap(@NotNull Module module) {
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(6);
        }
        if (DumbService.isDumb((Project)module.getProject())) {
            return Collections.emptyMap();
        }
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, LIBRARY_CLASSES_PRESENCE_KEY, () -> {
            Project project = module.getProject();
            ConcurrentMap map = ConcurrentFactoryMap.createMap(classFqn -> {
                boolean hasClass = JavaPsiFacade.getInstance((Project)project).hasClass(classFqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
                return hasClass;
            });
            return JavaLibraryUtil.createResultWithDependencies(map, project);
        }, false);
    }

    private static CachedValueProvider.Result<Map<String, Boolean>> createResultWithDependencies(@NotNull Map<String, Boolean> map, @NotNull Project project) {
        if (map == null) {
            JavaLibraryUtil.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JavaLibraryUtil.$$$reportNull$$$0(8);
        }
        return CachedValueProvider.Result.create(map, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance(project)});
    }

    @RequiresReadLock
    public static boolean hasLibraryJar(@Nullable Project project, @NotNull String mavenCoords) {
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(9);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (project == null || project.isDisposed()) {
            return false;
        }
        if (project.isDefault()) {
            return false;
        }
        return JavaLibraryUtil.getProjectLibraries(project).contains(mavenCoords);
    }

    @RequiresReadLock
    public static boolean hasAnyLibraryJar(@Nullable Project project, @NotNull Collection<String> mavenCoords) {
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(10);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (project == null || project.isDisposed()) {
            return false;
        }
        if (project.isDefault()) {
            return false;
        }
        Libraries libraries = JavaLibraryUtil.getProjectLibraries(project);
        for (String coord : mavenCoords) {
            if (!libraries.contains(coord)) continue;
            return true;
        }
        return false;
    }

    @RequiresReadLock
    public static boolean hasLibraryJar(@Nullable Module module, @NotNull String mavenCoords) {
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (module.getProject().isDefault()) {
            return false;
        }
        return JavaLibraryUtil.getModuleLibraries(module).contains(mavenCoords);
    }

    @RequiresReadLock
    public static boolean hasAnyLibraryJar(@Nullable Module module, @NotNull Collection<String> mavenCoords) {
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(12);
        }
        ThreadingAssertions.softAssertReadAccess();
        if (module == null || module.isDisposed()) {
            return false;
        }
        if (module.getProject().isDefault()) {
            return false;
        }
        Libraries libraries = JavaLibraryUtil.getModuleLibraries(module);
        for (String coord : mavenCoords) {
            if (!libraries.contains(coord)) continue;
            return true;
        }
        return false;
    }

    @RequiresReadLock
    @Nullable
    public static String getLibraryVersion(@NotNull Module module, @NotNull String mavenCoords) {
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(13);
        }
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(14);
        }
        ThreadingAssertions.softAssertReadAccess();
        return JavaLibraryUtil.getLibraryVersion(module, mavenCoords, null);
    }

    @RequiresReadLock
    @Nullable
    public static String getLibraryVersion(@NotNull Module module, @NotNull String mavenCoords, @Nullable Attributes.Name versionAttribute) {
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(15);
        }
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(16);
        }
        ThreadingAssertions.softAssertReadAccess();
        String externalSystemId = ExternalSystemModulePropertyManager.getInstance((Module)module).getExternalSystemId();
        if (JavaLibraryUtil.isUnsupportedBuildSystem(externalSystemId)) {
            return JavaLibraryUtil.getJpsLibraryVersion(module, mavenCoords, versionAttribute);
        }
        return JavaLibraryUtil.getExternalSystemLibraryVersion(module, mavenCoords);
    }

    @Nullable
    private static String getJpsLibraryVersion(@NotNull Module module, @NotNull String mavenCoords, @Nullable Attributes.Name versionAttribute) {
        String name;
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(17);
        }
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(18);
        }
        if ((name = StringUtil.substringAfter((String)mavenCoords, (String)":")) == null) {
            return null;
        }
        Ref result = new Ref();
        OrderEnumerator.orderEntries((Module)module).recursively().forEachLibrary(library -> {
            VirtualFile[] libraryFiles;
            for (VirtualFile libraryFile : libraryFiles = library.getFiles(OrderRootType.CLASSES)) {
                VirtualFile jarFile;
                if (!JavaLibraryUtil.matchLibraryName(JavaLibraryUtil.sanitizeLibraryName(libraryFile.getNameWithoutExtension()), name) || (jarFile = JarFileSystem.getInstance().getVirtualFileForJar(libraryFile)) == null) continue;
                String version = JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)jarFile), (Attributes.Name)Attributes.Name.IMPLEMENTATION_VERSION);
                if (version == null && versionAttribute != null) {
                    version = JarUtil.getJarAttribute((File)VfsUtilCore.virtualToIoFile((VirtualFile)jarFile), (Attributes.Name)versionAttribute);
                }
                if (version == null) continue;
                result.set((Object)version);
                return false;
            }
            return true;
        });
        return (String)result.get();
    }

    @Nullable
    private static String getExternalSystemLibraryVersion(@NotNull Module module, @NotNull String mavenCoords) {
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(19);
        }
        if (mavenCoords == null) {
            JavaLibraryUtil.$$$reportNull$$$0(20);
        }
        Ref result = new Ref();
        OrderEnumerator.orderEntries((Module)module).recursively().forEachLibrary(library -> {
            String location;
            MavenCoordinates coordinates = JavaLibraryUtil.getMavenCoordinates(library);
            if (coordinates != null && (location = coordinates.getGroupId() + ":" + coordinates.getArtifactId()).equals(mavenCoords)) {
                result.set((Object)coordinates.getVersion());
                return false;
            }
            return true;
        });
        return (String)result.get();
    }

    @NotNull
    private static Libraries getProjectLibraries(@NotNull Project project) {
        if (project == null) {
            JavaLibraryUtil.$$$reportNull$$$0(21);
        }
        Libraries libraries = JavaLibraryHolder.getInstance(project).getLibraries();
        if (libraries == null) {
            JavaLibraryUtil.$$$reportNull$$$0(22);
        }
        return libraries;
    }

    @NotNull
    private static Libraries getModuleLibraries(@NotNull Module module) {
        if (module == null) {
            JavaLibraryUtil.$$$reportNull$$$0(23);
        }
        Libraries libraries = (Libraries)CachedValuesManager.getManager((Project)module.getProject()).getParameterizedCachedValue((UserDataHolder)module, MAVEN_LIBRARIES_MODULE_KEY, MAVEN_LIBRARIES_MODULE_PROVIDER, false, (Object)module);
        if (libraries == null) {
            JavaLibraryUtil.$$$reportNull$$$0(24);
        }
        return libraries;
    }

    private static boolean isUnsupportedBuildSystem(@Nullable String externalSystemId) {
        return externalSystemId == null || "Blaze".equals(externalSystemId);
    }

    @NotNull
    static Libraries fillLibraries(OrderEnumerator orderEnumerator, boolean collectFiles) {
        HashSet allMavenCoords = new HashSet();
        HashMap jarLibrariesIndex = new HashMap();
        orderEnumerator.recursively().forEachLibrary(library -> {
            LibraryProperties libraryProperties;
            MavenCoordinates coordinates = JavaLibraryUtil.getMavenCoordinates(library);
            if (coordinates != null && allMavenCoords.add(JavaLibraryUtil.intern(coordinates.getGroupId() + ":" + coordinates.getArtifactId()))) {
                ProgressManager.checkCanceled();
            }
            if (collectFiles && library instanceof LibraryEx && ((libraryProperties = ((LibraryEx)library).getProperties()) == null || libraryProperties instanceof RepositoryLibraryProperties)) {
                JavaLibraryUtil.collectFiles(library, coordinates, jarLibrariesIndex);
            }
            return true;
        });
        return new Libraries(Set.copyOf(allMavenCoords), Map.copyOf(jarLibrariesIndex));
    }

    private static void collectFiles(@NotNull Library library, @Nullable MavenCoordinates coordinates, @NotNull Map<String, String> jarLibrariesIndex) {
        if (library == null) {
            JavaLibraryUtil.$$$reportNull$$$0(25);
        }
        if (jarLibrariesIndex == null) {
            JavaLibraryUtil.$$$reportNull$$$0(26);
        }
        ProgressManager.checkCanceled();
        VirtualFile[] libraryFiles = library.getFiles(OrderRootType.CLASSES);
        if (coordinates == null || libraryFiles.length > 1) {
            JarFileSystem jarFileSystem = JarFileSystem.getInstance();
            for (VirtualFile libraryFile : libraryFiles) {
                if (libraryFile.getFileSystem() != jarFileSystem) continue;
                ProgressManager.checkCanceled();
                String nameWithoutExtension = libraryFile.getNameWithoutExtension();
                nameWithoutExtension = JavaLibraryUtil.intern(JavaLibraryUtil.sanitizeLibraryName(nameWithoutExtension));
                jarLibrariesIndex.put(nameWithoutExtension, nameWithoutExtension);
                String indexNamePart = JavaLibraryUtil.baseName(nameWithoutExtension);
                if (indexNamePart.equals(nameWithoutExtension)) continue;
                jarLibrariesIndex.put(indexNamePart, JavaLibraryUtil.intern(nameWithoutExtension));
            }
        }
    }

    @NotNull
    private static String baseName(String name) {
        int index = -1;
        int length = name.length();
        while (!((index = name.indexOf(45, index + 1)) < 0 || index + 1 < length && StringUtil.isDecimalDigit((char)name.charAt(index + 1)) || index >= length)) {
        }
        String string = index < 0 ? name : name.substring(0, index);
        if (string == null) {
            JavaLibraryUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    @NotNull
    private static String sanitizeLibraryName(@NotNull String nameWithoutExtension) {
        if (nameWithoutExtension == null) {
            JavaLibraryUtil.$$$reportNull$$$0(28);
        }
        String name = nameWithoutExtension;
        for (String prefix : BAZEL_PREFIXES) {
            name = StringsKt.removePrefix((String)name, (CharSequence)prefix);
        }
        String string = name;
        if (string == null) {
            JavaLibraryUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    static boolean matchLibraryName(@NotNull String fileName, @NotNull String libraryName) {
        if (fileName == null) {
            JavaLibraryUtil.$$$reportNull$$$0(30);
        }
        if (libraryName == null) {
            JavaLibraryUtil.$$$reportNull$$$0(31);
        }
        if (fileName.equals(libraryName)) {
            return true;
        }
        String prefix = libraryName + "-";
        if (!fileName.startsWith(prefix)) {
            return false;
        }
        if (fileName.length() == prefix.length()) {
            return false;
        }
        char versionStart = fileName.charAt(prefix.length());
        return StringUtil.isDecimalDigit((char)versionStart);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 22, 24, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 1: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/library/JavaLibraryUtil";
                break;
            }
            case 2: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 5: 
            case 8: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenCoords";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarLibrariesIndex";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameWithoutExtension";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/library/JavaLibraryUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLibraries";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleLibraries";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "baseName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: 
            case 22: 
            case 24: 
            case 27: 
            case 29: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMavenCoordinates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasLibraryClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryClassMap";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createResultWithDependencies";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasLibraryJar";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyLibraryJar";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryVersion";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJpsLibraryVersion";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExternalSystemLibraryVersion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProjectLibraries";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getModuleLibraries";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectFiles";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeLibraryName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "matchLibraryName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 22, 24, 27, 29 -> new IllegalStateException(string);
        };
    }
}

