/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.MappingClass;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassMappingNameConverter
extends ResolvingConverter.StringConverter {
    private static final Logger LOG = Logger.getInstance(ClassMappingNameConverter.class);

    @NotNull
    public Collection<String> getVariants(@NotNull ConvertContext context) {
        PsiType type;
        if (context == null) {
            ClassMappingNameConverter.$$$reportNull$$$0(0);
        }
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        List children = DomUtil.getDefinedChildren((DomElement)parent, (boolean)true, (boolean)true);
        DomElement classElement = (DomElement)ContainerUtil.find((Iterable)children, domElement -> domElement.getAnnotation(MappingClass.class) != null);
        if (classElement == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ClassMappingNameConverter.$$$reportNull$$$0(1);
            }
            return list;
        }
        Object value = ((GenericDomValue)classElement).getValue();
        if (value == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ClassMappingNameConverter.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (value instanceof PsiType) {
            type = (PsiType)value;
        } else if (value instanceof PsiClass) {
            type = PsiTypesUtil.getClassType((PsiClass)((PsiClass)value));
        } else {
            LOG.error("wrong type: " + String.valueOf(value.getClass()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                ClassMappingNameConverter.$$$reportNull$$$0(3);
            }
            return list;
        }
        JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)context.getProject());
        SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, type);
        List<String> list = Arrays.asList(info.names);
        if (list == null) {
            ClassMappingNameConverter.$$$reportNull$$$0(4);
        }
        return list;
    }

    public PsiElement resolve(String o, @NotNull ConvertContext context) {
        if (context == null) {
            ClassMappingNameConverter.$$$reportNull$$$0(5);
        }
        DomElement parent = context.getInvocationElement().getParent();
        assert (parent != null);
        return parent.getXmlElement();
    }

    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable String resolveResult, @NotNull ConvertContext context) {
        if (element == null) {
            ClassMappingNameConverter.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ClassMappingNameConverter.$$$reportNull$$$0(7);
        }
        return element.getManager().areElementsEquivalent(element, this.resolve(stringValue, context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/ClassMappingNameConverter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/ClassMappingNameConverter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getVariants";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4 -> new IllegalStateException(string);
        };
    }
}

