/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.AuthData;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import git4idea.DialogManager;
import git4idea.i18n.GitBundle;
import git4idea.remote.InteractiveGitHttpAuthDataProvider;
import java.awt.Component;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0017J \u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHSelectAccountHttpAuthDataProvider;", "Lgit4idea/remote/InteractiveGitHttpAuthDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "potentialAccounts", "", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getAuthData", "Lcom/intellij/util/AuthData;", "parentComponent", "Ljava/awt/Component;", "chooseAccount", "Lkotlin/Pair;", "", "intellij.vcs.github"})
public final class GHSelectAccountHttpAuthDataProvider
implements InteractiveGitHttpAuthDataProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<GithubAccount, String> potentialAccounts;

    public GHSelectAccountHttpAuthDataProvider(@NotNull Project project, @NotNull Map<GithubAccount, String> potentialAccounts) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(potentialAccounts, (String)"potentialAccounts");
        this.project = project;
        this.potentialAccounts = potentialAccounts;
    }

    @RequiresEdt
    @Nullable
    public AuthData getAuthData(@Nullable Component parentComponent) {
        Pair<GithubAccount, Boolean> pair = this.chooseAccount(parentComponent);
        if (pair == null) {
            return null;
        }
        Pair<GithubAccount, Boolean> pair2 = pair;
        GithubAccount account = (GithubAccount)((Object)pair2.component1());
        boolean setDefault = (Boolean)pair2.component2();
        String string = this.potentialAccounts.get((Object)account);
        if (string == null && (string = GHAccountsUtil.requestNewToken(account, this.project, parentComponent, GHLoginSource.GIT)) == null) {
            return null;
        }
        String token2 = string;
        if (setDefault) {
            GHAccountsUtil.setDefaultAccount(this.project, account);
        }
        return new GHAccountAuthData(account, "x-oauth-basic", token2);
    }

    private final Pair<GithubAccount, Boolean> chooseAccount(Component parentComponent) {
        Collection collection = this.potentialAccounts.keySet();
        String string = GithubBundle.message("account.choose.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = GitBundle.message((String)"login.dialog.button.login", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        GithubChooseAccountDialog dialog = new GithubChooseAccountDialog(this.project, parentComponent, collection, null, false, true, string, string2);
        DialogManager.show((DialogWrapper)dialog);
        return dialog.isOK() ? TuplesKt.to((Object)((Object)dialog.getAccount()), (Object)dialog.getSetDefault()) : null;
    }
}

