/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.XmlElementStorage;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.externalSystem.configurationStore.ExternalStorageSaveSessionProducer;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStorageKt;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStreamProviderFactory;
import com.intellij.openapi.externalSystem.configurationStore.FileSystemExternalSystemStorage;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.platform.settings.SettingsController;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalModuleStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "module", "Lcom/intellij/openapi/module/Module;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "<init>", "(Lcom/intellij/openapi/module/Module;Lcom/intellij/configurationStore/StateStorageManager;)V", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "manager", "Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "loadLocalData", "Lorg/jdom/Element;", "createSaveSession", "Lcom/intellij/configurationStore/SaveSessionProducer;", "states", "Lcom/intellij/configurationStore/StateMap;", "intellij.platform.externalSystem.impl"})
public final class ExternalModuleStorage
extends XmlElementStorage {
    @NotNull
    private final Module module;
    @NotNull
    private final ExternalSystemStreamProviderFactory manager;

    public ExternalModuleStorage(@NotNull Module module, @NotNull StateStorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        super("$MODULE_FILE$", "module", storageManager.getMacroSubstitutor(), RoamingType.DISABLED, null, null, 48, null);
        this.module = module;
        Project project = this.module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.manager = ExternalSystemStorageKt.access$findExternalSystemStreamProviderFactory(project);
    }

    @Nullable
    public SettingsController getController() {
        return null;
    }

    @Nullable
    protected Element loadLocalData() {
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.manager.readModuleData(string);
    }

    @NotNull
    protected SaveSessionProducer createSaveSession(@NotNull StateMap states) {
        Intrinsics.checkNotNullParameter((Object)states, (String)"states");
        XmlElementStorage xmlElementStorage = this;
        FileSystemExternalSystemStorage fileSystemExternalSystemStorage = this.manager.getModuleStorage();
        String string = this.module.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (SaveSessionProducer)new ExternalStorageSaveSessionProducer(states, xmlElementStorage, fileSystemExternalSystemStorage, string, null, 16, null);
    }
}

