/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.execution;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.ui.DefaultExternalSystemUiAware;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemTaskConfigurationType
implements ConfigurationType {
    private final ProjectSystemId myExternalSystemId;
    private final ConfigurationFactory[] myFactories;
    private final NotNullLazyValue<Icon> myIcon;

    protected AbstractExternalSystemTaskConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(0);
        }
        this.myFactories = new ConfigurationFactory[1];
        this.myExternalSystemId = externalSystemId;
        this.myFactories[0] = new ConfigurationFactory(this){

            @NotNull
            public RunConfiguration createTemplateConfiguration(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExternalSystemRunConfiguration externalSystemRunConfiguration = AbstractExternalSystemTaskConfigurationType.this.doCreateConfiguration(AbstractExternalSystemTaskConfigurationType.this.myExternalSystemId, project, this, "");
                if (externalSystemRunConfiguration == null) {
                    1.$$$reportNull$$$0(1);
                }
                return externalSystemRunConfiguration;
            }

            @NotNull
            public String getId() {
                String string = AbstractExternalSystemTaskConfigurationType.this.getConfigurationFactoryId();
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            public boolean isEditableInDumbMode() {
                return AbstractExternalSystemTaskConfigurationType.this.isEditableInDumbMode();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createTemplateConfiguration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createTemplateConfiguration";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
        this.myIcon = NotNullLazyValue.createValue(() -> {
            ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.myExternalSystemId);
            Icon result = null;
            if (manager instanceof ExternalSystemUiAware) {
                result = ((ExternalSystemUiAware)manager).getProjectIcon();
            }
            return result == null ? DefaultExternalSystemUiAware.INSTANCE.getTaskIcon() : result;
        });
    }

    protected boolean isEditableInDumbMode() {
        return false;
    }

    @NonNls
    @NotNull
    protected String getConfigurationFactoryId() {
        PluginException.reportDeprecatedDefault(this.getClass(), (String)"getConfigurationFactoryId", (String)"The default implementation delegates to 'ProjectSystemId::getReadableName' which is supposed to be localized, but return value of this method must not be localized.");
        String string = this.myExternalSystemId.getReadableName();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public ProjectSystemId getExternalSystemId() {
        ProjectSystemId projectSystemId = this.myExternalSystemId;
        if (projectSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(2);
        }
        return projectSystemId;
    }

    @NotNull
    public ConfigurationFactory getFactory() {
        ConfigurationFactory configurationFactory = this.myFactories[0];
        if (configurationFactory == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(3);
        }
        return configurationFactory;
    }

    @NotNull
    protected ExternalSystemRunConfiguration doCreateConfiguration(@NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ConfigurationFactory factory, @NotNull String name) {
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(4);
        }
        if (project == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(5);
        }
        if (factory == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(6);
        }
        if (name == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(7);
        }
        return new ExternalSystemRunConfiguration(externalSystemId, project, factory, name);
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myExternalSystemId.getReadableName();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(8);
        }
        return string;
    }

    public String getConfigurationTypeDescription() {
        return ExternalSystemBundle.message((String)"run.configuration.description", (Object[])new Object[]{this.myExternalSystemId.getReadableName()});
    }

    public Icon getIcon() {
        return (Icon)this.myIcon.getValue();
    }

    @NotNull
    public String getId() {
        String string = this.myExternalSystemId.getReadableName() + "RunConfiguration";
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(9);
        }
        return string;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return this.myFactories;
    }

    @NotNull
    @NlsActions.ActionText
    public static String generateName(@NotNull Project project, @NotNull ExternalSystemTaskExecutionSettings settings) {
        if (project == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(10);
        }
        if (settings == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(11);
        }
        return AbstractExternalSystemTaskConfigurationType.generateName(project, settings.getExternalSystemId(), settings.getExternalProjectPath(), settings.getTaskNames(), settings.getExecutionName());
    }

    @NotNull
    @NlsActions.ActionText
    public static String generateName(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable @Nls String executionName) {
        if (project == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(12);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(13);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(14);
        }
        return AbstractExternalSystemTaskConfigurationType.generateName(project, externalSystemId, externalProjectPath, taskNames, executionName, " [", "]");
    }

    @NotNull
    @NlsActions.ActionText
    public static String generateName(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable String externalProjectPath, @NotNull List<String> taskNames, @Nullable @Nls String executionName, @NotNull String tasksPrefix, @NotNull String tasksPostfix) {
        String projectName;
        ExternalProjectInfo projectInfo;
        if (project == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(15);
        }
        if (externalSystemId == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(16);
        }
        if (taskNames == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(17);
        }
        if (tasksPrefix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(18);
        }
        if (tasksPostfix == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(19);
        }
        if (!StringUtil.isEmpty((String)executionName)) {
            String string = executionName;
            if (string == null) {
                AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(20);
            }
            return string;
        }
        boolean isTasksAbsent = taskNames.isEmpty();
        String rootProjectPath = null;
        if (externalProjectPath != null && (projectInfo = ExternalSystemUtil.getExternalProjectInfo(project, externalSystemId, externalProjectPath)) != null) {
            rootProjectPath = projectInfo.getExternalProjectPath();
        }
        @Nls StringBuilder buffer = new StringBuilder();
        if (rootProjectPath == null) {
            projectName = null;
        } else {
            ExternalSystemUiAware uiAware = ExternalSystemUiUtil.getUiAware(externalSystemId);
            projectName = uiAware.getProjectRepresentationName(project, externalProjectPath, rootProjectPath);
        }
        if (!StringUtil.isEmptyOrSpaces(projectName)) {
            buffer.append(projectName);
        } else if (!StringUtil.isEmptyOrSpaces((String)externalProjectPath)) {
            buffer.append(externalProjectPath);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPrefix);
        }
        if (!StringUtil.isEmpty((String)executionName)) {
            buffer.append(executionName);
        } else if (!isTasksAbsent) {
            for (String taskName : taskNames) {
                buffer.append(taskName).append(' ');
            }
            buffer.setLength(buffer.length() - 1);
        }
        if (!isTasksAbsent) {
            buffer.append(tasksPostfix);
        }
        if (buffer.isEmpty()) {
            buffer.append(ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]));
        }
        String string = buffer.toString();
        if (string == null) {
            AbstractExternalSystemTaskConfigurationType.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8, 9, 20, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskNames";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPrefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasksPostfix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/execution/AbstractExternalSystemTaskConfigurationType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactoryId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalSystemId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 20: 
            case 21: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doCreateConfiguration";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8, 9, 20, 21 -> new IllegalStateException(string);
        };
    }
}

