/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui.project.path;

import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.service.ui.project.path.ExternalProject;
import com.intellij.openapi.externalSystem.service.ui.project.path.WorkingDirectoryInfo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.UiUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00180\t\u00a2\u0006\u0002\b\n\u00a2\u0006\u000e\b\u000b\u0012\n\b\f\u0012\u0006\b\n0\r8\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/intellij/openapi/externalSystem/service/ui/project/path/ExternalSystemWorkingDirectoryInfo;", "Lcom/intellij/openapi/externalSystem/service/ui/project/path/WorkingDirectoryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "externalSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;)V", "readableName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "capitalization", "Lorg/jetbrains/annotations/Nls$Capitalization;", "Title", "editorLabel", "getEditorLabel", "()Ljava/lang/String;", "settingsName", "getSettingsName", "fileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getFileChooserDescriptor", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "emptyFieldError", "getEmptyFieldError", "collectExternalProjects", "", "Lcom/intellij/openapi/externalSystem/service/ui/project/path/ExternalProject;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.externalSystem.impl"})
public final class ExternalSystemWorkingDirectoryInfo
implements WorkingDirectoryInfo {
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectSystemId externalSystemId;
    @NotNull
    private final String readableName;
    @NotNull
    private final String editorLabel;
    @NotNull
    private final String settingsName;
    @NotNull
    private final FileChooserDescriptor fileChooserDescriptor;
    @NotNull
    private final String emptyFieldError;

    public ExternalSystemWorkingDirectoryInfo(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)externalSystemId, (String)"externalSystemId");
        this.project = project;
        this.externalSystemId = externalSystemId;
        String string = this.externalSystemId.getReadableName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getReadableName(...)");
        this.readableName = string;
        Object[] objectArray = new Object[]{this.readableName};
        String string2 = ExternalSystemBundle.message((String)"run.configuration.project.path.label", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        this.editorLabel = string2;
        objectArray = new Object[]{this.readableName};
        String string3 = ExternalSystemBundle.message((String)"run.configuration.project.path.name", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        this.settingsName = string3;
        objectArray = new Object[]{this.readableName};
        FileChooserDescriptor fileChooserDescriptor = ExternalSystemApiUtil.getExternalProjectConfigDescriptor((ProjectSystemId)this.externalSystemId).withTitle(ExternalSystemBundle.message((String)"settings.label.select.project", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withTitle(...)");
        this.fileChooserDescriptor = fileChooserDescriptor;
        objectArray = new Object[]{this.readableName};
        String string4 = ExternalSystemBundle.message((String)"run.configuration.project.path.empty.error", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        this.emptyFieldError = string4;
    }

    @Override
    @NotNull
    public String getEditorLabel() {
        return this.editorLabel;
    }

    @Override
    @NotNull
    public String getSettingsName() {
        return this.settingsName;
    }

    @NotNull
    public FileChooserDescriptor getFileChooserDescriptor() {
        return this.fileChooserDescriptor;
    }

    @Override
    @NotNull
    public String getEmptyFieldError() {
        return this.emptyFieldError;
    }

    @Override
    @Nullable
    public Object collectExternalProjects(@NotNull Continuation<? super List<ExternalProject>> $completion) {
        ArrayList<ExternalProject> externalProjects = new ArrayList<ExternalProject>();
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)this.project, (ProjectSystemId)this.externalSystemId);
        ExternalSystemUiAware externalSystemUiAware = ExternalSystemUiUtil.getUiAware(this.externalSystemId);
        Intrinsics.checkNotNullExpressionValue((Object)externalSystemUiAware, (String)"getUiAware(...)");
        ExternalSystemUiAware uiAware = externalSystemUiAware;
        Map map = localSettings.getAvailableProjects();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getAvailableProjects(...)");
        for (Map.Entry entry : map.entrySet()) {
            String parentName;
            ExternalProjectPojo parent = (ExternalProjectPojo)entry.getKey();
            Collection children = (Collection)entry.getValue();
            String string = parent.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String parentPath = UiUtils.getCanonicalPath$default((String)string, (boolean)false, (int)2, null);
            Intrinsics.checkNotNullExpressionValue((Object)uiAware.getProjectRepresentationName(this.project, parentPath, null), (String)"getProjectRepresentationName(...)");
            externalProjects.add(new ExternalProject(parentName, parentPath));
            for (ExternalProjectPojo child : children) {
                String childName;
                String string2 = child.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String childPath = UiUtils.getCanonicalPath$default((String)string2, (boolean)false, (int)2, null);
                if (Intrinsics.areEqual((Object)parentPath, (Object)childPath)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)uiAware.getProjectRepresentationName(this.project, childPath, parentPath), (String)"getProjectRepresentationName(...)");
                externalProjects.add(new ExternalProject(childName, childPath));
            }
        }
        return externalProjects;
    }
}

