/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface ExternalSystemTaskUnderProgress {
    @Nullable
    default public Object getId() {
        return null;
    }

    public void execute(@NotNull ProgressIndicator var1);

    public static void executeTaskUnderProgress(@NotNull Project project, @NotNull @Nls String title, @NotNull ProgressExecutionMode progressExecutionMode, final @NotNull ExternalSystemTaskUnderProgress task) {
        if (project == null) {
            ExternalSystemTaskUnderProgress.$$$reportNull$$$0(0);
        }
        if (title == null) {
            ExternalSystemTaskUnderProgress.$$$reportNull$$$0(1);
        }
        if (progressExecutionMode == null) {
            ExternalSystemTaskUnderProgress.$$$reportNull$$$0(2);
        }
        if (task == null) {
            ExternalSystemTaskUnderProgress.$$$reportNull$$$0(3);
        }
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: {
                task.execute((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
            case MODAL_SYNC: {
                new Task.Modal(project, title, true){

                    @Nullable
                    public Object getId() {
                        return task.getId();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemTaskUnderProgress$1", "run"));
                    }
                }.queue();
                break;
            }
            case NO_PROGRESS_ASYNC: {
                ApplicationManager.getApplication().executeOnPooledThread(() -> task.execute((ProgressIndicator)new EmptyProgressIndicator()));
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                new Task.Backgroundable(project, title){

                    @Nullable
                    public Object getId() {
                        return task.getId();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemTaskUnderProgress$2", "run"));
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                new Task.Backgroundable(project, title, true, PerformInBackgroundOption.DEAF){

                    @Nullable
                    public Object getId() {
                        return task.getId();
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        task.execute(indicator);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/externalSystem/util/ExternalSystemTaskUnderProgress$3", "run"));
                    }
                }.queue();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "title";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "progressExecutionMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "task";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/externalSystem/util/ExternalSystemTaskUnderProgress";
        objectArray[2] = "executeTaskUnderProgress";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

