/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ant;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestion;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProvider;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginSuggestionProviderKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/ide/ant/AntSuggestionProvider;", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestionProvider;", "<init>", "()V", "getSuggestion", "Lcom/intellij/openapi/updateSettings/impl/pluginsAdvertisement/PluginSuggestion;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isAntBuild", "", "intellij.java.ui"})
public final class AntSuggestionProvider
implements PluginSuggestionProvider {
    @Nullable
    public PluginSuggestion getSuggestion(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!Intrinsics.areEqual((Object)file.getName(), (Object)"build.xml") || !this.isAntBuild(project2, file)) {
            return null;
        }
        return PluginSuggestionProviderKt.buildSuggestionForFileIfNeeded((Project)project2, (String)"AntSupport", (String)"Ant", (String)"Ant", (String)"ant.suggestion.dismissed");
    }

    private final boolean isAntBuild(Project project2, VirtualFile file) {
        XmlTag rootTag;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(file);
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return false;
        }
        XmlFile xmlFile2 = xmlFile;
        XmlTag xmlTag = rootTag = xmlFile2.getRootTag();
        if (!Intrinsics.areEqual((Object)(xmlTag != null ? xmlTag.getName() : null), (Object)"project")) {
            return false;
        }
        return rootTag.getAttribute("default") != null;
    }
}

