/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.impl;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.impl.NewProjectUtilKt;
import com.intellij.ide.projectWizard.NewProjectWizardCollector;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.platform.ide.progress.ModalTaskOwner;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ide/impl/NewProjectUtil;", "", "<init>", "()V", "createNewProject", "", "projectToClose", "Lcom/intellij/openapi/project/Project;", "wizard", "Lcom/intellij/ide/util/newProjectWizard/AbstractProjectWizard;", "createFromWizard", "setCompilerOutputPath", "project", "path", "", "applyJdkToProject", "jdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.java.ui"})
public final class NewProjectUtil {
    @NotNull
    public static final NewProjectUtil INSTANCE = new NewProjectUtil();

    private NewProjectUtil() {
    }

    @JvmStatic
    @Deprecated(message="Use {@link #createNewProject(AbstractProjectWizard)}, projectToClose param is not used.", replaceWith=@ReplaceWith(expression="createNewProject(wizard)", imports={"com.intellij.ide.impl.NewProjectUtil.createNewProject"}))
    public static final void createNewProject(@Nullable Project projectToClose, @NotNull AbstractProjectWizard wizard2) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard2), (String)"wizard");
        NewProjectUtil.createNewProject(wizard2);
    }

    @JvmStatic
    @Deprecated(message="Use {@link #createNewProjectAsync(AbstractProjectWizard, Project)}")
    public static final void createNewProject(@NotNull AbstractProjectWizard wizard2) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard2), (String)"wizard");
        ProjectManager.getInstance().getDefaultProject();
        WizardContext wizardContext = wizard2.getWizardContext();
        Intrinsics.checkNotNullExpressionValue((Object)wizardContext, (String)"getWizardContext(...)");
        WizardContext context = wizardContext;
        long time = System.nanoTime();
        NewProjectWizardCollector.logOpen((WizardContext)context);
        if (wizard2.showAndGet()) {
            NewProjectUtil.createFromWizard$default(wizard2, null, 2, null);
            NewProjectWizardCollector.logFinish((WizardContext)context, (boolean)true, (long)TimeoutUtil.getDurationMillis((long)time));
        } else {
            NewProjectWizardCollector.logFinish((WizardContext)context, (boolean)false, (long)TimeoutUtil.getDurationMillis((long)time));
        }
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Project createFromWizard(@NotNull AbstractProjectWizard wizard2, @Nullable Project projectToClose) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard2), (String)"wizard");
        try {
            Path projectFile = Path.of(wizard2.getNewProjectFilePath(), new String[0]);
            ModalTaskOwner modalTaskOwner = ModalTaskOwner.guess();
            Intrinsics.checkNotNullExpressionValue((Object)modalTaskOwner, (String)"guess(...)");
            Object[] objectArray = new Object[]{((Object)projectFile.getFileName()).toString()};
            String string = IdeUICustomization.getInstance().projectMessage("progress.title.project.loading.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"projectMessage(...)");
            Project newProject2 = (Project)TasksKt.runWithModalProgressBlocking$default((ModalTaskOwner)modalTaskOwner, (String)string, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Project>, Object>(wizard2, projectFile, projectToClose, null){
                int label;
                final /* synthetic */ AbstractProjectWizard $wizard;
                final /* synthetic */ Path $projectFile;
                final /* synthetic */ Project $projectToClose;
                {
                    this.$wizard = $wizard;
                    this.$projectFile = $projectFile;
                    this.$projectToClose = $projectToClose;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Path path = this.$projectFile;
                            Intrinsics.checkNotNull((Object)path);
                            this.label = 1;
                            Object object2 = NewProjectUtilKt.createProjectFromWizardImpl(this.$wizard, path, this.$projectToClose, (Continuation<? super Project>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Project> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)4, null);
            WizardContext wizardContext = wizard2.getWizardContext();
            Intrinsics.checkNotNullExpressionValue((Object)wizardContext, (String)"getWizardContext(...)");
            NewProjectWizardCollector.logProjectCreated((Project)newProject2, (WizardContext)wizardContext);
            return newProject2;
        }
        catch (IOException e) {
            AppUIUtil.invokeOnEdt(() -> NewProjectUtil.createFromWizard$lambda$0(e));
            return null;
        }
    }

    public static /* synthetic */ Project createFromWizard$default(AbstractProjectWizard abstractProjectWizard, Project project2, int n, Object object) {
        if ((n & 2) != 0) {
            project2 = null;
        }
        return NewProjectUtil.createFromWizard(abstractProjectWizard, project2);
    }

    public final void setCompilerOutputPath(@NotNull Project project2, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)project2);
        if (compilerProjectExtension == null) {
            return;
        }
        CompilerProjectExtension extension = compilerProjectExtension;
        CommandProcessor.getInstance().executeCommand(project2, () -> NewProjectUtil.setCompilerOutputPath$lambda$0(path, extension), null, null);
    }

    @JvmStatic
    @Deprecated(message="Use JavaSdkUtil.applyJdkToProject() directly ", replaceWith=@ReplaceWith(expression="JavaSdkUtil.applyJdkToProject(project, jdk)", imports={"com.intellij.openapi.projectRoots.ex.JavaSdkUtil"}))
    public static final void applyJdkToProject(@NotNull Project project2, @NotNull Sdk jdk) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jdk, (String)"jdk");
        JavaSdkUtil.applyJdkToProject((Project)project2, (Sdk)jdk);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final Project createFromWizard(@NotNull AbstractProjectWizard wizard2) {
        Intrinsics.checkNotNullParameter((Object)((Object)wizard2), (String)"wizard");
        return NewProjectUtil.createFromWizard$default(wizard2, null, 2, null);
    }

    private static final void createFromWizard$lambda$0(IOException $e) {
        Messages.showErrorDialog((String)$e.getMessage(), (String)JavaUiBundle.message("dialog.title.project.initialization.failed", new Object[0]));
    }

    private static final void setCompilerOutputPath$lambda$0$0(CompilerProjectExtension $extension, String $canonicalPath) {
        $extension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)$canonicalPath));
    }

    private static final void setCompilerOutputPath$lambda$0(String $path, CompilerProjectExtension $extension) {
        String string;
        try {
            string = FileUtil.resolveShortWindowsName((String)$path);
        }
        catch (IOException iOException) {
            string = $path;
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        String canonicalPath = string2;
        ApplicationManager.getApplication().runWriteAction(() -> NewProjectUtil.setCompilerOutputPath$lambda$0$0($extension, canonicalPath));
    }
}

