/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.starters.local;

import com.intellij.ide.starters.local.Dependency;
import com.intellij.ide.starters.local.DependencyConfig;
import com.intellij.openapi.util.Version;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u001d\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0010J\u001f\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b\u0014J\u0015\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J>\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001e2\b\b\u0002\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ide/starters/local/StarterUtils;", "", "<init>", "()V", "PLACEHOLDER_VERSION_PATTERN", "Lkotlin/text/Regex;", "parseDependencyConfig", "Lcom/intellij/ide/starters/local/DependencyConfig;", "projectTag", "Lorg/jdom/Element;", "resourcePath", "", "interpolateProperties", "", "parseDependencyConfigVersion", "Lcom/intellij/openapi/util/Version;", "parseDependencyConfigVersion$intellij_java_ui", "mergeDependencyConfigs", "dependencyConfig", "dependencyConfigUpdates", "mergeDependencyConfigs$intellij_java_ui", "isDependencyUpdateFileExpired", "file", "Ljava/io/File;", "isDependencyUpdateFileExpired$intellij_java_ui", "interpolateDependencyVersion", "groupId", "artifactId", "version", "properties", "", "IncorrectBomFileException", "intellij.java.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStarterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StarterUtils.kt\ncom/intellij/ide/starters/local/StarterUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n1300#2,2:119\n1315#2,4:121\n1586#2:125\n1661#2,3:126\n*S KotlinDebug\n*F\n+ 1 StarterUtils.kt\ncom/intellij/ide/starters/local/StarterUtils\n*L\n81#1:119,2\n81#1:121,4\n86#1:125\n86#1:126,3\n*E\n"})
public final class StarterUtils {
    @NotNull
    public static final StarterUtils INSTANCE = new StarterUtils();
    @NotNull
    private static final Regex PLACEHOLDER_VERSION_PATTERN = new Regex("\\$\\{(.+)}");

    private StarterUtils() {
    }

    @NotNull
    public final DependencyConfig parseDependencyConfig(@NotNull Element projectTag, @NotNull String resourcePath, boolean interpolateProperties) {
        Element dependenciesTag;
        Intrinsics.checkNotNullParameter((Object)projectTag, (String)"projectTag");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        Map properties = new LinkedHashMap();
        List dependencies = new ArrayList();
        if (!Intrinsics.areEqual((Object)projectTag.getName(), (Object)"project")) {
            throw new IncorrectBomFileException("Incorrect root tag name " + projectTag.getName());
        }
        Element element = projectTag.getChild("version");
        String bomVersionText = element != null ? element.getText() : null;
        CharSequence charSequence = bomVersionText;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IncorrectBomFileException("Empty BOM version for " + resourcePath);
        }
        Element propertiesTag = projectTag.getChild("properties");
        if (propertiesTag != null) {
            for (Element propertyTag : propertiesTag.getChildren()) {
                CharSequence charSequence2;
                String propertyName = propertyTag.getName();
                String propertyValue = propertyTag.getText();
                if (propertyName == null || (charSequence2 = (CharSequence)propertyValue) == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                    throw new IncorrectBomFileException("Incorrect property '" + propertyName + "'");
                }
                properties.put(propertyName, propertyValue);
            }
        }
        Element element2 = projectTag.getChild("dependencyManagement");
        Object object = dependenciesTag = element2 != null ? element2.getChild("dependencies") : null;
        if (dependenciesTag != null) {
            for (Element dependencyTag : dependenciesTag.getChildren("dependency")) {
                Element element3 = dependencyTag.getChild("groupId");
                String groupId = element3 != null ? element3.getText() : null;
                Element element4 = dependencyTag.getChild("artifactId");
                String artifactId = element4 != null ? element4.getText() : null;
                Element element5 = dependencyTag.getChild("version");
                String version = element5 != null ? element5.getText() : null;
                CharSequence charSequence3 = groupId;
                if (charSequence3 == null || charSequence3.length() == 0 || (charSequence3 = (CharSequence)artifactId) == null || charSequence3.length() == 0 || (charSequence3 = (CharSequence)version) == null || charSequence3.length() == 0) {
                    throw new IncorrectBomFileException("Incorrect dependency '" + groupId + ":" + artifactId + "'");
                }
                version = this.interpolateDependencyVersion(groupId, artifactId, version, properties, interpolateProperties);
                dependencies.add(new Dependency(groupId, artifactId, version));
            }
        }
        return new DependencyConfig(bomVersionText, properties, dependencies);
    }

    public static /* synthetic */ DependencyConfig parseDependencyConfig$default(StarterUtils starterUtils, Element element, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return starterUtils.parseDependencyConfig(element, string, bl);
    }

    @NotNull
    public final Version parseDependencyConfigVersion$intellij_java_ui(@NotNull Element projectTag, @NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)projectTag, (String)"projectTag");
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        if (!Intrinsics.areEqual((Object)projectTag.getName(), (Object)"project")) {
            throw new IncorrectBomFileException("Incorrect root tag name " + projectTag.getName());
        }
        Element element = projectTag.getChild("version");
        String bomVersionText = element != null ? element.getText() : null;
        CharSequence charSequence = bomVersionText;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IncorrectBomFileException("Empty BOM version for " + resourcePath);
        }
        Version version = Version.parseVersion((String)bomVersionText);
        if (version == null) {
            throw new IllegalStateException("Failed to parse starter dependency config version".toString());
        }
        return version;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DependencyConfig mergeDependencyConfigs$intellij_java_ui(@NotNull DependencyConfig dependencyConfig, @Nullable DependencyConfig dependencyConfigUpdates) {
        void $this$mapTo$iv$iv;
        Dependency propertyKey;
        Object object;
        Iterable $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)dependencyConfig, (String)"dependencyConfig");
        if (dependencyConfigUpdates == null || Float.parseFloat(dependencyConfig.getVersion()) > Float.parseFloat(dependencyConfigUpdates.getVersion())) {
            return dependencyConfig;
        }
        String newVersion = dependencyConfigUpdates.getVersion();
        Iterable $this$associateWith$iv = CollectionsKt.union((Iterable)dependencyConfig.getProperties().keySet(), (Iterable)dependencyConfigUpdates.getProperties().keySet());
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Object destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            String string2 = dependencyConfigUpdates.getProperties().get(propertyKey);
            if (string2 == null && (string2 = dependencyConfig.getProperties().get(propertyKey)) == null) {
                throw new IllegalStateException(("Failed to find property value for key: " + (String)((Object)propertyKey)).toString());
            }
            String string3 = string2;
            object.put(t, string3);
        }
        Map properties = destination$iv$iv;
        Iterable $this$map$iv = dependencyConfig.getDependencies();
        boolean $i$f$map = false;
        $this$associateWithTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            Object v1;
            void dependency;
            block5: {
                propertyKey = (Dependency)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = dependencyConfigUpdates.getDependencies();
                for (Object t : iterable2) {
                    Dependency updatedDependency = (Dependency)t;
                    boolean bl2 = false;
                    if (!(Intrinsics.areEqual((Object)dependency.getGroup(), (Object)updatedDependency.getGroup()) && Intrinsics.areEqual((Object)dependency.getArtifact(), (Object)updatedDependency.getArtifact()))) continue;
                    v1 = t;
                    break block5;
                }
                v1 = null;
            }
            Dependency dependency2 = v1;
            String it = dependency2 != null && (string = dependency2.getVersion()) != null ? string : dependency.getVersion();
            boolean bl = false;
            String newDependencyVersion = INSTANCE.interpolateDependencyVersion(dependency.getGroup(), dependency.getArtifact(), it, properties, true);
            object.add(new Dependency(dependency.getGroup(), dependency.getArtifact(), newDependencyVersion));
        }
        List dependencies = (List)destination$iv$iv;
        return new DependencyConfig(newVersion, properties, dependencies);
    }

    public final boolean isDependencyUpdateFileExpired$intellij_java_ui(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        long lastModifiedMs = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
        LocalDateTime lastModified = Instant.ofEpochMilli(lastModifiedMs).atZone(ZoneId.systemDefault()).toLocalDateTime();
        return lastModified.isBefore(LocalDate.now().atStartOfDay());
    }

    private final String interpolateDependencyVersion(String groupId, String artifactId, String version, Map<String, String> properties, boolean interpolateProperties) {
        MatchResult versionMatch = PLACEHOLDER_VERSION_PATTERN.matchEntire((CharSequence)version);
        if (versionMatch != null) {
            String propertyName = (String)versionMatch.getGroupValues().get(1);
            String propertyValue = properties.get(propertyName);
            CharSequence charSequence = propertyValue;
            if (charSequence == null || charSequence.length() == 0) {
                throw new IncorrectBomFileException("No such property '" + propertyName + "' for version of '" + groupId + ":" + artifactId + "'");
            }
            return interpolateProperties ? propertyValue : version;
        }
        return version;
    }

    static /* synthetic */ String interpolateDependencyVersion$default(StarterUtils starterUtils, String string, String string2, String string3, Map map, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return starterUtils.interpolateDependencyVersion(string, string2, string3, map, bl);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ide/starters/local/StarterUtils$IncorrectBomFileException;", "Ljava/io/IOException;", "message", "", "<init>", "(Ljava/lang/String;)V", "intellij.java.ui"})
    private static final class IncorrectBomFileException
    extends IOException {
        public IncorrectBomFileException(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            super(message);
        }
    }
}

