/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.Dependency;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public non-sealed class ModuleDescriptor
implements Dependency {
    private String myName;
    private final MultiMap<File, DetectedSourceRoot> myContentToSourceRoots = new MultiMap();
    private final Set<File> myLibraryFiles = new HashSet<File>();
    private final Set<ModuleDescriptor> myDependencies = new HashSet<ModuleDescriptor>();
    private static final Set<String> ourModuleNameStopList = CollectionFactory.createCaseInsensitiveStringSet(Arrays.asList("java", "src", "source", "sources", "C:", "D:", "E:", "F:", "temp", "tmp"));
    private boolean myReuseExistingElement;
    private final List<ModuleBuilder.ModuleConfigurationUpdater> myConfigurationUpdaters = new SmartList();
    private final ModuleType<?> myModuleType;

    public ModuleDescriptor(File contentRoot, ModuleType moduleType, Collection<? extends DetectedSourceRoot> sourceRoots) {
        this.myName = ModuleDescriptor.suggestModuleName(contentRoot);
        this.myContentToSourceRoots.putValues((Object)contentRoot, sourceRoots);
        this.myModuleType = moduleType;
    }

    public ModuleDescriptor(File contentRoot, ModuleType moduleType, DetectedSourceRoot sourceRoot) {
        this(contentRoot, moduleType, Collections.singletonList(sourceRoot));
    }

    public void reuseExisting(boolean reuseExistingElement) {
        this.myReuseExistingElement = reuseExistingElement;
    }

    public void addConfigurationUpdater(ModuleBuilder.ModuleConfigurationUpdater updater) {
        this.myConfigurationUpdaters.add(updater);
    }

    public void updateModuleConfiguration(Module module, ModifiableRootModel rootModel) {
        for (ModuleBuilder.ModuleConfigurationUpdater updater : this.myConfigurationUpdaters) {
            updater.update(module, rootModel);
        }
    }

    public boolean isReuseExistingElement() {
        return this.myReuseExistingElement;
    }

    public ModuleType<?> getModuleType() {
        return this.myModuleType;
    }

    @Override
    public int getWeight() {
        return 20;
    }

    private static String suggestModuleName(File contentRoot) {
        for (File dir = contentRoot; dir != null; dir = dir.getParentFile()) {
            String suggestion = dir.getName();
            if (ourModuleNameStopList.contains(suggestion)) continue;
            return suggestion;
        }
        return contentRoot.getName();
    }

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
    }

    public Set<File> getContentRoots() {
        return Collections.unmodifiableSet(this.myContentToSourceRoots.keySet());
    }

    public Collection<? extends DetectedProjectRoot> getSourceRoots() {
        return this.myContentToSourceRoots.values();
    }

    public Collection<DetectedSourceRoot> getSourceRoots(File contentRoot) {
        return this.myContentToSourceRoots.get((Object)contentRoot);
    }

    public void addContentRoot(File contentRoot) {
        this.myContentToSourceRoots.put((Object)contentRoot, new HashSet());
    }

    public Collection<DetectedSourceRoot> removeContentRoot(File contentRoot) {
        return this.myContentToSourceRoots.remove((Object)contentRoot);
    }

    public void addSourceRoot(File contentRoot, DetectedSourceRoot sourceRoot) {
        this.myContentToSourceRoots.putValue((Object)contentRoot, (Object)sourceRoot);
    }

    public void addDependencyOn(ModuleDescriptor dependence) {
        this.myDependencies.add(dependence);
    }

    public void removeDependencyOn(ModuleDescriptor module) {
        this.myDependencies.remove(module);
    }

    public void addLibraryFile(File libFile) {
        this.myLibraryFiles.add(libFile);
    }

    public Set<File> getLibraryFiles() {
        return this.myLibraryFiles;
    }

    public Set<ModuleDescriptor> getDependencies() {
        return Collections.unmodifiableSet(this.myDependencies);
    }

    public String toString() {
        @NonNls StringBuilder builder = new StringBuilder();
        builder.append("[Module: ").append(this.getContentRoots()).append(" | ");
        for (DetectedProjectRoot detectedProjectRoot : this.getSourceRoots()) {
            builder.append(detectedProjectRoot.getDirectory().getName()).append(",");
        }
        builder.append("]");
        return builder.toString();
    }

    public void clearModuleDependencies() {
        this.myDependencies.clear();
    }

    public void clearLibraryFiles() {
        this.myLibraryFiles.clear();
    }

    @NotNull
    public String computeModuleFilePath() throws InvalidDataException {
        String name = this.getName();
        Set<File> contentRoots = this.getContentRoots();
        if (!contentRoots.isEmpty()) {
            String string = contentRoots.iterator().next().getPath() + File.separator + name + ".iml";
            if (string == null) {
                ModuleDescriptor.$$$reportNull$$$0(0);
            }
            return string;
        }
        throw new InvalidDataException("Module " + name + " has no content roots and will not be created.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleDescriptor", "computeModuleFilePath"));
    }
}

