/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.JavaUiBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Interner;
import com.intellij.util.text.UniqueNameGenerator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ModuleInsight {
    private static final Logger LOG = Logger.getInstance(ModuleInsight.class);
    @NotNull
    protected final ProgressIndicatorWrapper myProgress;
    private final Set<File> myEntryPointRoots = new HashSet<File>();
    private final List<DetectedSourceRoot> mySourceRoots = new ArrayList<DetectedSourceRoot>();
    private final Set<String> myIgnoredNames = new HashSet<String>();
    private final Map<File, Set<String>> mySourceRootToReferencedPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> mySourceRootToPackagesMap = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> myJarToPackagesMap = new HashMap<File, Set<String>>();
    private final Interner<String> myInterner = Interner.createStringInterner();
    private List<ModuleDescriptor> myModules;
    private List<LibraryDescriptor> myLibraries;
    private final Set<String> myExistingModuleNames;
    private final Set<String> myExistingProjectLibraryNames;

    public ModuleInsight(@Nullable ProgressIndicator progress, Set<String> existingModuleNames, Set<String> existingProjectLibraryNames) {
        this.myExistingModuleNames = existingModuleNames;
        this.myExistingProjectLibraryNames = existingProjectLibraryNames;
        this.myProgress = new ProgressIndicatorWrapper(progress);
        this.setRoots(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public final void setRoots(List<? extends File> contentRoots, List<? extends DetectedSourceRoot> sourceRoots, Set<String> ignoredNames) {
        this.myModules = null;
        this.myLibraries = null;
        this.myEntryPointRoots.clear();
        this.myEntryPointRoots.addAll(contentRoots);
        this.mySourceRoots.clear();
        this.mySourceRoots.addAll(sourceRoots);
        this.myIgnoredNames.clear();
        this.myIgnoredNames.addAll(ignoredNames);
        this.myJarToPackagesMap.clear();
        this.myInterner.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.myLibraries;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.myModules;
    }

    public void scanModules() {
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> contentRootToModules = new HashMap<File, ModuleDescriptor>();
        try {
            this.myProgress.pushState();
            ArrayList<DetectedSourceRoot> processedRoots = new ArrayList<DetectedSourceRoot>();
            for (DetectedSourceRoot root : this.getSourceRootsToScan()) {
                File file = root.getDirectory();
                if (this.isIgnoredName(file)) continue;
                this.myProgress.setText(JavaUiBundle.message("module.insight.scan.progress.text.scanning", file.getPath()));
                HashSet usedPackages = new HashSet();
                this.mySourceRootToReferencedPackagesMap.put(file, usedPackages);
                HashSet<String> selfPackages = new HashSet<String>();
                this.addExportedPackages(file, selfPackages);
                this.scanSources(file, ProjectFromSourcesBuilderImpl.getPackagePrefix(root), usedPackages, selfPackages);
                usedPackages.removeAll(selfPackages);
                processedRoots.add(root);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText(JavaUiBundle.message("module.insight.scan.progress.text.building.modules.layout", new Object[0]));
            HashMap<File, ModuleCandidate> rootToModule = new HashMap<File, ModuleCandidate>();
            for (DetectedSourceRoot detectedSourceRoot : processedRoots) {
                File srcRoot = detectedSourceRoot.getDirectory();
                File moduleContentRoot = this.isEntryPointRoot(srcRoot) ? srcRoot : srcRoot.getParentFile();
                rootToModule.computeIfAbsent(moduleContentRoot, (Function<File, ModuleCandidate>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$scanModules$0(java.io.File java.io.File ), (Ljava/io/File;)Lcom/intellij/ide/util/importProject/ModuleInsight$ModuleCandidate;)((File)moduleContentRoot)).myRoots.add(detectedSourceRoot);
            }
            this.maximizeModuleFolders(rootToModule.values());
            for (Map.Entry entry : rootToModule.entrySet()) {
                File root = (File)entry.getKey();
                ModuleCandidate module = (ModuleCandidate)entry.getValue();
                ModuleDescriptor moduleDescriptor = this.createModuleDescriptor(module.myFolder, module.myRoots);
                contentRootToModules.put(root, moduleDescriptor);
            }
            this.buildModuleDependencies(contentRootToModules);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.addModules(contentRootToModules.values());
    }

    private void maximizeModuleFolders(@NotNull Collection<ModuleCandidate> modules) {
        if (modules == null) {
            ModuleInsight.$$$reportNull$$$0(0);
        }
        Object2IntOpenHashMap dirToChildRootCount = new Object2IntOpenHashMap();
        for (ModuleCandidate module : modules) {
            ModuleInsight.walkParents(module.myFolder, this::isEntryPointRoot, (Consumer<? super File>)((Consumer)arg_0 -> ModuleInsight.lambda$maximizeModuleFolders$1((Object2IntMap)dirToChildRootCount, arg_0)));
        }
        for (ModuleCandidate module : modules) {
            File moduleRoot = module.myFolder;
            Ref adjustedRootRef = new Ref((Object)module.myFolder);
            File current = moduleRoot;
            while (dirToChildRootCount.getInt((Object)current) == 1) {
                adjustedRootRef.set((Object)current);
                if (this.isEntryPointRoot(current)) break;
                current = current.getParentFile();
            }
            module.myFolder = (File)adjustedRootRef.get();
        }
    }

    private static void walkParents(@NotNull File file, Predicate<? super File> stopCondition, @NotNull Consumer<? super File> fileConsumer) {
        if (file == null) {
            ModuleInsight.$$$reportNull$$$0(1);
        }
        if (fileConsumer == null) {
            ModuleInsight.$$$reportNull$$$0(2);
        }
        File current = file;
        while (true) {
            fileConsumer.consume((Object)current);
            if (stopCondition.test(current)) break;
            current = current.getParentFile();
        }
    }

    protected void addExportedPackages(File sourceRoot, Set<String> packages) {
        this.mySourceRootToPackagesMap.put(sourceRoot, packages);
    }

    protected boolean isIgnoredName(File sourceRoot) {
        return this.myIgnoredNames.contains(sourceRoot.getName());
    }

    protected void addModules(Collection<ModuleDescriptor> newModules) {
        if (this.myModules == null) {
            this.myModules = new ArrayList<ModuleDescriptor>(newModules);
        } else {
            this.myModules.addAll(newModules);
        }
        HashSet<String> moduleNames = new HashSet<String>(this.myExistingModuleNames);
        for (ModuleDescriptor module : newModules) {
            String suggested = UniqueNameGenerator.generateUniqueName((String)module.getName(), moduleNames);
            module.setName(suggested);
            moduleNames.add(suggested);
        }
    }

    Set<String> getExistingModuleNames() {
        return Collections.unmodifiableSet(this.myExistingModuleNames);
    }

    Set<String> getExistingProjectLibraryNames() {
        return Collections.unmodifiableSet(this.myExistingProjectLibraryNames);
    }

    @NotNull
    protected @Unmodifiable List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> list2 = Collections.unmodifiableList(this.mySourceRoots);
        if (list2 == null) {
            ModuleInsight.$$$reportNull$$$0(3);
        }
        return list2;
    }

    protected boolean isEntryPointRoot(File srcRoot) {
        return this.myEntryPointRoots.contains(srcRoot);
    }

    protected abstract ModuleDescriptor createModuleDescriptor(File var1, Collection<DetectedSourceRoot> var2);

    private void buildModuleDependencies(Map<File, ModuleDescriptor> contentRootToModules) {
        Set<File> moduleContentRoots = contentRootToModules.keySet();
        for (File contentRoot : moduleContentRoots) {
            ModuleDescriptor checkedModule = contentRootToModules.get(contentRoot);
            this.myProgress.setText2(JavaUiBundle.message("progress.details.building.library.dependencies.for.module", checkedModule.getName()));
            this.buildJarDependencies(checkedModule);
            this.myProgress.setText2(JavaUiBundle.message("progress.details.building.module.dependencies.for.module", checkedModule.getName()));
            block1: for (File aContentRoot : moduleContentRoots) {
                ModuleDescriptor aModule = contentRootToModules.get(aContentRoot);
                if (checkedModule.equals(aModule)) continue;
                Collection<? extends DetectedProjectRoot> aModuleRoots = aModule.getSourceRoots();
                for (DetectedProjectRoot detectedProjectRoot : checkedModule.getSourceRoots()) {
                    Set<String> referencedBySourceRoot = this.mySourceRootToReferencedPackagesMap.get(detectedProjectRoot.getDirectory());
                    for (DetectedProjectRoot detectedProjectRoot2 : aModuleRoots) {
                        if (!ContainerUtil.intersects(referencedBySourceRoot, (Collection)this.mySourceRootToPackagesMap.get(detectedProjectRoot2.getDirectory()))) continue;
                        checkedModule.addDependencyOn(aModule);
                        continue block1;
                    }
                }
            }
        }
    }

    private void buildJarDependencies(ModuleDescriptor module) {
        block0: for (File jarFile : this.myJarToPackagesMap.keySet()) {
            Set<String> jarPackages = this.myJarToPackagesMap.get(jarFile);
            for (DetectedProjectRoot detectedProjectRoot : module.getSourceRoots()) {
                if (!ContainerUtil.intersects((Collection)this.mySourceRootToReferencedPackagesMap.get(detectedProjectRoot.getDirectory()), jarPackages)) continue;
                module.addLibraryFile(jarFile);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File root : this.myEntryPointRoots) {
                    this.myProgress.setText(JavaUiBundle.message("progress.text.scanning.for.libraries", root.getPath()));
                    this.scanRootForLibraries(root);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            this.myProgress.setText(JavaUiBundle.message("progress.text.building.initial.libraries.layout", new Object[0]));
            List<LibraryDescriptor> libraries = ModuleInsight.buildInitialLibrariesLayout(this.myJarToPackagesMap.keySet());
            HashSet<String> libNames = new HashSet<String>(this.myExistingProjectLibraryNames);
            for (LibraryDescriptor library : libraries) {
                Collection<File> libJars = library.getJars();
                String baseName = libJars.size() == 1 ? FileUtilRt.getNameWithoutExtension((String)libJars.iterator().next().getName()) : library.getName();
                String newName = UniqueNameGenerator.generateUniqueName((String)baseName, libNames);
                library.setName(newName);
                libNames.add(newName);
            }
            this.myLibraries = libraries;
        }
        finally {
            this.myProgress.popState();
        }
    }

    public abstract boolean isApplicableRoot(DetectedProjectRoot var1);

    public void merge(ModuleDescriptor mainModule, ModuleDescriptor module) {
        for (File contentRoot : module.getContentRoots()) {
            File _contentRoot = ModuleInsight.appendContentRoot(mainModule, contentRoot);
            Collection<DetectedSourceRoot> sources = module.getSourceRoots(contentRoot);
            for (DetectedSourceRoot source : sources) {
                mainModule.addSourceRoot(_contentRoot, source);
            }
        }
        for (File jar : module.getLibraryFiles()) {
            mainModule.addLibraryFile(jar);
        }
        for (ModuleDescriptor dependency : module.getDependencies()) {
            if (mainModule.equals(dependency)) continue;
            mainModule.addDependencyOn(dependency);
        }
        this.myModules.remove(module);
        for (ModuleDescriptor moduleDescr : this.myModules) {
            if (!moduleDescr.getDependencies().contains(module)) continue;
            moduleDescr.removeDependencyOn(module);
            if (moduleDescr.equals(mainModule)) continue;
            moduleDescr.addDependencyOn(mainModule);
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor library, String newLibraryName, Collection<? extends File> jarsToExtract) {
        LibraryDescriptor newLibrary = new LibraryDescriptor(newLibraryName, new ArrayList<File>(jarsToExtract));
        this.myLibraries.add(newLibrary);
        library.removeJars(jarsToExtract);
        if (library.getJars().isEmpty()) {
            this.removeLibrary(library);
        }
        return newLibrary;
    }

    @Nullable
    public ModuleDescriptor splitModule(ModuleDescriptor descriptor, String newModuleName, Collection<? extends File> contentsToExtract) {
        ModuleDescriptor newModule = null;
        for (File file : contentsToExtract) {
            HashSet sources = descriptor.removeContentRoot(file);
            if (newModule == null) {
                newModule = this.createModuleDescriptor(file, sources != null ? sources : new HashSet());
                continue;
            }
            if (sources != null && !sources.isEmpty()) {
                for (DetectedSourceRoot source : sources) {
                    newModule.addSourceRoot(file, source);
                }
                continue;
            }
            newModule.addContentRoot(file);
        }
        if (newModule == null) {
            return null;
        }
        newModule.setName(newModuleName);
        this.myModules.add(newModule);
        HashMap<File, ModuleDescriptor> contentRootToModule = new HashMap<File, ModuleDescriptor>();
        for (ModuleDescriptor module : this.myModules) {
            Set<File> roots = module.getContentRoots();
            for (File root : roots) {
                contentRootToModule.put(root, module);
            }
            module.clearModuleDependencies();
            module.clearLibraryFiles();
        }
        this.buildModuleDependencies(contentRootToModule);
        return newModule;
    }

    public void removeLibrary(LibraryDescriptor lib) {
        this.myLibraries.remove(lib);
    }

    public void moveJarsToLibrary(LibraryDescriptor from, Collection<? extends File> files, LibraryDescriptor to) {
        to.addJars(files);
        from.removeJars(files);
        if (from.getJars().isEmpty()) {
            this.removeLibrary(from);
        }
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module) {
        return ModuleInsight.getLibraryDependencies(module, this.myLibraries);
    }

    public static Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor module, @Nullable List<? extends LibraryDescriptor> allLibraries) {
        HashSet<LibraryDescriptor> libs = new HashSet<LibraryDescriptor>();
        if (allLibraries != null) {
            for (LibraryDescriptor libraryDescriptor : allLibraries) {
                if (!ContainerUtil.intersects(libraryDescriptor.getJars(), module.getLibraryFiles())) continue;
                libs.add(libraryDescriptor);
            }
        }
        return libs;
    }

    private static File appendContentRoot(ModuleDescriptor module, File contentRoot) {
        Set<File> moduleRoots = module.getContentRoots();
        for (File moduleRoot : moduleRoots) {
            if (FileUtil.isAncestor((File)moduleRoot, (File)contentRoot, (boolean)false)) {
                return moduleRoot;
            }
            if (!FileUtil.isAncestor((File)contentRoot, (File)moduleRoot, (boolean)true)) continue;
            Collection<DetectedSourceRoot> currentSources = module.getSourceRoots(moduleRoot);
            module.removeContentRoot(moduleRoot);
            module.addContentRoot(contentRoot);
            for (DetectedSourceRoot source : currentSources) {
                module.addSourceRoot(contentRoot, source);
            }
            return contentRoot;
        }
        module.addContentRoot(contentRoot);
        return contentRoot;
    }

    private static List<LibraryDescriptor> buildInitialLibrariesLayout(Set<? extends File> jars) {
        HashMap<File, LibraryDescriptor> rootToLibraryMap = new HashMap<File, LibraryDescriptor>();
        for (File file : jars) {
            File parent = file.getParentFile();
            LibraryDescriptor lib = rootToLibraryMap.computeIfAbsent(parent, p -> new LibraryDescriptor(p.getName(), new HashSet<File>()));
            lib.addJars(Collections.singleton(file));
        }
        return new ArrayList<LibraryDescriptor>(rootToLibraryMap.values());
    }

    private void scanSources(File fromRoot, String parentPackageName, Set<? super String> usedPackages, Set<? super String> selfPackages) {
        if (this.isIgnoredName(fromRoot)) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            boolean includeParentName = false;
            for (File file : files) {
                if (file.isDirectory()) {
                    String subPackageName = parentPackageName + (parentPackageName.isEmpty() ? "" : ".") + file.getName();
                    this.scanSources(file, subPackageName, usedPackages, selfPackages);
                    continue;
                }
                if (!this.isSourceFile(file)) continue;
                includeParentName = true;
                this.scanSourceFile(file, usedPackages);
            }
            if (includeParentName) {
                selfPackages.add((String)this.myInterner.intern((Object)parentPackageName));
            }
        }
    }

    protected abstract boolean isSourceFile(File var1);

    private void scanSourceFile(File file, Set<? super String> usedPackages) {
        @NlsSafe String name = file.getName();
        this.myProgress.setText2(name);
        try {
            String chars = FileUtil.loadFile((File)file, (String)null);
            this.scanSourceFileForImportedPackages(chars, (Consumer<? super String>)((Consumer)s -> usedPackages.add((String)this.myInterner.intern(s))));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    protected abstract void scanSourceFileForImportedPackages(CharSequence var1, Consumer<? super String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanRootForLibraries(File fromRoot) {
        if (this.isIgnoredName(fromRoot)) {
            return;
        }
        File[] files = fromRoot.listFiles();
        if (files != null) {
            this.myProgress.checkCanceled();
            for (File file : files) {
                if (file.isDirectory()) {
                    this.scanRootForLibraries(file);
                    continue;
                }
                @NlsSafe String fileName = file.getName();
                if (!this.isLibraryFile(fileName) || this.myJarToPackagesMap.containsKey(file)) continue;
                HashSet libraryPackages = new HashSet();
                this.myJarToPackagesMap.put(file, libraryPackages);
                this.myProgress.pushState();
                this.myProgress.setText2(fileName);
                try {
                    this.scanLibraryForDeclaredPackages(file, (Consumer<? super String>)((Consumer)s -> {
                        if (!libraryPackages.contains(s)) {
                            libraryPackages.add((String)this.myInterner.intern(s));
                        }
                    }));
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    LOG.info((Throwable)e);
                }
                catch (InternalError e) {
                    LOG.info((Throwable)e);
                }
                finally {
                    this.myProgress.popState();
                }
            }
        }
    }

    protected abstract boolean isLibraryFile(String var1);

    protected abstract void scanLibraryForDeclaredPackages(File var1, Consumer<? super String> var2) throws IOException;

    private static /* synthetic */ void lambda$maximizeModuleFolders$1(Object2IntMap dirToChildRootCount, File file) {
        dirToChildRootCount.mergeInt((Object)file, 1, Math::addExact);
    }

    private static /* synthetic */ ModuleCandidate lambda$scanModules$0(File moduleContentRoot, File file) {
        return new ModuleCandidate(moduleContentRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/util/importProject/ModuleInsight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/util/importProject/ModuleInsight";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceRootsToScan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "maximizeModuleFolders";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "walkParents";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private static final class ModuleCandidate {
        final List<DetectedSourceRoot> myRoots;
        @NotNull
        File myFolder;

        private ModuleCandidate(@NotNull File folder) {
            if (folder == null) {
                ModuleCandidate.$$$reportNull$$$0(0);
            }
            this.myRoots = new ArrayList<DetectedSourceRoot>();
            this.myFolder = folder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/ide/util/importProject/ModuleInsight$ModuleCandidate", "<init>"));
        }
    }
}

