/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.projectWizard.AbstractModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class StepSequence {
    private final List<ModuleWizardStep> myCommonSteps;
    private final List<Pair<ModuleWizardStep, Predicate<? super Set<String>>>> myCommonFinishingSteps = new ArrayList<Pair<ModuleWizardStep, Predicate<? super Set<String>>>>();
    private final MultiMap<String, ModuleWizardStep> mySpecificSteps = new MultiMap();
    private final MultiMap<String, ModuleWizardStep> mySpecificFinishingSteps = new MultiMap();
    @NonNls
    private final List<String> myTypes = new ArrayList<String>();
    private List<Class<? extends ModuleWizardStep>> myIgnoredSteps = Collections.emptyList();
    private List<ModuleWizardStep> mySelectedSteps;

    public StepSequence(ModuleWizardStep ... commonSteps) {
        this.myCommonSteps = new SmartList((Object[])commonSteps);
    }

    public void addCommonStep(@NotNull ModuleWizardStep step) {
        if (step == null) {
            StepSequence.$$$reportNull$$$0(0);
        }
        this.myCommonSteps.add(step);
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Set<String> suitableTypes) {
        if (step == null) {
            StepSequence.$$$reportNull$$$0(1);
        }
        this.addCommonFinishingStep(step, (? super Set<String> types) -> suitableTypes == null || ContainerUtil.intersects((Collection)types, (Collection)suitableTypes));
    }

    public void addCommonFinishingStep(@NotNull ModuleWizardStep step, @Nullable Predicate<? super Set<String>> suitableTypesPredicate) {
        if (step == null) {
            StepSequence.$$$reportNull$$$0(2);
        }
        this.myCommonFinishingSteps.add((Pair<ModuleWizardStep, Predicate<? super Set<String>>>)Pair.create((Object)step, suitableTypesPredicate));
    }

    @Deprecated
    public void addStepsForBuilder(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (builder == null) {
            StepSequence.$$$reportNull$$$0(3);
        }
        if (wizardContext == null) {
            StepSequence.$$$reportNull$$$0(4);
        }
        if (modulesProvider == null) {
            StepSequence.$$$reportNull$$$0(5);
        }
        this.addSteps(builder, wizardContext, modulesProvider);
    }

    public Collection<ModuleWizardStep> addSteps(@NotNull AbstractModuleBuilder builder, @NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        ModuleWizardStep[] steps;
        if (builder == null) {
            StepSequence.$$$reportNull$$$0(6);
        }
        if (wizardContext == null) {
            StepSequence.$$$reportNull$$$0(7);
        }
        if (modulesProvider == null) {
            StepSequence.$$$reportNull$$$0(8);
        }
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        String id = builder.getBuilderId();
        if (!this.mySpecificSteps.containsKey((Object)id)) {
            steps = builder.createWizardSteps(wizardContext, modulesProvider);
            result.addAll(Arrays.asList(steps));
            this.mySpecificSteps.put((Object)id, Arrays.asList(steps));
        }
        if (!this.mySpecificFinishingSteps.containsKey((Object)id)) {
            steps = builder.createFinishingSteps(wizardContext, modulesProvider);
            result.addAll(Arrays.asList(steps));
            this.mySpecificFinishingSteps.put((Object)id, Arrays.asList(steps));
        }
        return result;
    }

    public void addSpecificStep(String type, ModuleWizardStep step) {
        this.mySpecificSteps.putValue((Object)type, (Object)step);
    }

    public @Unmodifiable List<ModuleWizardStep> getSelectedSteps() {
        if (this.mySelectedSteps == null) {
            Collection steps;
            this.mySelectedSteps = new ArrayList<ModuleWizardStep>();
            this.mySelectedSteps.addAll(this.myCommonSteps);
            for (String string : this.myTypes) {
                steps = this.mySpecificSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            for (Pair pair : this.myCommonFinishingSteps) {
                Predicate types = (Predicate)pair.getSecond();
                if (types != null && !types.test(new HashSet<String>(this.myTypes))) continue;
                this.mySelectedSteps.add((ModuleWizardStep)pair.getFirst());
            }
            for (String string : this.myTypes) {
                steps = this.mySpecificFinishingSteps.get((Object)string);
                this.mySelectedSteps.addAll(steps);
            }
            ContainerUtil.removeDuplicates(this.mySelectedSteps);
        }
        return ContainerUtil.filter(this.mySelectedSteps, it -> !this.isIgnoredStep((ModuleWizardStep)it));
    }

    private boolean isIgnoredStep(ModuleWizardStep step) {
        return this.myIgnoredSteps.stream().anyMatch(it -> it.isInstance(step));
    }

    @Nullable
    public ModuleWizardStep getNextStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i < steps.size() - 1 ? steps.get(i + 1) : null;
    }

    @Nullable
    public ModuleWizardStep getPreviousStep(ModuleWizardStep step) {
        List<ModuleWizardStep> steps = this.getSelectedSteps();
        int i = steps.indexOf(step);
        return i > 0 ? steps.get(i - 1) : null;
    }

    public void setTypes(Collection<String> types) {
        this.myTypes.clear();
        this.myTypes.addAll(types);
        this.mySelectedSteps = null;
    }

    public void setIgnoredSteps(@NotNull List<Class<? extends ModuleWizardStep>> steps) {
        if (steps == null) {
            StepSequence.$$$reportNull$$$0(9);
        }
        this.myIgnoredSteps = steps;
    }

    public void setType(@Nullable @NonNls String type) {
        this.setTypes(Collections.singletonList(type == null ? ModuleType.EMPTY.getId() : type));
    }

    public String getSelectedType() {
        return (String)ContainerUtil.getFirstItem(this.myTypes);
    }

    public List<ModuleWizardStep> getAllSteps() {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        result.addAll(this.myCommonSteps);
        result.addAll(this.mySpecificSteps.values());
        for (Pair<ModuleWizardStep, Predicate<? super Set<String>>> pair : this.myCommonFinishingSteps) {
            result.add((ModuleWizardStep)pair.getFirst());
        }
        result.addAll(this.mySpecificFinishingSteps.values());
        ContainerUtil.removeDuplicates(result);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "step";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "steps";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/newProjectWizard/StepSequence";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommonStep";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addCommonFinishingStep";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addStepsForBuilder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addSteps";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "setIgnoredSteps";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

