/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jarRepository;

import com.intellij.CommonBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryAuthenticationDataProviderKt;
import com.intellij.jarRepository.RemoteRepositoriesConfiguration;
import com.intellij.jarRepository.RemoteRepositoryDescription;
import com.intellij.jarRepository.RepositoryArtifactDescription;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.jarRepository.services.MavenRepositoryServicesManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.ProgressWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.eel.EelMachine;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.RepositoryOfflineException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.version.Version;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.idea.maven.aether.ArtifactDependencyNode;
import org.jetbrains.idea.maven.aether.ArtifactKind;
import org.jetbrains.idea.maven.aether.ArtifactRepositoryManager;
import org.jetbrains.idea.maven.aether.ProgressConsumer;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryDescription;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarRepositoryManager {
    private static final com.intellij.openapi.diagnostic.Logger LOG = com.intellij.openapi.diagnostic.Logger.getInstance(JarRepositoryManager.class);
    @ApiStatus.Internal
    @ApiStatus.Obsolete
    public static final String MAVEN_REPOSITORY_MACRO = "$MAVEN_REPOSITORY$";
    private static final String DEFAULT_REPOSITORY_PATH = ".m2/repository";
    private static final AtomicInteger ourTasksInProgress = new AtomicInteger();
    private static final Map<String, OrderRootType> ourClassifierToRootType = new HashMap<String, OrderRootType>();
    private static final Logger slf4jLogger = LoggerFactory.getLogger(JarRepositoryManager.class);
    static final ExecutorService DOWNLOADER_EXECUTOR;
    private static final boolean DO_REFRESH;
    @Deprecated
    private static volatile File ourLocalRepositoryPath;

    @NotNull
    public static NotificationGroup getNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Repository");
        if (notificationGroup == null) {
            JarRepositoryManager.$$$reportNull$$$0(0);
        }
        return notificationGroup;
    }

    public static boolean hasRunningTasks() {
        return ourTasksInProgress.get() > 0;
    }

    @Nullable
    public static NewLibraryConfiguration chooseLibraryAndDownload(@NotNull Project project2, @Nullable String initialFilter, JComponent parentComponent) {
        NewLibraryConfiguration config;
        RepositoryAttachDialog dialog;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(1);
        }
        if (!(dialog = new RepositoryAttachDialog(project2, initialFilter, RepositoryAttachDialog.Mode.DOWNLOAD)).showAndGet()) {
            return null;
        }
        boolean attachSources = dialog.getAttachSources();
        boolean attachJavaDoc = dialog.getAttachJavaDoc();
        boolean attachAnnotations = dialog.getAttachExternalAnnotations();
        String copyTo = dialog.getDirectoryPath();
        JpsMavenRepositoryLibraryDescriptor libraryDescriptor = dialog.getSelectedLibraryDescriptor();
        EnumSet artifactKinds = ArtifactKind.kindsOf((boolean)attachSources, (boolean)attachJavaDoc, (String[])new String[]{libraryDescriptor.getPackaging()});
        if (attachAnnotations) {
            artifactKinds.add(ArtifactKind.ANNOTATIONS);
        }
        if ((config = JarRepositoryManager.resolveAndDownload(project2, libraryDescriptor, artifactKinds, copyTo, RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories())) == null) {
            Messages.showErrorDialog((Component)parentComponent, (String)JavaUiBundle.message("error.message.no.files.were.downloaded.for.0", libraryDescriptor.getMavenId()), (String)CommonBundle.getErrorTitle());
        }
        return config;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor descriptor, Set<ArtifactKind> kinds, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            JarRepositoryManager.$$$reportNull$$$0(3);
        }
        ArrayList<OrderRoot> roots = new ArrayList<OrderRoot>();
        if (descriptor.getMavenId() != null) {
            roots.addAll(JarRepositoryManager.loadDependenciesModal(project2, descriptor, kinds, repositories, copyTo));
        }
        if (!roots.isEmpty()) {
            JarRepositoryManager.notifyArtifactsDownloaded(project2, roots);
            return JarRepositoryManager.createNewLibraryConfiguration(new RepositoryLibraryProperties(descriptor), roots);
        }
        return null;
    }

    @Nullable
    public static NewLibraryConfiguration resolveAndDownload(@NotNull Project project2, String coord, boolean attachSources, boolean attachJavaDoc, boolean includeTransitiveDependencies, String copyTo, Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(4);
        }
        JpsMavenRepositoryLibraryDescriptor libraryDescriptor = new JpsMavenRepositoryLibraryDescriptor(coord, includeTransitiveDependencies, Collections.emptyList());
        return JarRepositoryManager.resolveAndDownload(project2, libraryDescriptor, ArtifactKind.kindsOf((boolean)attachSources, (boolean)attachJavaDoc, (String[])new String[]{libraryDescriptor.getPackaging()}), copyTo, repositories);
    }

    @NotNull
    private static NewLibraryConfiguration createNewLibraryConfiguration(RepositoryLibraryProperties props, final Collection<OrderRoot> roots) {
        return new NewLibraryConfiguration(JarRepositoryManager.suggestLibraryName(props), RepositoryLibraryType.getInstance(), (LibraryProperties)props){

            public void addRoots(@NotNull LibraryEditor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                editor.addRoots(roots);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/jarRepository/JarRepositoryManager$1", "addRoots"));
            }
        };
    }

    private static String suggestLibraryName(RepositoryLibraryProperties props) {
        return Stream.of(props.getGroupId(), props.getArtifactId()).flatMap(s -> Stream.of(s.split("[.:-]"))).distinct().filter(s -> !s.equals("com") && !s.equals("org")).collect(Collectors.joining("."));
    }

    @ApiStatus.Experimental
    @NotNull
    public static Path getJPSLocalMavenRepositoryForIdeaProject(@NotNull Project project2) {
        String expanded;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(5);
        }
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded = PathMacroManager.getInstance((ComponentManager)project2).expandPath(MAVEN_REPOSITORY_MACRO)) && !expanded.isEmpty()) {
            slf4jLogger.debug("RepositoryPath: return expanded macros: " + expanded);
            Path path = Path.of(expanded, new String[0]);
            if (path == null) {
                JarRepositoryManager.$$$reportNull$$$0(6);
            }
            return path;
        }
        Path path = JarRepositoryManager.getLocalRepositoryPath().toPath();
        if (path == null) {
            JarRepositoryManager.$$$reportNull$$$0(7);
        }
        return path;
    }

    @Deprecated
    @NotNull
    public static File getLocalRepositoryPath() {
        File repoPath = ourLocalRepositoryPath;
        if (repoPath != null) {
            slf4jLogger.debug("RepositoryPath: return cached application-wide repo: " + String.valueOf(repoPath));
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(8);
            }
            return file;
        }
        String expanded = PathMacroManager.getInstance((ComponentManager)ApplicationManager.getApplication()).expandPath(MAVEN_REPOSITORY_MACRO);
        if (!MAVEN_REPOSITORY_MACRO.equals(expanded) && !expanded.isEmpty()) {
            repoPath = new File(expanded);
            if (repoPath.exists()) {
                try {
                    repoPath = repoPath.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ourLocalRepositoryPath = repoPath;
            slf4jLogger.debug("RepositoryPath: return expanded application-wide repo: " + String.valueOf(repoPath));
            File file = repoPath;
            if (file == null) {
                JarRepositoryManager.$$$reportNull$$$0(9);
            }
            return file;
        }
        ourLocalRepositoryPath = JarRepositoryManager.getDefaultMavenLocalRepositoryPathNoRespectToSettings();
        slf4jLogger.debug("RepositoryPath: return default application-wide repo: " + String.valueOf(repoPath));
        File file = ourLocalRepositoryPath;
        if (file == null) {
            JarRepositoryManager.$$$reportNull$$$0(10);
        }
        return file;
    }

    private static File getDefaultMavenLocalRepositoryPathNoRespectToSettings() {
        String userHome = System.getProperty("user.home", null);
        return userHome != null ? new File(userHome, DEFAULT_REPOSITORY_PATH) : new File(DEFAULT_REPOSITORY_PATH);
    }

    @Deprecated
    @TestOnly
    @ApiStatus.Internal
    public static void setLocalRepositoryPath(File localRepo) {
        ourLocalRepositoryPath = localRepo;
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        JpsMavenRepositoryLibraryDescriptor libDescriptor;
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(11);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(12);
        }
        if ((libDescriptor = libraryProps.getRepositoryLibraryDescriptor()).getMavenId() != null) {
            EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc, (String[])new String[]{libraryProps.getPackaging()});
            return JarRepositoryManager.loadDependenciesModal(project2, libDescriptor, kinds, repositories, copyTo);
        }
        return Collections.emptyList();
    }

    public static Collection<OrderRoot> loadDependenciesModal(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(13);
        }
        if (desc == null) {
            JarRepositoryManager.$$$reportNull$$$0(14);
        }
        List<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.selectRemoteRepositories(project2, desc, repositories);
        return JarRepositoryManager.submitModalJob(project2, JavaUiBundle.message("jar.repository.manager.dialog.resolving.dependencies.title", 1), JarRepositoryManager.newOrderRootResolveJob(project2, desc, artifactKinds, effectiveRepos, copyTo));
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(15);
        }
        EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc, (String[])new String[]{libraryProps.getPackaging()});
        return JarRepositoryManager.loadDependenciesAsync(project2, libraryProps.getRepositoryLibraryDescriptor(), kinds, repos, copyTo);
    }

    public static Promise<List<OrderRoot>> loadDependenciesAsync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(16);
        }
        List<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.selectRemoteRepositories(project2, desc, repos);
        return JarRepositoryManager.submitBackgroundJob(JarRepositoryManager.newOrderRootResolveJob(project2, desc, artifactKinds, effectiveRepos, copyTo));
    }

    @Nullable
    public static List<OrderRoot> loadDependenciesSync(@NotNull Project project2, JpsMavenRepositoryLibraryDescriptor desc, Set<ArtifactKind> artifactKinds, @Nullable List<RemoteRepositoryDescription> repos, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(17);
        }
        List<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.selectRemoteRepositories(project2, desc, repos);
        return JarRepositoryManager.submitSyncJob(JarRepositoryManager.newOrderRootResolveJob(project2, desc, artifactKinds, effectiveRepos, copyTo));
    }

    @ApiStatus.Internal
    @NotNull
    public static Collection<OrderRoot> loadDependenciesSync(@NotNull Project project2, @NotNull RepositoryLibraryProperties libraryProps, boolean loadSources, boolean loadJavadoc, @Nullable String copyTo, @Nullable Collection<RemoteRepositoryDescription> repositories, @NotNull ProgressIndicator progressIndicator) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(18);
        }
        if (libraryProps == null) {
            JarRepositoryManager.$$$reportNull$$$0(19);
        }
        if (progressIndicator == null) {
            JarRepositoryManager.$$$reportNull$$$0(20);
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        JpsMavenRepositoryLibraryDescriptor libDescriptor = libraryProps.getRepositoryLibraryDescriptor();
        if (libDescriptor.getMavenId() != null) {
            EnumSet kinds = ArtifactKind.kindsOf((boolean)loadSources, (boolean)loadJavadoc, (String[])new String[]{libraryProps.getPackaging()});
            List<RemoteRepositoryDescription> effectiveRepos = JarRepositoryManager.selectRemoteRepositories(project2, libDescriptor, repositories);
            Collection collection = JarRepositoryManager.newOrderRootResolveJob(project2, libDescriptor, kinds, effectiveRepos, copyTo).apply(progressIndicator);
            if (collection == null) {
                JarRepositoryManager.$$$reportNull$$$0(21);
            }
            return collection;
        }
        List<OrderRoot> list2 = Collections.emptyList();
        if (list2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(22);
        }
        return list2;
    }

    @VisibleForTesting
    @ApiStatus.Internal
    public static List<RemoteRepositoryDescription> selectRemoteRepositories(@NotNull Project project2, @Nullable JpsMavenRepositoryLibraryDescriptor desc, @Nullable Collection<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(23);
        }
        if (repositories != null && !repositories.isEmpty()) {
            return repositories.stream().toList();
        }
        RemoteRepositoryDescription repositoryFromDescriptor = JarRepositoryManager.getRemoteRepositoryFromLibrary(project2, desc);
        if (repositoryFromDescriptor != null) {
            return List.of(repositoryFromDescriptor);
        }
        return RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
    }

    @Nullable
    private static RemoteRepositoryDescription getRemoteRepositoryFromLibrary(@NotNull Project project2, @Nullable JpsMavenRepositoryLibraryDescriptor desc) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(24);
        }
        if (desc == null) {
            return null;
        }
        String repositoryId = desc.getJarRepositoryId();
        if (repositoryId == null) {
            return null;
        }
        return (RemoteRepositoryDescription)ContainerUtil.find((Iterable)RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories(), it -> it.getId().equals(repositoryId));
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(@NotNull Project project2, @NotNull RepositoryLibraryDescription libraryDescription) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(25);
        }
        if (libraryDescription == null) {
            JarRepositoryManager.$$$reportNull$$$0(26);
        }
        return JarRepositoryManager.getAvailableVersions(project2, libraryDescription, Collections.emptyList());
    }

    @NotNull
    public static Promise<Collection<String>> getAvailableVersions(@NotNull Project project2, @NotNull RepositoryLibraryDescription libraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(27);
        }
        if (libraryDescription == null) {
            JarRepositoryManager.$$$reportNull$$$0(28);
        }
        if (repositories == null) {
            JarRepositoryManager.$$$reportNull$$$0(29);
        }
        List<RemoteRepositoryDescription> repos = JarRepositoryManager.selectRemoteRepositories(project2, null, repositories).stream().toList();
        return JarRepositoryManager.submitBackgroundJob(new VersionResolveJob(project2, libraryDescription, repos));
    }

    @Nullable
    public static ArtifactDependencyNode loadDependenciesTree(final @NotNull RepositoryLibraryDescription description, final @NotNull String version, Project project2) {
        if (description == null) {
            JarRepositoryManager.$$$reportNull$$$0(30);
        }
        if (version == null) {
            JarRepositoryManager.$$$reportNull$$$0(31);
        }
        List repositories = RemoteRepositoriesConfiguration.getInstance((Project)project2).getRepositories();
        return JarRepositoryManager.submitModalJob(project2, JavaUiBundle.message("jar.repository.manager.dialog.resolving.dependencies.title", 0), new AetherJob<ArtifactDependencyNode>(project2, (Collection)repositories){

            @Override
            protected String getProgressText() {
                return JavaUiBundle.message("jar.repository.manager.progress.text.loading.dependencies", description.getMavenCoordinates(version));
            }

            @Override
            protected ArtifactDependencyNode perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
                if (manager == null) {
                    2.$$$reportNull$$$0(0);
                }
                return manager.collectDependencies(description.getGroupId(), description.getArtifactId(), version);
            }

            @Override
            protected ArtifactDependencyNode getDefaultResult() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/jarRepository/JarRepositoryManager$2", "perform"));
            }
        });
    }

    private static void notifyArtifactsDownloaded(Project project2, Collection<OrderRoot> roots) {
        StringBuilder sb = new StringBuilder();
        String title = JavaUiBundle.message("jar.repository.manager.notification.title.downloaded", new Object[0]);
        for (OrderRoot root : roots) {
            sb.append("<p/>");
            sb.append(root.getFile().getName());
        }
        @NlsSafe String content = sb.toString();
        Notifications.Bus.notify((Notification)JarRepositoryManager.getNotificationGroup().createNotification(title, content, NotificationType.INFORMATION), (Project)project2);
    }

    public static void searchArtifacts(Project project2, String coord, Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        JarRepositoryManager.searchArtifacts(project2, coord, "jar", resultProcessor);
    }

    public static void searchArtifacts(final Project project2, String coord, String packaging, final Consumer<? super Collection<Pair<RepositoryArtifactDescription, RemoteRepositoryDescription>>> resultProcessor) {
        if (coord == null || coord.isEmpty()) {
            return;
        }
        final RepositoryArtifactDescription template = coord.indexOf(58) == -1 && Character.isUpperCase(coord.charAt(0)) ? new RepositoryArtifactDescription(null, null, null, packaging, null, coord, null) : new RepositoryArtifactDescription(new RepositoryLibraryProperties(coord, packaging, true), null);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, JavaPsiBundle.message((String)"task.background.title.maven", (Object[])new Object[0]), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                ArrayList<Pair> resultList = new ArrayList<Pair>();
                try {
                    for (String serviceUrl : MavenRepositoryServicesManager.getServiceUrls((Project)project2)) {
                        try {
                            List artifacts = MavenRepositoryServicesManager.findArtifacts((RepositoryArtifactDescription)template, (String)serviceUrl);
                            if (artifacts.isEmpty()) continue;
                            List repositories = MavenRepositoryServicesManager.getRepositories((String)serviceUrl);
                            HashMap<String, RemoteRepositoryDescription> map = new HashMap<String, RemoteRepositoryDescription>();
                            for (RemoteRepositoryDescription repository : repositories) {
                                map.put(repository.getId(), repository);
                            }
                            for (RepositoryArtifactDescription artifact : artifacts) {
                                RemoteRepositoryDescription repository = (RemoteRepositoryDescription)map.get(artifact.getRepositoryId());
                                if (repository == null) continue;
                                resultList.add(Pair.create((Object)artifact, (Object)repository));
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.accept(resultList));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$3", "run"));
            }
        });
    }

    public static void searchRepositories(Project project2, final Collection<String> serviceUrls, final Processor<? super Collection<RemoteRepositoryDescription>> resultProcessor) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project2, JavaPsiBundle.message((String)"task.background.title.maven", (Object[])new Object[0]), false){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    4.$$$reportNull$$$0(0);
                }
                Ref result = Ref.create(Collections.emptyList());
                try {
                    ArrayList repoList = new ArrayList();
                    for (String url : serviceUrls) {
                        List repositories;
                        try {
                            repositories = MavenRepositoryServicesManager.getRepositories((String)url);
                        }
                        catch (Exception ex) {
                            LOG.warn("Accessing Service at: " + url, (Throwable)ex);
                            continue;
                        }
                        repoList.addAll(repositories);
                    }
                    result.set(repoList);
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> resultProcessor.process(result.get()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$4", "run"));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T submitSyncJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        if (job == null) {
            JarRepositoryManager.$$$reportNull$$$0(32);
        }
        try {
            ourTasksInProgress.incrementAndGet();
            ProgressIndicator parentIndicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
            EmptyProgressIndicator indicator = parentIndicator == null ? new EmptyProgressIndicator(ModalityState.defaultModalityState()) : ProgressWrapper.wrap((ProgressIndicator)parentIndicator);
            Object object = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$submitSyncJob$3(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
            return (T)object;
        }
        finally {
            ourTasksInProgress.decrementAndGet();
        }
    }

    @Nullable
    private static <T> T submitModalJob(@Nullable Project project2, @NlsContexts.DialogTitle String title, final Function<? super ProgressIndicator, ? extends T> job) {
        SlowOperations.assertSlowOperationsAreAllowed();
        final Ref result = Ref.create(null);
        new Task.Modal(project2, title, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    5.$$$reportNull$$$0(0);
                }
                try {
                    ourTasksInProgress.incrementAndGet();
                    result.set(job.apply(indicator));
                }
                finally {
                    ourTasksInProgress.decrementAndGet();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/jarRepository/JarRepositoryManager$5", "run"));
            }
        }.queue();
        return (T)result.get();
    }

    @NotNull
    public static <T> Promise<T> submitBackgroundJob(@NotNull Function<? super ProgressIndicator, ? extends T> job) {
        if (job == null) {
            JarRepositoryManager.$$$reportNull$$$0(33);
        }
        ModalityState startModality = ModalityState.defaultModalityState();
        AsyncPromise promise2 = new AsyncPromise();
        DOWNLOADER_EXECUTOR.execute(() -> {
            if (promise2.isCancelled()) {
                return;
            }
            try {
                ourTasksInProgress.incrementAndGet();
                EmptyProgressIndicator indicator = new EmptyProgressIndicator(startModality);
                Object result = ProgressManager.getInstance().runProcess(() -> JarRepositoryManager.lambda$submitBackgroundJob$4(job, (ProgressIndicator)indicator), (ProgressIndicator)indicator);
                promise2.setResult(result);
            }
            catch (ProcessCanceledException ignored) {
                promise2.cancel();
            }
            catch (Throwable e) {
                LOG.info(e);
                promise2.setError(e);
            }
            finally {
                ourTasksInProgress.decrementAndGet();
            }
        });
        AsyncPromise asyncPromise = promise2;
        if (asyncPromise == null) {
            JarRepositoryManager.$$$reportNull$$$0(34);
        }
        return asyncPromise;
    }

    @NotNull
    private static Collection<String> lookupVersionsImpl(String groupId, String artifactId, @NotNull ArtifactRepositoryManager manager) throws Exception {
        List list2;
        if (manager == null) {
            JarRepositoryManager.$$$reportNull$$$0(35);
        }
        try {
            ArrayList versions = new ArrayList(manager.getAvailableVersions(groupId, artifactId, "[0,)", ArtifactKind.ARTIFACT));
            list2 = ContainerUtil.map((Collection)versions.reversed(), Version::toString);
        }
        catch (TransferCancelledException e) {
            throw new ProcessCanceledException((Throwable)e);
        }
        if (list2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(36);
        }
        return list2;
    }

    private static Function<ProgressIndicator, List<OrderRoot>> newOrderRootResolveJob(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(37);
        }
        if (desc == null) {
            JarRepositoryManager.$$$reportNull$$$0(38);
        }
        if (kinds == null) {
            JarRepositoryManager.$$$reportNull$$$0(39);
        }
        if (repositories == null) {
            JarRepositoryManager.$$$reportNull$$$0(40);
        }
        return new LibraryResolveJob(project2, desc, kinds, repositories).andThen(resolved -> resolved.isEmpty() ? Collections.emptyList() : JarRepositoryManager.copyAndRefreshFiles(project2, resolved, copyTo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<OrderRoot> copyAndRefreshFiles(@NotNull Project project2, @NotNull Collection<Artifact> artifacts, @Nullable String copyTo) {
        if (project2 == null) {
            JarRepositoryManager.$$$reportNull$$$0(41);
        }
        if (artifacts == null) {
            JarRepositoryManager.$$$reportNull$$$0(42);
        }
        ArrayList<OrderRoot> result = new ArrayList<OrderRoot>();
        VirtualFileManager manager = VirtualFileManager.getInstance();
        String repositoryPath = JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject(project2).toString();
        EelMachine targetRepositoryMachine = EelProviderUtil.getEelMachine((Project)project2);
        for (Artifact each : artifacts) {
            long ms = System.currentTimeMillis();
            try {
                File repoFile;
                File toFile = repoFile = each.getFile();
                if (copyTo != null) {
                    toFile = new File(copyTo, repoFile.getName());
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                } else if (!targetRepositoryMachine.ownsPath(Path.of(each.getFile().getPath(), new String[0]))) {
                    String suffix = repoFile.getAbsolutePath().substring(repositoryPath.length());
                    String actualPath = repositoryPath + suffix;
                    toFile = new File(actualPath);
                    if (repoFile.exists()) {
                        FileUtil.copy((File)repoFile, (File)toFile);
                    }
                }
                if (!DO_REFRESH) continue;
                manager.refreshAndFindFileByUrl(VfsUtilCore.pathToUrl((String)toFile.getPath()));
                String url = VfsUtil.getUrlForLibraryRoot((File)toFile);
                VirtualFile file = manager.refreshAndFindFileByUrl(url);
                if (file == null) continue;
                OrderRootType rootType = ourClassifierToRootType.getOrDefault(each.getClassifier(), OrderRootType.CLASSES);
                result.add(new OrderRoot(file, rootType));
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            finally {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Artifact " + each.toString() + " refreshed in " + (System.currentTimeMillis() - ms) + "ms");
            }
        }
        return result;
    }

    private static /* synthetic */ Object lambda$submitBackgroundJob$4(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    private static /* synthetic */ Object lambda$submitSyncJob$3(Function job, ProgressIndicator indicator) {
        return job.apply(indicator);
    }

    static {
        ourClassifierToRootType.put(ArtifactKind.ARTIFACT.getClassifier(), OrderRootType.CLASSES);
        ourClassifierToRootType.put(ArtifactKind.JAVADOC.getClassifier(), JavadocOrderRootType.getInstance());
        ourClassifierToRootType.put(ArtifactKind.SOURCES.getClassifier(), OrderRootType.SOURCES);
        ourClassifierToRootType.put(ArtifactKind.ANNOTATIONS.getClassifier(), AnnotationOrderRootType.getInstance());
        DOWNLOADER_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"RemoteLibraryDownloader", (Executor)ProcessIOExecutorService.INSTANCE, (int)4);
        DO_REFRESH = SystemProperties.getBooleanProperty((String)"idea.do.refresh.after.jps.library.downloaded", (boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 38, 39, 40, 41, 42 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 37: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryProps";
                break;
            }
            case 14: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "desc";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryDescription";
                break;
            }
            case 29: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifacts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroup";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getJPSLocalMavenRepositoryForIdeaProject";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepositoryPath";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDependenciesSync";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "submitBackgroundJob";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "lookupVersionsImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "chooseLibraryAndDownload";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveAndDownload";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getJPSLocalMavenRepositoryForIdeaProject";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesModal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesAsync";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesSync";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selectRemoteRepositories";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRemoteRepositoryFromLibrary";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableVersions";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "loadDependenciesTree";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "submitSyncJob";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "submitBackgroundJob";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lookupVersionsImpl";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newOrderRootResolveJob";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "copyAndRefreshFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 38, 39, 40, 41, 42 -> new IllegalArgumentException(string);
        };
    }

    private static class VersionResolveJob
    extends AetherJob<Collection<String>> {
        @NotNull
        private final RepositoryLibraryDescription myDescription;

        VersionResolveJob(@NotNull Project project2, @NotNull RepositoryLibraryDescription repositoryLibraryDescription, @NotNull List<RemoteRepositoryDescription> repositories) {
            if (project2 == null) {
                VersionResolveJob.$$$reportNull$$$0(0);
            }
            if (repositoryLibraryDescription == null) {
                VersionResolveJob.$$$reportNull$$$0(1);
            }
            if (repositories == null) {
                VersionResolveJob.$$$reportNull$$$0(2);
            }
            super(project2, repositories);
            this.myDescription = repositoryLibraryDescription;
        }

        @Override
        protected String getProgressText() {
            return JavaUiBundle.message("jar.repository.manager.version.resolve.progress.text", this.myDescription.getDisplayName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Collection<String> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            Collection<String> collection;
            if (manager == null) {
                VersionResolveJob.$$$reportNull$$$0(3);
            }
            Instant startTime = Instant.now();
            slf4jLogger.debug("VersionResolveJob({}:{}) #{} started", new Object[]{this.myDescription.getGroupId(), this.myDescription.getArtifactId(), Thread.currentThread().getId()});
            try {
                collection = JarRepositoryManager.lookupVersionsImpl(this.myDescription.getGroupId(), this.myDescription.getArtifactId(), manager);
            }
            catch (Throwable throwable) {
                slf4jLogger.debug("VersionResolveJob({}:{}) #{} finished in {}ms", new Object[]{this.myDescription.getGroupId(), this.myDescription.getArtifactId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis()});
                throw throwable;
            }
            slf4jLogger.debug("VersionResolveJob({}:{}) #{} finished in {}ms", new Object[]{this.myDescription.getGroupId(), this.myDescription.getArtifactId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis()});
            return collection;
        }

        @Override
        protected Collection<String> getDefaultResult() {
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositoryLibraryDescription";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager$VersionResolveJob";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LibraryResolveJob
    extends AetherJob<Collection<Artifact>> {
        @NotNull
        private final JpsMavenRepositoryLibraryDescriptor myDesc;
        @NotNull
        private final Set<ArtifactKind> myKinds;

        LibraryResolveJob(@NotNull Project project2, @NotNull JpsMavenRepositoryLibraryDescriptor desc, @NotNull Set<ArtifactKind> kinds, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (project2 == null) {
                LibraryResolveJob.$$$reportNull$$$0(0);
            }
            if (desc == null) {
                LibraryResolveJob.$$$reportNull$$$0(1);
            }
            if (kinds == null) {
                LibraryResolveJob.$$$reportNull$$$0(2);
            }
            if (repositories == null) {
                LibraryResolveJob.$$$reportNull$$$0(3);
            }
            super(project2, repositories);
            this.myDesc = desc;
            this.myKinds = kinds;
        }

        @Override
        protected boolean canStart() {
            return super.canStart() && this.myDesc.getMavenId() != null;
        }

        @Override
        protected String getProgressText() {
            return JavaUiBundle.message("jar.repository.manager.library.resolve.progress.text", RepositoryLibraryDescription.findDescription((JpsMavenRepositoryLibraryDescriptor)this.myDesc).getDisplayName());
        }

        @Override
        protected Collection<Artifact> getDefaultResult() {
            return Collections.emptyList();
        }

        @Override
        protected Collection<Artifact> perform(ProgressIndicator progress, @NotNull ArtifactRepositoryManager manager) throws Exception {
            if (manager == null) {
                LibraryResolveJob.$$$reportNull$$$0(4);
            }
            Instant startTime = Instant.now();
            slf4jLogger.debug("LibraryResolveJob({}) #{} started", (Object)this.myDesc.getMavenId(), (Object)Thread.currentThread().getId());
            String version = this.myDesc.getVersion();
            try {
                Collection artifacts = manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), version, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
                slf4jLogger.debug("LibraryResolveJob({}) #{} successfully finished in {}ms with {} artifacts", new Object[]{this.myDesc.getMavenId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis(), artifacts.size()});
                Collection collection = artifacts;
                return collection;
            }
            catch (TransferCancelledException e) {
                slf4jLogger.debug("LibraryResolveJob({}) #{} failed in {}ms", new Object[]{this.myDesc.getMavenId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis(), e});
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (RepositoryOfflineException e) {
                slf4jLogger.debug("LibraryResolveJob({}) #{} failed in {}ms", new Object[]{this.myDesc.getMavenId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis(), e});
                throw e;
            }
            catch (Exception e) {
                slf4jLogger.warn("LibraryResolveJob({}) #{} failed in {}ms", new Object[]{this.myDesc.getMavenId(), Thread.currentThread().getId(), Duration.between(startTime, Instant.now()).toMillis(), e});
                String resolvedVersion = this.resolveVersion(manager, version);
                if (Objects.equals(version, resolvedVersion)) {
                    throw e;
                }
                try {
                    Collection collection = manager.resolveDependencyAsArtifact(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), resolvedVersion, this.myKinds, this.myDesc.isIncludeTransitiveDependencies(), this.myDesc.getExcludedDependencies());
                    return collection;
                }
                catch (TransferCancelledException e1) {
                    throw new ProcessCanceledException((Throwable)e1);
                }
            }
            finally {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Artifact " + String.valueOf(this.myDesc) + " resolved in " + Duration.between(startTime, Instant.now()).toMillis() + "ms");
                }
            }
        }

        @Nullable
        private String resolveVersion(ArtifactRepositoryManager manager, String version) throws Exception {
            boolean isLatest = "LATEST".equals(version);
            boolean isRelease = "RELEASE".equals(version);
            if (isLatest || isRelease) {
                try {
                    for (String ver : JarRepositoryManager.lookupVersionsImpl(this.myDesc.getGroupId(), this.myDesc.getArtifactId(), manager)) {
                        if (isRelease && ver.endsWith("-SNAPSHOT")) continue;
                        return ver;
                    }
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error("Got unexpected exception while resolving artifact versions", (Throwable)e);
                }
            }
            return version;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "desc";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kinds";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "repositories";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jarRepository/JarRepositoryManager$LibraryResolveJob";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "perform";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class AetherJob<T>
    implements Function<ProgressIndicator, T> {
        @NotNull
        private final Project myProject;
        @NotNull
        private final Collection<RemoteRepositoryDescription> myRepositories;

        AetherJob(@NotNull Project project2, @NotNull Collection<RemoteRepositoryDescription> repositories) {
            if (project2 == null) {
                AetherJob.$$$reportNull$$$0(0);
            }
            if (repositories == null) {
                AetherJob.$$$reportNull$$$0(1);
            }
            this.myProject = project2;
            this.myRepositories = repositories;
        }

        protected boolean canStart() {
            return !this.myRepositories.isEmpty();
        }

        @Override
        public final T apply(final ProgressIndicator indicator) {
            if (this.canStart()) {
                indicator.setText(this.getProgressText());
                indicator.setIndeterminate(true);
                List<RemoteRepository> remotes = AetherJob.createRemoteRepositories(this.myRepositories);
                try {
                    return this.perform(indicator, new ArtifactRepositoryManager(JarRepositoryManager.getJPSLocalMavenRepositoryForIdeaProject(this.myProject).toFile(), remotes, new ProgressConsumer(){

                        public void consume(@NlsContexts.ProgressText String message) {
                            indicator.setText(message);
                        }

                        public boolean isCanceled() {
                            return indicator.isCanceled();
                        }
                    }));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.info((Throwable)e);
                }
            }
            return this.getDefaultResult();
        }

        private static List<RemoteRepository> createRemoteRepositories(Collection<RemoteRepositoryDescription> repositoryDescriptions) {
            ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
            for (RemoteRepositoryDescription repository : repositoryDescriptions) {
                ArtifactRepositoryManager.ArtifactAuthenticationData authData = JarRepositoryAuthenticationDataProviderKt.obtainAuthenticationData(repository);
                remotes.add(ArtifactRepositoryManager.createRemoteRepository((String)repository.getId(), (String)repository.getUrl(), (ArtifactRepositoryManager.ArtifactAuthenticationData)authData, (boolean)repository.isAllowSnapshots()));
            }
            return remotes;
        }

        @NlsContexts.ProgressText
        protected abstract String getProgressText();

        protected abstract T perform(ProgressIndicator var1, @NotNull ArtifactRepositoryManager var2) throws Exception;

        protected abstract T getDefaultResult();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositories";
                    break;
                }
            }
            objectArray[1] = "com/intellij/jarRepository/JarRepositoryManager$AetherJob";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

