/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0013\u001a\u00070\u000b\u00a2\u0006\u0002\b\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/ClasspathFormatUI;", "", "providers", "", "Lcom/intellij/openapi/roots/impl/storage/ClasspathStorageProvider;", "state", "Lcom/intellij/openapi/roots/ui/configuration/ModuleConfigurationState;", "<init>", "([Lcom/intellij/openapi/roots/impl/storage/ClasspathStorageProvider;Lcom/intellij/openapi/roots/ui/configuration/ModuleConfigurationState;)V", "comboBoxClasspathFormat", "Lcom/intellij/openapi/ui/ComboBox;", "", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "selectedClasspathFormat", "getSelectedClasspathFormat", "()Ljava/lang/String;", "moduleClasspathFormat", "Lcom/intellij/openapi/util/NlsSafe;", "getModuleClasspathFormat", "isModified", "", "()Z", "canApply", "", "apply", "intellij.java.ui"})
public final class ClasspathFormatUI {
    @NotNull
    private final ModuleConfigurationState state;
    private ComboBox<String> comboBoxClasspathFormat;
    @NotNull
    private final DialogPanel panel;

    public ClasspathFormatUI(@NotNull ClasspathStorageProvider[] providers, @NotNull ModuleConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.state = state;
        this.panel = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> ClasspathFormatUI.panel$lambda$0(providers, this, arg_0));
    }

    @NotNull
    public final DialogPanel getPanel() {
        return this.panel;
    }

    @NotNull
    public final String getSelectedClasspathFormat() {
        ComboBox<String> comboBox = this.comboBoxClasspathFormat;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"comboBoxClasspathFormat");
            comboBox = null;
        }
        Object object = comboBox.getSelectedItem();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    @NotNull
    public final String getModuleClasspathFormat() {
        String string = ClassPathStorageUtil.getStorageType((Module)this.state.getCurrentRootModel().getModule());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStorageType(...)");
        return string;
    }

    public final boolean isModified() {
        return !Intrinsics.areEqual((Object)this.getSelectedClasspathFormat(), (Object)this.getModuleClasspathFormat());
    }

    public final void canApply() throws ConfigurationException {
        block0: {
            ClasspathStorageProvider provider;
            ClasspathStorageProvider classpathStorageProvider = provider = ClasspathStorage.getProvider((String)this.getSelectedClasspathFormat());
            if (classpathStorageProvider == null) break block0;
            classpathStorageProvider.assertCompatible(this.state.getCurrentRootModel());
        }
    }

    public final void apply() throws ConfigurationException {
        this.canApply();
        ClasspathStorage.setStorageType((ModuleRootModel)this.state.getCurrentRootModel(), (String)this.getSelectedClasspathFormat());
    }

    private static final String panel$lambda$0$0$0(Map $formatIdToDescription, String item) {
        return (String)$formatIdToDescription.get(item);
    }

    private static final Unit panel$lambda$0$0$1(ClasspathFormatUI this$0, ComboBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        $this$applyToComponent.setSelectedItem((Object)this$0.getModuleClasspathFormat());
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0$0(ClasspathFormatUI this$0, Map $formatIdToDescription, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.comboBoxClasspathFormat = (ComboBox)$this$row.comboBox((Collection)$formatIdToDescription.keySet(), BuilderKt.textListCellRenderer(arg_0 -> ClasspathFormatUI.panel$lambda$0$0$0($formatIdToDescription, arg_0))).applyToComponent(arg_0 -> ClasspathFormatUI.panel$lambda$0$0$1(this$0, arg_0)).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit panel$lambda$0(ClasspathStorageProvider[] $providers, ClasspathFormatUI this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Map formatIdToDescription = new LinkedHashMap();
        formatIdToDescription.put("default", JavaUiBundle.message("project.roots.classpath.format.default.descr", new Object[0]));
        for (ClasspathStorageProvider provider : $providers) {
            formatIdToDescription.put(provider.getID(), provider.getDescription());
        }
        String string = JavaUiBundle.message("project.roots.classpath.format.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$panel.row(string, arg_0 -> ClasspathFormatUI.panel$lambda$0$0(this$0, formatIdToDescription, arg_0));
        return Unit.INSTANCE;
    }
}

