/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.ide.JavaUiBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import org.jetbrains.annotations.NotNull;

public class AddLibraryToModuleDependenciesAction
extends DumbAwareAction {
    @NotNull
    private final BaseLibrariesConfigurable myConfigurable;

    public AddLibraryToModuleDependenciesAction(@NotNull BaseLibrariesConfigurable configurable) {
        if (configurable == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(0);
        }
        super(JavaUiBundle.message("action.text.add.to.modules", new Object[0]), JavaUiBundle.message("action.description.add.the.library.to.the.dependencies.list.of.chosen.modules", new Object[0]), null);
        this.myConfigurable = configurable;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(1);
        }
        ProjectStructureElement element = (ProjectStructureElement)e.getUpdateSession().compute((Object)this, "getSelection", ActionUpdateThread.EDT, () -> this.myConfigurable.getSelectedElement());
        boolean visible = false;
        if (element instanceof LibraryProjectStructureElement) {
            LibraryEx library = (LibraryEx)((LibraryProjectStructureElement)element).getLibrary();
            visible = !LibraryEditingUtil.getSuitableModules(this.myConfigurable.getProjectStructureConfigurable().getModulesConfig(), (LibraryKind)library.getKind(), (Library)library).isEmpty();
        }
        e.getPresentation().setVisible(visible);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        LibraryProjectStructureElement element;
        if (e == null) {
            AddLibraryToModuleDependenciesAction.$$$reportNull$$$0(3);
        }
        if ((element = (LibraryProjectStructureElement)this.myConfigurable.getSelectedElement()) == null) {
            return;
        }
        Library library = element.getLibrary();
        ProjectStructureValidator.showDialogAndAddLibraryToDependencies(library, this.myConfigurable.getProjectStructureConfigurable(), false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurable";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/AddLibraryToModuleDependenciesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/AddLibraryToModuleDependenciesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

