/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SimpleMergingQueue;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ProjectStructureDaemonAnalyzer.class);
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> myProblemHolders;
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> mySourceElement2Usages;
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> myContainingElement2Usages;
    private final Set<ProjectStructureElement> myElementWithNotCalculatedUsages;
    private final Set<ProjectStructureElement> myElementsToShowWarningIfUnused;
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> myWarningsAboutUnused;
    private final SimpleMergingQueue<Runnable> myAnalyzerQueue;
    private final SimpleMergingQueue<Runnable> myResultsUpdateQueue;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> myDispatcher;
    private final AtomicBoolean myStopped;
    private final ProjectConfigurationProblems myProjectConfigurationProblems;

    public ProjectStructureDaemonAnalyzer(@NotNull StructureConfigurableContext context) {
        if (context == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(0);
        }
        this.myProblemHolders = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
        this.mySourceElement2Usages = new MultiValuesMap();
        this.myContainingElement2Usages = new MultiValuesMap();
        this.myElementWithNotCalculatedUsages = new HashSet<ProjectStructureElement>();
        this.myElementsToShowWarningIfUnused = new HashSet<ProjectStructureElement>();
        this.myWarningsAboutUnused = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
        this.myDispatcher = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
        this.myStopped = new AtomicBoolean(false);
        Disposer.register((Disposable)context, (Disposable)this);
        this.myProjectConfigurationProblems = new ProjectConfigurationProblems(this, context);
        this.myAnalyzerQueue = new SimpleMergingQueue("Project Structure Daemon Analyzer", 300, false, Alarm.ThreadToUse.POOLED_THREAD, this);
        this.myResultsUpdateQueue = new SimpleMergingQueue("Project Structure Analysis Results Updater", 300, false, Alarm.ThreadToUse.SWING_THREAD, this);
    }

    private void doUpdate(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(1);
        }
        if (this.myStopped.get()) {
            return;
        }
        this.doCheck(element);
        this.doCollectUsages(element);
    }

    private void doCheck(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(2);
        }
        ProjectStructureProblemsHolderImpl problemsHolder = new ProjectStructureProblemsHolderImpl();
        ReadAction.run(() -> {
            if (this.myStopped.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("checking " + String.valueOf(element));
            }
            ProjectStructureValidator.check(element, problemsHolder);
        });
        this.myResultsUpdateQueue.queue(new ProblemsComputedUpdate(element, problemsHolder));
    }

    private void doCollectUsages(@NotNull ProjectStructureElement element) {
        List usages;
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(3);
        }
        if ((usages = (List)ReadAction.compute(() -> {
            if (this.myStopped.get()) {
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("collecting usages in " + String.valueOf(element));
            }
            return ProjectStructureDaemonAnalyzer.getUsagesInElement(element);
        })) != null) {
            this.myResultsUpdateQueue.queue(new UsagesCollectedUpdate(element, usages));
        }
    }

    private static List<ProjectStructureElementUsage> getUsagesInElement(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(4);
        }
        return ProjectStructureValidator.getUsagesInElement(element);
    }

    private void updateUsages(@NotNull ProjectStructureElement element, @NotNull List<? extends ProjectStructureElementUsage> usages) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(5);
        }
        if (usages == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(6);
        }
        this.removeUsagesInElement(element);
        for (ProjectStructureElementUsage projectStructureElementUsage : usages) {
            this.addUsage(projectStructureElementUsage);
        }
        this.myElementWithNotCalculatedUsages.remove(element);
        this.myResultsUpdateQueue.queue(new ReportUnusedElementsUpdate());
    }

    public void queueUpdate(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(7);
        }
        this.queueUpdates(List.of(element));
    }

    public void queueUpdates(@NotNull Collection<? extends ProjectStructureElement> elements) {
        if (elements == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(8);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("start checking and collecting usages for " + String.valueOf(elements));
        }
        this.myElementWithNotCalculatedUsages.addAll(elements);
        for (ProjectStructureElement projectStructureElement : elements) {
            if (!projectStructureElement.shouldShowWarningIfUnused()) continue;
            this.myElementsToShowWarningIfUnused.add(projectStructureElement);
        }
        this.myAnalyzerQueue.queue(ContainerUtil.map(elements, x$0 -> new AnalyzeElementUpdate((ProjectStructureElement)x$0)));
    }

    public void removeElement(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(9);
        }
        this.removeElements(Collections.singletonList(element));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> elements) {
        if (elements == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(10);
        }
        for (ProjectStructureElement projectStructureElement : elements) {
            this.myElementWithNotCalculatedUsages.remove(projectStructureElement);
            this.myElementsToShowWarningIfUnused.remove(projectStructureElement);
            this.myWarningsAboutUnused.remove(projectStructureElement);
            this.myProblemHolders.remove(projectStructureElement);
            Collection usages = this.mySourceElement2Usages.removeAll((Object)projectStructureElement);
            if (usages != null) {
                for (ProjectStructureElementUsage usage : usages) {
                    this.myProblemHolders.remove(usage.getContainingElement());
                }
            }
            this.removeUsagesInElement(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.myResultsUpdateQueue.queue(new ReportUnusedElementsUpdate());
    }

    private void reportUnusedElements() {
        if (!this.myElementWithNotCalculatedUsages.isEmpty()) {
            return;
        }
        for (ProjectStructureElement element : this.myElementsToShowWarningIfUnused) {
            Collection usages = this.mySourceElement2Usages.get((Object)element);
            ProjectStructureProblemDescription warning = usages == null || usages.isEmpty() ? element.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription old = this.myWarningsAboutUnused.put(element, warning);
            ProjectStructureProblemsHolderImpl holder = this.myProblemHolders.get(element);
            if (holder == null) {
                holder = new ProjectStructureProblemsHolderImpl();
                this.myProblemHolders.put(element, holder);
            }
            if (old != null) {
                holder.removeProblem(old);
            }
            if (warning != null) {
                holder.registerProblem(warning);
            }
            if (old == null && warning == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.myDispatcher.getMulticaster()).problemsChanged(element);
        }
    }

    private void removeUsagesInElement(ProjectStructureElement element) {
        Collection usages = this.myContainingElement2Usages.removeAll((Object)element);
        if (usages != null) {
            for (ProjectStructureElementUsage usage : usages) {
                this.mySourceElement2Usages.remove((Object)usage.getSourceElement(), (Object)usage);
            }
        }
    }

    private void addUsage(@NotNull ProjectStructureElementUsage usage) {
        if (usage == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(11);
        }
        this.mySourceElement2Usages.put((Object)usage.getSourceElement(), (Object)usage);
        this.myContainingElement2Usages.put((Object)usage.getContainingElement(), (Object)usage);
    }

    public void stop() {
        LOG.debug("analyzer stopped");
        this.myStopped.set(true);
        this.clearCaches();
        this.myAnalyzerQueue.stop();
        this.myResultsUpdateQueue.stop();
    }

    public void clearCaches() {
        LOG.debug("clear caches");
        this.myProblemHolders.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        ArrayList<ProjectStructureElement> toUpdate = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.myProblemHolders.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            toUpdate.add(entry.getKey());
        }
        this.myProblemHolders.clear();
        LOG.debug("Adding to queue updates for " + toUpdate.size() + " problematic elements");
        this.queueUpdates(toUpdate);
    }

    public void dispose() {
        this.myStopped.set(true);
        this.myAnalyzerQueue.stop();
        this.myResultsUpdateQueue.stop();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(@NotNull ProjectStructureElement element) {
        if (element == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(12);
        }
        return this.myProblemHolders.get(element);
    }

    public Collection<ProjectStructureElementUsage> getUsages(@NotNull ProjectStructureElement selected) {
        ProjectStructureElement[] elements;
        if (selected == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(13);
        }
        for (ProjectStructureElement element : elements = this.myElementWithNotCalculatedUsages.toArray(new ProjectStructureElement[0])) {
            this.updateUsages(element, ProjectStructureDaemonAnalyzer.getUsagesInElement(element));
        }
        List<ProjectStructureElementUsage> usages = this.mySourceElement2Usages.get((Object)selected);
        return usages != null ? usages : Collections.emptyList();
    }

    public void addListener(@NotNull ProjectStructureDaemonAnalyzerListener listener) {
        if (listener == null) {
            ProjectStructureDaemonAnalyzer.$$$reportNull$$$0(14);
        }
        LOG.debug("listener added " + String.valueOf(listener));
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void reset() {
        LOG.debug("analyzer started");
        this.myAnalyzerQueue.start();
        this.myResultsUpdateQueue.start();
        this.myAnalyzerQueue.queue((Runnable)new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.myStopped.set(false);
            }
        });
    }

    public void clear() {
        this.myWarningsAboutUnused.clear();
        this.myElementsToShowWarningIfUnused.clear();
        this.mySourceElement2Usages.clear();
        this.myContainingElement2Usages.clear();
        this.myElementWithNotCalculatedUsages.clear();
        this.myProjectConfigurationProblems.clearProblems();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "doUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheck";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectUsages";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsagesInElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUsages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdates";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getProblemsHolder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getUsages";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ProblemsComputedUpdate
    implements Runnable {
        @NotNull
        private final ProjectStructureElement myElement;
        @NotNull
        private final ProjectStructureProblemsHolderImpl myProblemsHolder;

        ProblemsComputedUpdate(@NotNull ProjectStructureElement element, ProjectStructureProblemsHolderImpl problemsHolder) {
            if (element == null) {
                ProblemsComputedUpdate.$$$reportNull$$$0(0);
            }
            if (problemsHolder == null) {
                ProblemsComputedUpdate.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myProblemsHolder = problemsHolder;
        }

        @Override
        public void run() {
            ProjectStructureProblemDescription warning;
            if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating problems for " + String.valueOf(this.myElement));
            }
            if ((warning = ProjectStructureDaemonAnalyzer.this.myWarningsAboutUnused.get(this.myElement)) != null) {
                this.myProblemsHolder.registerProblem(warning);
            }
            ProjectStructureDaemonAnalyzer.this.myProblemHolders.put(this.myElement, this.myProblemsHolder);
            ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.myDispatcher.getMulticaster()).problemsChanged(this.myElement);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProblemsComputedUpdate)) {
                return false;
            }
            ProblemsComputedUpdate update = (ProblemsComputedUpdate)o;
            return this.myElement.equals(update.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode() + 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "problemsHolder";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class UsagesCollectedUpdate
    implements Runnable {
        @NotNull
        private final ProjectStructureElement myElement;
        @NotNull
        private final List<? extends ProjectStructureElementUsage> myUsages;

        UsagesCollectedUpdate(@NotNull ProjectStructureElement element, List<? extends ProjectStructureElementUsage> usages) {
            if (element == null) {
                UsagesCollectedUpdate.$$$reportNull$$$0(0);
            }
            if (usages == null) {
                UsagesCollectedUpdate.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myUsages = usages;
        }

        @Override
        public void run() {
            if (ProjectStructureDaemonAnalyzer.this.myStopped.get()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updating usages for " + String.valueOf(this.myElement));
            }
            ProjectStructureDaemonAnalyzer.this.updateUsages(this.myElement, this.myUsages);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsagesCollectedUpdate)) {
                return false;
            }
            UsagesCollectedUpdate other = (UsagesCollectedUpdate)o;
            return this.myElement.equals(other.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode() + 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "usages";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ReportUnusedElementsUpdate
    implements Runnable {
        private ReportUnusedElementsUpdate() {
        }

        @Override
        public void run() {
            ProjectStructureDaemonAnalyzer.this.reportUnusedElements();
        }

        public int hashCode() {
            return 3;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReportUnusedElementsUpdate;
        }
    }

    private final class AnalyzeElementUpdate
    implements Runnable {
        @NotNull
        private final ProjectStructureElement myElement;

        AnalyzeElementUpdate(ProjectStructureElement element) {
            if (element == null) {
                AnalyzeElementUpdate.$$$reportNull$$$0(0);
            }
            this.myElement = element;
        }

        @Override
        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.doUpdate(this.myElement);
            }
            catch (Throwable t) {
                LOG.error(t);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate update = (AnalyzeElementUpdate)o;
            return this.myElement.equals(update.myElement);
        }

        public int hashCode() {
            return this.myElement.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "<init>"));
        }
    }
}

