/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.TooltipTitle;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.CoroutineSupport;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupCornerType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.Strings;
import com.intellij.reference.SoftReference;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBFontScaler;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.SingleEdtTaskScheduler;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.ScreenReader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HelpTooltip {
    private static final Color INFO_COLOR = JBColor.namedColor((String)"ToolTip.infoForeground", (Color)JBUI.CurrentTheme.ContextHelp.FOREGROUND);
    private static final Color LINK_COLOR = JBColor.namedColor((String)"ToolTip.linkForeground", (Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("HelpTooltip.maxWidth", 250);
    private static final JBValue X_OFFSET = new JBValue.UIInteger("HelpTooltip.xOffset", 0);
    private static final JBValue Y_OFFSET = new JBValue.UIInteger("HelpTooltip.yOffset", 0);
    private static final JBValue HEADER_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.fontSizeDelta", 0);
    private static final JBValue DESCRIPTION_FONT_SIZE_DELTA = new JBValue.UIInteger("HelpTooltip.descriptionSizeDelta", 0);
    private static final JBValue CURSOR_OFFSET = new JBValue.UIInteger("HelpTooltip.mouseCursorOffset", 20);
    private static final String PARAGRAPH_SPLITTER = "<p/?>";
    private static final String TOOLTIP_PROPERTY = "JComponent.helpTooltip";
    private static final String TOOLTIP_DISABLED_PROPERTY = "JComponent.helpTooltipDisabled";
    private @Nullable Supplier<@NotNull @TooltipTitle String> title;
    @NlsSafe
    private String shortcut;
    private @NlsContexts.Tooltip String description;
    @Nullable
    private ActionLink link;
    @Nullable
    private JBFontScaler linkOriginalFontScaler;
    private boolean neverHide;
    @NotNull
    private Alignment alignment = Alignment.CURSOR;
    private BooleanSupplier masterPopupOpenCondition;
    private JBPopup myPopup;
    private final SingleEdtTaskScheduler popupAlarm = SingleEdtTaskScheduler.createSingleEdtTaskScheduler((CoroutineSupport.UiDispatcherKind)CoroutineSupport.UiDispatcherKind.RELAX);
    private boolean isOverPopup;
    private boolean isMultiline;
    private int myInitialDelay = -1;
    private int myHideDelay = -1;
    private String myToolTipText;
    private boolean initialShowScheduled;
    protected MouseAdapter myMouseListener;

    public HelpTooltip setTitle(@Nullable @TooltipTitle String title) {
        this.title = title != null ? () -> title : null;
        return this;
    }

    public HelpTooltip setTitle(@Nullable Supplier<@NotNull @TooltipTitle String> title) {
        this.title = title;
        return this;
    }

    public HelpTooltip setShortcut(@Nullable @NlsSafe String shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public HelpTooltip setShortcut(@Nullable Shortcut shortcut) {
        this.shortcut = shortcut == null ? null : KeymapUtil.getShortcutText(shortcut);
        return this;
    }

    public HelpTooltip setInitialDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Negative delay is not allowed");
        }
        this.myInitialDelay = delay;
        return this;
    }

    public HelpTooltip setHideDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("Negative delay is not allowed");
        }
        this.myHideDelay = delay;
        return this;
    }

    public HelpTooltip setDescription(@NlsContexts.Tooltip @Nullable String description) {
        this.description = description;
        return this;
    }

    public HelpTooltip setLink(@NlsContexts.LinkLabel String linkText, Runnable linkAction) {
        return this.setLink(linkText, linkAction, false);
    }

    public HelpTooltip setLink(@NlsContexts.LinkLabel String linkText, @NotNull Runnable linkAction, boolean external) {
        if (linkAction == null) {
            HelpTooltip.$$$reportNull$$$0(0);
        }
        this.link = new MyActionLink(linkText, linkAction, external){

            @Override
            protected void hidePopup() {
                HelpTooltip.this.hidePopup(true);
            }
        };
        this.linkOriginalFontScaler = new JBFontScaler(this.link.getFont());
        return this;
    }

    public HelpTooltip setBrowserLink(@NlsContexts.LinkLabel String linkLabel, @NotNull URL url) {
        if (url == null) {
            HelpTooltip.$$$reportNull$$$0(1);
        }
        this.link = new BrowserLink(linkLabel, url.toExternalForm());
        this.link.setHorizontalTextPosition(2);
        this.linkOriginalFontScaler = new JBFontScaler(this.link.getFont());
        return this;
    }

    @ApiStatus.Internal
    public @Nullable Supplier<@NotNull String> getTitle() {
        return this.title;
    }

    @ApiStatus.Internal
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @ApiStatus.Internal
    @Nullable
    public ActionLink getLink() {
        return this.link;
    }

    @ApiStatus.Internal
    public int getHideDelay() {
        return this.myHideDelay;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        HelpTooltip tooltip = (HelpTooltip)that;
        return this.neverHide == tooltip.neverHide && (this.title == null ? tooltip.title == null : tooltip.title != null && Objects.equals(this.title.get(), tooltip.title.get())) && Objects.equals(this.shortcut, tooltip.shortcut) && Objects.equals(this.description, tooltip.description) && HelpTooltip.linksEqual(this.link, tooltip.link) && this.alignment == tooltip.alignment && Objects.equals(this.masterPopupOpenCondition, tooltip.masterPopupOpenCondition);
    }

    public HelpTooltip setNeverHideOnTimeout(boolean neverHide) {
        this.neverHide = neverHide;
        return this;
    }

    public HelpTooltip setLocation(@NotNull Alignment alignment) {
        if (alignment == null) {
            HelpTooltip.$$$reportNull$$$0(2);
        }
        this.alignment = alignment;
        return this;
    }

    public void installOn(@NotNull JComponent component) {
        HelpTooltip installed;
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(3);
        }
        if ((installed = (HelpTooltip)component.getClientProperty(TOOLTIP_PROPERTY)) == null) {
            this.installImpl(component);
        } else if (!this.equals(installed)) {
            installed.hideAndDispose(component);
            this.installImpl(component);
        }
    }

    private void installImpl(@NotNull JComponent component) {
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(4);
        }
        this.neverHide = this.neverHide || UIUtil.isHelpButton((Component)component);
        this.createMouseListeners();
        component.putClientProperty(TOOLTIP_PROPERTY, this);
        this.installMouseListeners(component);
    }

    protected boolean shouldForceHiding() {
        return this.link == null;
    }

    protected final void createMouseListeners() {
        this.myMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (HelpTooltip.this.myPopup != null && !HelpTooltip.this.myPopup.isDisposed()) {
                    HelpTooltip.this.myPopup.cancel();
                }
                HelpTooltip.this.initialShowScheduled = true;
                int delay = HelpTooltip.this.myInitialDelay;
                if (delay == -1) {
                    delay = Registry.intValue((String)"ide.tooltip.initialReshowDelay", (int)500);
                }
                HelpTooltip.this.scheduleShow(e, delay);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                int delay = HelpTooltip.this.myHideDelay;
                if (delay == -1) {
                    delay = Registry.intValue((String)"ide.tooltip.initialDelay.highlighter", (int)150);
                }
                HelpTooltip.this.scheduleHide(HelpTooltip.this.shouldForceHiding(), delay);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!HelpTooltip.this.initialShowScheduled) {
                    HelpTooltip.this.scheduleShow(e, Registry.intValue((String)"ide.tooltip.reshowDelay"));
                }
            }
        };
    }

    @ApiStatus.Internal
    public static ComponentPopupBuilder initPopupBuilder(@NotNull JComponent tipPanel) {
        if (tipPanel == null) {
            HelpTooltip.$$$reportNull$$$0(5);
        }
        return JBPopupFactory.getInstance().createComponentPopupBuilder(tipPanel, null).setShowBorder(UIManager.getBoolean("ToolTip.paintBorder")).setBorderColor(JBUI.CurrentTheme.Tooltip.borderColor()).setShowShadow(true).addUserData((Object)PopupCornerType.RoundedTooltip);
    }

    @NotNull
    protected MouseListener createIsOverTipMouseListener() {
        return new OverTipMouseListener();
    }

    @ApiStatus.Internal
    @NotNull
    public JPanel createTipPanel() {
        JPanel tipPanel = new JPanel();
        tipPanel.setLayout(new VerticalLayout(JBUI.getInt((String)"HelpTooltip.verticalGap", (int)4)));
        tipPanel.setBackground(UIUtil.getToolTipBackground());
        String currentTitle = this.title != null ? this.title.get() : null;
        boolean hasTitle = Strings.isNotEmpty((String)currentTitle);
        boolean hasDescription = Strings.isNotEmpty((String)this.description);
        if (hasTitle) {
            tipPanel.add((Component)new Header(hasDescription), "TOP");
        }
        if (hasDescription) {
            @Nls String[] pa = this.description.split(PARAGRAPH_SPLITTER);
            this.isMultiline = pa.length > 1;
            for (String p : pa) {
                if (p.isEmpty()) continue;
                tipPanel.add((Component)new Paragraph(p, hasTitle), "TOP");
            }
        }
        if (!hasTitle && Strings.isNotEmpty((String)this.shortcut)) {
            JLabel shortcutLabel = new JLabel(this.shortcut);
            shortcutLabel.setFont(HelpTooltip.deriveDescriptionFont(shortcutLabel.getFont(), false));
            shortcutLabel.setForeground(JBUI.CurrentTheme.Tooltip.shortcutForeground());
            tipPanel.add((Component)shortcutLabel, "TOP");
        }
        if (this.link != null && this.linkOriginalFontScaler != null) {
            this.link.setForeground(LINK_COLOR);
            this.link.setFont(HelpTooltip.deriveDescriptionFont(this.linkOriginalFontScaler.scaledFont(), hasTitle));
            tipPanel.add((Component)this.link, "TOP");
        }
        this.isMultiline = this.isMultiline || Strings.isNotEmpty((String)this.description) && (Strings.isNotEmpty((String)currentTitle) || this.link != null);
        tipPanel.setBorder(HelpTooltip.textBorder(this.isMultiline));
        JPanel jPanel = tipPanel;
        if (jPanel == null) {
            HelpTooltip.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private void installMouseListeners(@NotNull JComponent owner2) {
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(7);
        }
        owner2.addMouseListener(this.myMouseListener);
        owner2.addMouseMotionListener(this.myMouseListener);
    }

    private void uninstallMouseListeners(@NotNull JComponent owner2) {
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(8);
        }
        owner2.removeMouseListener(this.myMouseListener);
        owner2.removeMouseMotionListener(this.myMouseListener);
    }

    @Nullable
    public static HelpTooltip getTooltipFor(@NotNull JComponent owner2) {
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(9);
        }
        return (HelpTooltip)owner2.getClientProperty(TOOLTIP_PROPERTY);
    }

    public static void dispose(@NotNull Component owner2) {
        JComponent component;
        HelpTooltip instance2;
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(10);
        }
        if (owner2 instanceof JComponent && (instance2 = (HelpTooltip)(component = (JComponent)owner2).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.hideAndDispose(component);
        }
    }

    private void hideAndDispose(@NotNull JComponent owner2) {
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(11);
        }
        this.hidePopup(true);
        this.uninstallMouseListeners(owner2);
        this.masterPopupOpenCondition = null;
        owner2.putClientProperty(TOOLTIP_PROPERTY, null);
    }

    public static void hide(@NotNull Component owner2) {
        HelpTooltip instance2;
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(12);
        }
        if (owner2 instanceof JComponent && (instance2 = (HelpTooltip)((JComponent)owner2).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.hidePopup(true);
        }
    }

    public static void setMasterPopup(@NotNull Component owner2, @Nullable JBPopup master) {
        HelpTooltip tooltip;
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(13);
        }
        if (owner2 instanceof JComponent && (tooltip = (HelpTooltip)((JComponent)owner2).getClientProperty(TOOLTIP_PROPERTY)) != null && tooltip.myPopup != master) {
            WeakReference<JBPopup> popupRef = new WeakReference<JBPopup>(master);
            tooltip.masterPopupOpenCondition = () -> {
                JBPopup popup2 = (JBPopup)SoftReference.dereference((Reference)popupRef);
                return popup2 == null || !popup2.isVisible();
            };
        }
    }

    public static void setMasterPopupOpenCondition(@NotNull Component owner2, @Nullable BooleanSupplier condition) {
        HelpTooltip instance2;
        if (owner2 == null) {
            HelpTooltip.$$$reportNull$$$0(14);
        }
        if (owner2 instanceof JComponent && (instance2 = (HelpTooltip)((JComponent)owner2).getClientProperty(TOOLTIP_PROPERTY)) != null) {
            instance2.masterPopupOpenCondition = condition;
        }
    }

    public static void disableTooltip(Component source) {
        if (source instanceof JComponent) {
            JComponent component = (JComponent)source;
            component.putClientProperty(TOOLTIP_DISABLED_PROPERTY, Boolean.TRUE);
        }
    }

    public static void enableTooltip(Component source) {
        if (source instanceof JComponent) {
            JComponent component = (JComponent)source;
            component.putClientProperty(TOOLTIP_DISABLED_PROPERTY, null);
        }
    }

    private static boolean isTooltipDisabled(Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            Boolean disabled = (Boolean)jComponent.getClientProperty(TOOLTIP_DISABLED_PROPERTY);
            return disabled == Boolean.TRUE;
        }
        return false;
    }

    private void scheduleShow(MouseEvent e, int delay) {
        this.popupAlarm.cancel();
        if (HelpTooltip.isTooltipDisabled(e.getComponent())) {
            return;
        }
        if (ScreenReader.isActive()) {
            return;
        }
        this.popupAlarm.request((long)delay, () -> {
            String text;
            this.initialShowScheduled = false;
            if (this.masterPopupOpenCondition != null && !this.masterPopupOpenCondition.getAsBoolean()) {
                return;
            }
            Component owner2 = e.getComponent();
            String string = text = owner2 instanceof JComponent ? ((JComponent)owner2).getToolTipText(e) : null;
            if (this.myPopup != null && !this.myPopup.isDisposed()) {
                if (Strings.isEmpty((String)text) && Strings.isEmpty((String)this.myToolTipText)) {
                    return;
                }
                if (Objects.equals(text, this.myToolTipText)) {
                    return;
                }
                this.myPopup.cancel();
            }
            this.myToolTipText = text;
            JPanel tipPanel = this.createTipPanel();
            tipPanel.addMouseListener(this.createIsOverTipMouseListener());
            ComponentPopupBuilder popupBuilder = HelpTooltip.initPopupBuilder(tipPanel);
            this.myPopup = popupBuilder.createPopup();
            this.myPopup.show(new RelativePoint(owner2, this.alignment.getPointFor(owner2, tipPanel.getPreferredSize(), e.getPoint())));
            if (!this.neverHide) {
                int dismissDelay = Registry.intValue((String)(this.isMultiline ? "ide.helptooltip.full.dismissDelay" : "ide.helptooltip.regular.dismissDelay"));
                this.scheduleHide(true, dismissDelay);
            }
        });
    }

    private void scheduleHide(boolean force, int delay) {
        this.popupAlarm.cancelAndRequest((long)delay, () -> this.hidePopup(force));
    }

    protected void hidePopup(boolean force) {
        this.initialShowScheduled = false;
        this.popupAlarm.cancel();
        if (this.myPopup != null && (!this.isOverPopup || force)) {
            if (this.myPopup.isVisible()) {
                this.myPopup.cancel();
            }
            this.myPopup = null;
            this.myToolTipText = null;
        }
    }

    private static Border textBorder(boolean multiline) {
        Insets i = multiline ? JBUI.CurrentTheme.HelpTooltip.defaultTextBorderInsets() : JBUI.CurrentTheme.HelpTooltip.smallTextBorderInsets();
        return new JBEmptyBorder(i);
    }

    private static Font deriveHeaderFont(Font font) {
        return font.deriveFont((float)font.getSize() + (float)HEADER_FONT_SIZE_DELTA.get());
    }

    private static Font deriveDescriptionFont(Font font, boolean hasTitle) {
        return hasTitle ? font.deriveFont((float)font.getSize() + (float)DESCRIPTION_FONT_SIZE_DELTA.get()) : HelpTooltip.deriveHeaderFont(font);
    }

    @Contract(pure=true)
    @NotNull
    public static String getShortcutAsHtml(@Nullable String shortcut) {
        String string = Strings.isEmpty((String)shortcut) ? "" : String.format("&nbsp;&nbsp;<font color=\"%s\">%s</font>", ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Tooltip.shortcutForeground()), shortcut);
        if (string == null) {
            HelpTooltip.$$$reportNull$$$0(15);
        }
        return string;
    }

    static boolean linksEqual(@Nullable ActionLink o1, @Nullable ActionLink o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        if (o1.getClass() != o2.getClass()) {
            return false;
        }
        if (!Objects.equals(o1.getText(), o2.getText())) {
            return false;
        }
        if (o1 instanceof MyActionLink) {
            MyActionLink a1 = (MyActionLink)o1;
            if (o2 instanceof MyActionLink) {
                MyActionLink a2 = (MyActionLink)o2;
                return a1.external == a2.external && a1.linkAction.getClass() == a2.linkAction.getClass();
            }
        }
        if (o1 instanceof BrowserLink) {
            BrowserLink b1 = (BrowserLink)o1;
            if (o2 instanceof BrowserLink) {
                BrowserLink b2 = (BrowserLink)o2;
                return b1.getUrl().equals(b2.getUrl());
            }
        }
        return o1 == o2;
    }

    @ApiStatus.Internal
    public boolean fromSameWindowAs(@NotNull Component component) {
        if (component == null) {
            HelpTooltip.$$$reportNull$$$0(16);
        }
        if (this.myPopup != null && !this.myPopup.isDisposed()) {
            Window popupWindow = SwingUtilities.getWindowAncestor(this.myPopup.getContent());
            return component == popupWindow || SwingUtilities.getWindowAncestor(component) == popupWindow;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alignment";
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tipPanel";
                break;
            }
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/HelpTooltip";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTipPanel";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcutAsHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setLink";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setBrowserLink";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setLocation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installOn";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "installImpl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "initPopupBuilder";
                break;
            }
            case 6: 
            case 15: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "installMouseListeners";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "uninstallMouseListeners";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTooltipFor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "dispose";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hideAndDispose";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hide";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopup";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setMasterPopupOpenCondition";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fromSameWindowAs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 15 -> new IllegalStateException(string);
        };
    }

    public static enum Alignment {
        RIGHT{

            @Override
            public Point getPointFor(Component owner2, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner2.getSize();
                return new Point(size.width + JBUIScale.scale((int)5) - X_OFFSET.get(), JBUIScale.scale((int)1) + Y_OFFSET.get());
            }
        }
        ,
        LEFT{

            @Override
            public Point getPointFor(Component owner2, Dimension popupSize, Point mouseLocation) {
                return new Point(-popupSize.width - JBUIScale.scale((int)5) + X_OFFSET.get(), JBUIScale.scale((int)1) + Y_OFFSET.get());
            }
        }
        ,
        BOTTOM{

            @Override
            public Point getPointFor(Component owner2, Dimension popupSize, Point mouseLocation) {
                Dimension size = owner2.getSize();
                return new Point(JBUIScale.scale((int)1) + X_OFFSET.get(), JBUIScale.scale((int)5) + size.height - Y_OFFSET.get());
            }
        }
        ,
        HELP_BUTTON{

            @Override
            public Point getPointFor(Component owner2, Dimension popupSize, Point mouseLocation) {
                Insets i = ((JComponent)owner2).getInsets();
                return new Point(X_OFFSET.get() - JBUIScale.scale((int)40), i.top + Y_OFFSET.get() - JBUIScale.scale((int)6) - popupSize.height);
            }
        }
        ,
        CURSOR{

            @Override
            public Point getPointFor(Component owner2, Dimension popupSize, Point mouseLocation) {
                Point location = mouseLocation.getLocation();
                location.y += CURSOR_OFFSET.get();
                SwingUtilities.convertPointToScreen(location, owner2);
                Rectangle r = new Rectangle(location, popupSize);
                ScreenUtil.fitToScreen((Rectangle)r);
                location = r.getLocation();
                SwingUtilities.convertPointFromScreen(location, owner2);
                r.setLocation(location);
                if (r.contains(mouseLocation)) {
                    location.y = mouseLocation.y - r.height - JBUI.scale((int)5);
                }
                return location;
            }
        };


        public abstract Point getPointFor(Component var1, Dimension var2, Point var3);
    }

    protected class OverTipMouseListener
    extends MouseAdapter {
        protected OverTipMouseListener() {
        }

        protected void doEnter() {
            HelpTooltip.this.isOverPopup = true;
        }

        protected void doExit() {
            HelpTooltip.this.isOverPopup = false;
            HelpTooltip.this.hidePopup(false);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.doEnter();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (HelpTooltip.this.link == null || !HelpTooltip.this.link.getBounds().contains(e.getPoint())) {
                this.doExit();
            }
        }
    }

    private final class Header
    extends BoundWidthLabel {
        private Header(boolean obeyWidth) {
            this.setFont(HelpTooltip.deriveHeaderFont(this.getFont()));
            this.setForeground(UIUtil.getToolTipForeground());
            String currentTitle = Objects.requireNonNullElse(HelpTooltip.this.title != null ? HelpTooltip.this.title.get() : null, "");
            if (obeyWidth || currentTitle.length() > MAX_WIDTH.get()) {
                View v = BasicHTML.createHTMLView(this, String.format("<html>%s%s</html>", currentTitle, this.getShortcutAsHTML()));
                float width = v.getPreferredSpan(0);
                HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
                HtmlChunk.Element div = width > (float)MAX_WIDTH.get() ? HtmlChunk.div().attr("width", MAX_WIDTH.get()) : HtmlChunk.div();
                this.setText(div.children(new HtmlChunk[]{HtmlChunk.raw((String)currentTitle), HtmlChunk.raw((String)this.getShortcutAsHTML())}).wrapWith(HtmlChunk.html()).toString());
                this.setSizeForWidth(width);
            } else {
                this.setText(BasicHTML.isHTMLString(currentTitle) ? currentTitle : HtmlChunk.div().addRaw(currentTitle).addRaw(this.getShortcutAsHTML()).wrapWith(HtmlChunk.html()).toString());
            }
        }

        @NlsSafe
        private String getShortcutAsHTML() {
            return HelpTooltip.getShortcutAsHtml(HelpTooltip.this.shortcut);
        }
    }

    private final class Paragraph
    extends BoundWidthLabel {
        private Paragraph(String text, boolean hasTitle) {
            this.setForeground(hasTitle ? INFO_COLOR : UIUtil.getToolTipForeground());
            this.setFont(HelpTooltip.deriveDescriptionFont(this.getFont(), hasTitle));
            View v = BasicHTML.createHTMLView(this, HtmlChunk.raw((String)text).wrapWith(HtmlChunk.html()).toString());
            float width = v.getPreferredSpan(0);
            HelpTooltip.this.isMultiline = HelpTooltip.this.isMultiline || width > (float)MAX_WIDTH.get();
            HtmlChunk.Element div = width > (float)MAX_WIDTH.get() ? HtmlChunk.div().attr("width", MAX_WIDTH.get()) : HtmlChunk.div();
            this.setText(div.addRaw(text).wrapWith(HtmlChunk.html()).toString());
            this.setSizeForWidth(width);
        }
    }

    private static abstract class MyActionLink
    extends ActionLink {
        final Runnable linkAction;
        final boolean external;

        MyActionLink(@NlsContexts.LinkLabel @NotNull String text, @NotNull Runnable linkAction, boolean external) {
            if (text == null) {
                MyActionLink.$$$reportNull$$$0(0);
            }
            if (linkAction == null) {
                MyActionLink.$$$reportNull$$$0(1);
            }
            this.linkAction = linkAction;
            this.external = external;
            this.setText(text);
            this.addActionListener(e -> {
                this.hidePopup();
                linkAction.run();
            });
            if (external) {
                this.setExternalLinkIcon();
            }
        }

        protected abstract void hidePopup();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkAction";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ide/HelpTooltip$MyActionLink";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BoundWidthLabel
    extends JLabel {
        private BoundWidthLabel() {
        }

        private static Collection<View> getRows(@NotNull View root) {
            if (root == null) {
                BoundWidthLabel.$$$reportNull$$$0(0);
            }
            ArrayList<View> rows = new ArrayList<View>();
            BoundWidthLabel.visit(root, rows);
            return rows;
        }

        private static void visit(@NotNull View v, Collection<? super View> result2) {
            String cname;
            if (v == null) {
                BoundWidthLabel.$$$reportNull$$$0(1);
            }
            if ((cname = v.getClass().getCanonicalName()) != null && cname.contains("ParagraphView.Row")) {
                result2.add(v);
            }
            for (int i = 0; i < v.getViewCount(); ++i) {
                BoundWidthLabel.visit(v.getView(i), result2);
            }
        }

        void setSizeForWidth(float width) {
            View v;
            if (width > (float)MAX_WIDTH.get() && (v = (View)this.getClientProperty("html")) != null) {
                width = 0.0f;
                for (View row : BoundWidthLabel.getRows(v)) {
                    float rWidth = row.getPreferredSpan(0);
                    if (!(width < rWidth)) continue;
                    width = rWidth;
                }
                v.setSize(width, v.getPreferredSpan(1));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "v";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/ide/HelpTooltip$BoundWidthLabel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getRows";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

