/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.wayland.WaylandUtilKt;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.DefaultMenuLayout;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBPopupMenu
extends JPopupMenu {
    private static final Logger LOG = Logger.getInstance(JBPopupMenu.class);
    private final MyLayout myLayout;

    public JBPopupMenu() {
        this(null);
    }

    public JBPopupMenu(String label2) {
        super(label2);
        this.enableEvents(131088L);
        this.myLayout = new MyLayout(this);
        this.setLayout(this.myLayout);
        this.setLightWeightPopupEnabled(false);
        this.setOpaque(false);
    }

    @Override
    public void show(Component invoker, int x, int y) {
        if (LOG.isDebugEnabled()) {
            this.logMenuPosition(invoker, x, y);
        }
        super.show(invoker, x, y);
    }

    private void logMenuPosition(@Nullable Component invoker, int x, int y) {
        if (GraphicsEnvironment.isHeadless()) {
            return;
        }
        LOG.debug("Showing popup menu at x=" + x + ", y=" + y + ", preferredSize=" + String.valueOf(this.getPreferredSize()) + ", invokerOrigin=" + String.valueOf(invoker == null ? "null" : invoker.getLocationOnScreen()));
        LOG.debug("Available raster screens are");
        GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Toolkit tk = Toolkit.getDefaultToolkit();
        for (GraphicsDevice device : lge.getScreenDevices()) {
            if (device.getType() != 0) continue;
            GraphicsConfiguration dgc = device.getDefaultConfiguration();
            LOG.debug("bounds=" + dgc.getBounds().toString() + ", insets=" + String.valueOf(tk.getScreenInsets(dgc)));
        }
        if (invoker != null) {
            GraphicsConfiguration igc = invoker.getGraphicsConfiguration();
            LOG.debug("Invoker's screen: bounds=" + igc.getBounds().toString() + ", insets=" + String.valueOf(tk.getScreenInsets(igc)));
        }
        GraphicsConfiguration defGc = lge.getDefaultScreenDevice().getDefaultConfiguration();
        LOG.debug("Default graphics configuration: bounds=" + defGc.getBounds().toString() + ", insets=" + String.valueOf(tk.getScreenInsets(defGc)));
        if (LOG.isTraceEnabled()) {
            LOG.trace(new Throwable("The menu was invoked from here"));
        }
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
        if (!this.isShowing()) {
            return;
        }
        int rotation = e.getWheelRotation();
        if (rotation == 0) {
            return;
        }
        if (e.getComponent() != this) {
            e = (MouseWheelEvent)SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        }
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, this);
        Point tPoint = this.getLocationOnScreen();
        if (p.x >= tPoint.x && p.x <= tPoint.x + this.getWidth() && p.y >= tPoint.y && p.y <= tPoint.y + this.getHeight()) {
            this.myLayout.updateShift(rotation * 10);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof MyLayout)) {
            return;
        }
        super.setLayout(mgr);
    }

    @Override
    public void paint(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paint(g);
        LayoutManager layout = this.getLayout();
        if (layout instanceof MyLayout) {
            ((MyLayout)layout).paintIfNeeded(g);
        }
    }

    public static void showAbove(@NotNull Component component, @NotNull JPopupMenu menu) {
        if (component == null) {
            JBPopupMenu.$$$reportNull$$$0(0);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(1);
        }
        menu.show(component, 0, 0);
        UiNotifyConnector.doWhenFirstShown((JComponent)menu, () -> {
            Window window = ComponentUtil.getWindow((Component)menu);
            if (window == null) {
                LOG.error("Cannot find window for menu popup " + String.valueOf(menu) + ", " + menu.isShowing());
            } else {
                Point diff = SwingUtilities.convertPoint(component, 0, 0, window);
                window.setLocation(window.getX(), window.getY() + diff.y - window.getHeight());
            }
        });
    }

    public static void showAtRight(@NotNull Component component, @NotNull JPopupMenu menu) {
        if (component == null) {
            JBPopupMenu.$$$reportNull$$$0(2);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(3);
        }
        menu.show(component, component.getWidth(), 0);
    }

    public static void showBelow(@NotNull Component component, @NotNull JPopupMenu menu) {
        if (component == null) {
            JBPopupMenu.$$$reportNull$$$0(4);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(5);
        }
        menu.show(component, 0, component.getHeight());
    }

    public static void showBelow(@NotNull Component component, @NonNls @NotNull String place, @NotNull ActionGroup group) {
        if (component == null) {
            JBPopupMenu.$$$reportNull$$$0(6);
        }
        if (place == null) {
            JBPopupMenu.$$$reportNull$$$0(7);
        }
        if (group == null) {
            JBPopupMenu.$$$reportNull$$$0(8);
        }
        JBPopupMenu.showBelow(component, ActionManager.getInstance().createActionPopupMenu(place, group).getComponent());
    }

    public static void showByEvent(@NotNull MouseEvent event, @NotNull JPopupMenu menu) {
        if (event == null) {
            JBPopupMenu.$$$reportNull$$$0(9);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(10);
        }
        menu.show(event.getComponent(), event.getX(), event.getY());
    }

    public static void showByEditor(@NotNull Editor editor, @NotNull JPopupMenu menu) {
        if (editor == null) {
            JBPopupMenu.$$$reportNull$$$0(11);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(12);
        }
        JComponent invoker = editor.getContentComponent();
        Point caretPoint = editor.visualPositionToXY(editor.getCaretModel().getVisualPosition());
        menu.show(invoker, caretPoint.x, caretPoint.y);
    }

    public static void showByEvent(@NotNull MouseEvent event, @NonNls @NotNull String place, @NotNull ActionGroup group) {
        if (event == null) {
            JBPopupMenu.$$$reportNull$$$0(13);
        }
        if (place == null) {
            JBPopupMenu.$$$reportNull$$$0(14);
        }
        if (group == null) {
            JBPopupMenu.$$$reportNull$$$0(15);
        }
        JBPopupMenu.showByEvent(event, ActionManager.getInstance().createActionPopupMenu(place, group).getComponent());
    }

    public static void showAt(@NotNull RelativePoint point, @NotNull JPopupMenu menu) {
        if (point == null) {
            JBPopupMenu.$$$reportNull$$$0(16);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(17);
        }
        menu.show(point.getComponent(), point.getPoint().x, point.getPoint().y);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 10: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "menu";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/JBPopupMenu";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "showAbove";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showAtRight";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showBelow";
                break;
            }
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "showByEvent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "showByEditor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "showAt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLayout
    extends DefaultMenuLayout
    implements ActionListener {
        private final JPopupMenu myTarget;
        private Point mouseLocation = null;
        int myShift = 0;
        int myScrollDirection = 0;
        Timer myTimer;
        private final AWTEventListener toolkitListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof MouseEvent) {
                    MouseEvent mouseEvent = (MouseEvent)event;
                    mouseLocation = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), myTarget);
                }
            }
        };
        private final Color[] dim = new Color[]{JBColor.background(), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.9), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.8), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.7), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.6), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.5), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.4), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.3), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.2), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.1)};

        MyLayout(final JPopupMenu target) {
            super(target, 3);
            this.myTarget = target;
            this.myTimer = TimerUtil.createNamedTimer((String)"PopupTimer", (int)40, (ActionListener)this);
            this.myTarget.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.switchTimer(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    this.switchTimer(false);
                    JRootPane rootPane = SwingUtilities.getRootPane(target);
                    if (rootPane != null) {
                        rootPane.putClientProperty("apple.awt._windowFadeDelegate", null);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.switchTimer(false);
                }
            });
            if (this.myTarget.isVisible()) {
                this.switchTimer(true);
            }
        }

        private void switchTimer(boolean on) {
            if (on && !this.myTimer.isRunning()) {
                this.myTimer.start();
                Toolkit.getDefaultToolkit().addAWTEventListener(this.toolkitListener, 32L);
            }
            if (!on && this.myTimer.isRunning()) {
                this.myTimer.stop();
                Toolkit.getDefaultToolkit().removeAWTEventListener(this.toolkitListener);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.myTarget.isShowing()) {
                return;
            }
            if (this.mouseLocation == null) {
                return;
            }
            if (this.mouseLocation.x < 0 || this.mouseLocation.x > this.myTarget.getWidth()) {
                return;
            }
            if (Math.abs(this.mouseLocation.y - this.getMaxHeight()) < 10) {
                this.myScrollDirection = 1;
            } else if (Math.abs(this.mouseLocation.y) < 10) {
                this.myScrollDirection = -1;
            } else {
                return;
            }
            this.myTarget.dispatchEvent(new MouseEvent(this.myTarget, 504, System.currentTimeMillis(), 0, this.mouseLocation.x, this.mouseLocation.y, 0, false));
            this.updateShift(5 * this.myScrollDirection);
        }

        private void updateShift(int increment) {
            int maxHeight = super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight();
            int newShift = Math.max(0, Math.min(maxHeight, this.myShift + increment));
            if (newShift != this.myShift) {
                this.myShift = newShift;
                this.myTarget.revalidate();
                this.myTarget.repaint();
                Window w = ComponentUtil.getWindow((Component)this.myTarget.getComponent());
                if (w != null) {
                    for (Window window : w.getOwnedWindows()) {
                        window.dispose();
                    }
                }
            }
        }

        public void paintIfNeeded(Graphics g) {
            int i;
            if (this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, i, this.myTarget.getWidth(), i);
                }
                AllIcons.General.ArrowUp.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.ArrowUp.getIconWidth() / 2, 0);
            }
            if (super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight() - this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, this.myTarget.getHeight() - i, this.myTarget.getWidth(), this.myTarget.getHeight() - i);
                }
                AllIcons.General.ArrowDown.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.ArrowDown.getIconWidth() / 2, this.myTarget.getHeight() - AllIcons.General.ArrowDown.getIconHeight());
            }
        }

        @Override
        public void layoutContainer(Container target) {
            Insets insets = target.getInsets();
            int width = target.getWidth() - insets.left - insets.right;
            Component[] components = target.getComponents();
            int y = -this.myShift + insets.top;
            for (Component component : components) {
                if (!component.isVisible()) {
                    String place = target instanceof PlaceProvider ? ((PlaceProvider)target).getPlace() : null;
                    Object itemText = component instanceof AbstractButton ? "\"" + ((AbstractButton)component).getText() + "\"" : component.getClass().getName();
                    LOG.error("Invisible menu item " + (String)itemText + (String)(place != null ? " in '" + place + "'" : "") + " (" + component.getClass().getName() + " in " + target.getClass().getName() + ")");
                    continue;
                }
                int height = component.getPreferredSize().height;
                component.setBounds(insets.left, y, width, height);
                y += height;
            }
        }

        private int getMaxHeight() {
            GraphicsConfiguration configuration = this.myTarget.getGraphicsConfiguration();
            Component invoker = this.myTarget.getInvoker();
            if (configuration == null && invoker != null) {
                configuration = invoker.getGraphicsConfiguration();
            }
            if (configuration == null) {
                return Short.MAX_VALUE;
            }
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration);
            if (StartupUiUtil.isWaylandToolkit()) {
                Integer screenHeight = WaylandUtilKt.getFakeScreenHeight(invoker);
                screenRectangle.height = screenHeight != null ? screenHeight : 600;
            }
            if (invoker != null && invoker.getParent() instanceof JMenuBar) {
                int menuItemHeight = invoker.getSize().height;
                int y = invoker.getLocationOnScreen().y - screenRectangle.y;
                return Math.max(y, screenRectangle.height - y - menuItemHeight);
            }
            return screenRectangle.height;
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(Container target) {
            Dimension dimension = super.preferredLayoutSize(target);
            int maxHeight = this.getMaxHeight();
            this.switchTimer(dimension.height > maxHeight);
            dimension.height = Math.min(maxHeight, dimension.height);
            Dimension dimension2 = dimension;
            if (dimension2 == null) {
                MyLayout.$$$reportNull$$$0(0);
            }
            return dimension2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/JBPopupMenu$MyLayout", "preferredLayoutSize"));
        }
    }
}

