/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextBrowseFolderListener;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.util.ui.SwingUndoUtil;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithBrowseButton
extends ComponentWithBrowseButton<JTextField>
implements TextAccessor {
    public TextFieldWithBrowseButton() {
        this((ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field) {
        this(field, (ActionListener)null);
    }

    public TextFieldWithBrowseButton(JTextField field, @Nullable ActionListener browseActionListener) {
        this(field, browseActionListener, null);
    }

    public TextFieldWithBrowseButton(JTextField field, @Nullable ActionListener browseActionListener, @Nullable Disposable parent) {
        super(field, browseActionListener);
        if (!(field instanceof JBTextField)) {
            SwingUndoUtil.addUndoRedoActions((JTextComponent)field);
        }
        this.installPathCompletion(FileChooserDescriptorFactory.createSingleLocalFileDescriptor(), parent);
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener) {
        this(browseActionListener, (Disposable)null);
    }

    public TextFieldWithBrowseButton(ActionListener browseActionListener, Disposable parent) {
        this(new ExtendableTextField(10), browseActionListener, parent);
    }

    public void addBrowseFolderListener(@Nullable Project project, @NotNull FileChooserDescriptor fileChooserDescriptor) {
        if (fileChooserDescriptor == null) {
            TextFieldWithBrowseButton.$$$reportNull$$$0(0);
        }
        this.addBrowseFolderListener(project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.installPathCompletion(fileChooserDescriptor);
    }

    @Deprecated(forRemoval=true)
    public void addBrowseFolderListener(@NlsContexts.DialogTitle @Nullable String title, @NlsContexts.Label @Nullable String description, @Nullable Project project, FileChooserDescriptor fileChooserDescriptor) {
        this.addBrowseFolderListener(project, fileChooserDescriptor.withTitle(title).withDescription(description));
    }

    public void addBrowseFolderListener(@NotNull TextBrowseFolderListener listener2) {
        if (listener2 == null) {
            TextFieldWithBrowseButton.$$$reportNull$$$0(1);
        }
        listener2.setOwnerComponent(this);
        this.addActionListener(listener2);
        this.installPathCompletion(listener2.getFileChooserDescriptor());
    }

    public void addDocumentListener(@NotNull DocumentListener listener2) {
        if (listener2 == null) {
            TextFieldWithBrowseButton.$$$reportNull$$$0(2);
        }
        this.getTextField().getDocument().addDocumentListener(listener2);
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor) {
        this.installPathCompletion(fileChooserDescriptor, null);
    }

    protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            return;
        }
        FileChooserFactory instance2 = FileChooserFactory.getInstance();
        if (instance2 != null) {
            instance2.installFileCompletion((JTextField)this.getChildComponent(), fileChooserDescriptor, true, parent);
        }
    }

    @NotNull
    public JTextField getTextField() {
        JTextField jTextField = (JTextField)this.getChildComponent();
        if (jTextField == null) {
            TextFieldWithBrowseButton.$$$reportNull$$$0(3);
        }
        return jTextField;
    }

    @NotNull
    public String getText() {
        String text = Strings.notNullize((String)this.getTextField().getText());
        if (!(this instanceof NoPathCompletion)) {
            text = OSAgnosticPathUtil.expandUserHome((String)text);
        }
        String string = text;
        if (string == null) {
            TextFieldWithBrowseButton.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void setText(@NlsSafe @Nullable String text) {
        this.getTextField().setText(text);
    }

    public boolean isEditable() {
        return this.getTextField().isEditable();
    }

    public void setEditable(boolean b) {
        this.getTextField().setEditable(b);
        this.getButton().setFocusable(!b);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/TextFieldWithBrowseButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/TextFieldWithBrowseButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addBrowseFolderListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDocumentListener";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    public static class NoPathCompletion
    extends TextFieldWithBrowseButton {
        public NoPathCompletion() {
        }

        public NoPathCompletion(JTextField field) {
            super(field);
        }

        public NoPathCompletion(JTextField field, ActionListener browseActionListener) {
            super(field, browseActionListener);
        }

        public NoPathCompletion(ActionListener browseActionListener) {
            super(browseActionListener);
        }

        @Override
        protected void installPathCompletion(FileChooserDescriptor fileChooserDescriptor, @Nullable Disposable parent) {
        }
    }
}

