/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.messages;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.ExitActionType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MessageDialog
extends DialogWrapper {
    protected @NlsContexts.DialogMessage @Nullable String myMessage;
    protected String[] myOptions;
    protected ExitActionType[] myExitActionTypes;
    protected int myDefaultOptionIndex;
    protected int myFocusedOptionIndex;
    protected Icon myIcon;
    @NonNls
    @Nullable
    private String myHelpId;

    public MessageDialog(@Nullable Project project, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon, boolean canBeParent) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(0);
        }
        this(project, null, message, title, options, defaultOptionIndex, -1, icon, null, canBeParent);
    }

    public MessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, boolean canBeParent) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(1);
        }
        this(project, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, canBeParent, null);
    }

    public MessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, boolean canBeParent, @Nullable String helpId, @Nullable String invocationPlace, ExitActionType @NotNull [] exitActionTypes) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(2);
        }
        if (exitActionTypes == null) {
            MessageDialog.$$$reportNull$$$0(3);
        }
        super(project, parentComponent, canBeParent, DialogWrapper.IdeModalityType.IDE);
        this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, helpId, invocationPlace, exitActionTypes);
    }

    public MessageDialog(@Nullable Project project, @Nullable Component parentComponent, @NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, boolean canBeParent, @Nullable String helpId) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(4);
        }
        this(project, parentComponent, message, title, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, canBeParent, helpId, null, new ExitActionType[0]);
    }

    public MessageDialog(@NlsContexts.DialogMessage @Nullable String message, @NlsContexts.DialogTitle String title, String @NotNull [] options, int defaultOptionIndex, @Nullable Icon icon) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(5);
        }
        this(null, null, message, title, options, defaultOptionIndex, -1, icon, null, false);
    }

    protected MessageDialog() {
        super(false);
    }

    protected MessageDialog(Project project) {
        super(project, false);
    }

    public MessageDialog(Project project, boolean canBeParent) {
        super(project, canBeParent);
    }

    protected void _init(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage @Nullable String message, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, @Nullable String helpId) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(6);
        }
        this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, helpId, null, new ExitActionType[0]);
    }

    @Deprecated(forRemoval=true)
    protected void _init(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage @Nullable String message, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption doNotAskOption, @Nullable String helpId) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(7);
        }
        this._init(title, message, options, defaultOptionIndex, focusedOptionIndex, icon, doNotAskOption, helpId, null, new ExitActionType[0]);
    }

    protected void _init(@NlsContexts.DialogTitle String title, @NlsContexts.DialogMessage @Nullable String message, String @NotNull [] options, int defaultOptionIndex, int focusedOptionIndex, @Nullable Icon icon, @Nullable DoNotAskOption doNotAskOption, @Nullable String helpId, @Nullable String invocationPlace, ExitActionType @NotNull [] exitActionTypes) {
        if (options == null) {
            MessageDialog.$$$reportNull$$$0(8);
        }
        if (exitActionTypes == null) {
            MessageDialog.$$$reportNull$$$0(9);
        }
        this.setTitle(title);
        this.myMessage = message;
        this.myOptions = options;
        this.myExitActionTypes = exitActionTypes;
        this.myDefaultOptionIndex = defaultOptionIndex;
        this.myFocusedOptionIndex = focusedOptionIndex;
        this.myIcon = icon;
        this.myHelpId = helpId;
        this.setDoNotAskOption(doNotAskOption);
        this.setInvocationPlace(invocationPlace);
        this.init();
    }

    @Override
    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (int i = 0; i < this.myOptions.length; ++i) {
            String option = this.myOptions[i];
            final int exitCode = i;
            final ExitActionType exitActionType = this.myExitActionTypes.length > i ? this.myExitActionTypes[i] : ExitActionType.UNDEFINED;
            AbstractAction action = new AbstractAction(UIUtil.replaceMnemonicAmpersand((String)option)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MessageDialog.this.close(exitCode, true, exitActionType);
                }
            };
            if (i == this.myDefaultOptionIndex) {
                action.putValue("DefaultAction", Boolean.TRUE);
            }
            if (i == this.myFocusedOptionIndex) {
                action.putValue("FocusedAction", Boolean.TRUE);
            }
            UIUtil.assignMnemonic((String)option, (Action)action);
            actions.add(action);
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        Action[] actionArray = actions.toArray(new Action[0]);
        if (actionArray == null) {
            MessageDialog.$$$reportNull$$$0(10);
        }
        return actionArray;
    }

    @Override
    public void doCancelAction() {
        this.close(-1);
    }

    @Override
    protected JComponent createCenterPanel() {
        return this.doCreateCenterPanel();
    }

    protected JComponent doCreateCenterPanel() {
        JPanel panel2 = this.createIconPanel();
        if (this.myMessage != null) {
            JTextPane messageComponent = this.createMessageComponent(this.myMessage);
            panel2.add((Component)Messages.wrapToScrollPaneIfNeeded(messageComponent, 100, 15), "Center");
        }
        return panel2;
    }

    @NotNull
    protected JPanel createIconPanel() {
        JPanel panel2 = new JPanel(new BorderLayout(15, 0));
        if (this.myIcon != null) {
            JLabel iconLabel = new JLabel(this.myIcon);
            Container container = new Container();
            container.setLayout(new BorderLayout());
            container.add((Component)iconLabel, "North");
            panel2.add((Component)container, "West");
        }
        JPanel jPanel = panel2;
        if (jPanel == null) {
            MessageDialog.$$$reportNull$$$0(11);
        }
        return jPanel;
    }

    @NotNull
    protected JPanel createMessagePanel() {
        JPanel messagePanel = new JPanel(new BorderLayout());
        if (this.myMessage != null) {
            JLabel textLabel = new JLabel(this.myMessage);
            textLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            textLabel.setUI(new MultiLineLabelUI());
            messagePanel.add((Component)textLabel, "North");
        }
        JPanel jPanel = messagePanel;
        if (jPanel == null) {
            MessageDialog.$$$reportNull$$$0(12);
        }
        return jPanel;
    }

    protected JTextPane createMessageComponent(@NlsContexts.DialogMessage String message) {
        JTextPane messageComponent = new JTextPane(){

            @Override
            public AccessibleContext getAccessibleContext() {
                if (this.accessibleContext == null) {
                    this.accessibleContext = new JEditorPane.AccessibleJEditorPane(){

                        @Override
                        public AccessibleRole getAccessibleRole() {
                            return AccessibleRole.LABEL;
                        }
                    };
                }
                return this.accessibleContext;
            }
        };
        messageComponent.getAccessibleContext().setAccessibleName(StringUtil.unescapeXmlEntities((String)StringUtil.stripHtml((String)message, (String)" ")));
        return Messages.configureMessagePaneUi(messageComponent, message);
    }

    @Override
    @Nullable
    protected String getHelpId() {
        return this.myHelpId;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitActionTypes";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/ui/messages/MessageDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/ui/messages/MessageDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createIconPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createMessagePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "_init";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

