/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TitledSeparator
extends JPanel
implements ComboBox.SelectableItem {
    public static final int TOP_INSET = 7;
    public static final int BOTTOM_INSET = 5;
    public static final int SEPARATOR_LEFT_INSET = 6;
    public static final int SEPARATOR_RIGHT_INSET = 0;
    private static final int SEPARATOR_TOP_INSET = 2;
    private static final Color ENABLED_SEPARATOR_FOREGROUND = JBColor.namedColor((String)"Group.separatorColor", (Color)new JBColor((Color)Gray.xCD, (Color)Gray.x51));
    private static final Color DISABLED_SEPARATOR_FOREGROUND = JBColor.namedColor((String)"Group.disabledSeparatorColor", (Color)ENABLED_SEPARATOR_FOREGROUND);
    private FocusListener labelFocusListener;
    protected final JBLabel myLabel = this.createLabel();
    protected final JSeparator mySeparator = new JSeparator(0);
    private @NlsContexts.Separator String originalText;

    @NotNull
    public static Border createEmptyBorder() {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)7, (int)0, (int)5, (int)0);
        if (jBEmptyBorder == null) {
            TitledSeparator.$$$reportNull$$$0(0);
        }
        return jBEmptyBorder;
    }

    public TitledSeparator() {
        this("");
    }

    public TitledSeparator(@NlsContexts.Separator String text) {
        this(text, null);
    }

    public TitledSeparator(@NlsContexts.Separator String text, @Nullable JComponent labelFor) {
        this.mySeparator.setForeground(ENABLED_SEPARATOR_FOREGROUND);
        this.setLayout(new GridBagLayout());
        this.addComponents(false);
        this.setText(text);
        this.setLabelFor(labelFor);
        this.setOpaque(false);
        this.updateLabelFont();
        this.putClientProperty((Object)DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateLabelFont();
    }

    public void setLabelFocusable(boolean focusable) {
        this.myLabel.setFocusable(focusable);
        this.remove(this.myLabel);
        this.remove(this.mySeparator);
        this.addComponents(focusable);
        if (focusable) {
            if (this.labelFocusListener == null) {
                this.labelFocusListener = new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        TitledSeparator.this.setLabelBorder(true);
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        TitledSeparator.this.setLabelBorder(false);
                    }
                };
                this.myLabel.addFocusListener(this.labelFocusListener);
                this.setLabelBorder(false);
            }
        } else {
            if (this.labelFocusListener != null) {
                this.myLabel.removeFocusListener(this.labelFocusListener);
                this.labelFocusListener = null;
            }
            this.myLabel.setBorder(null);
        }
    }

    protected JBLabel createLabel() {
        return new JBLabel();
    }

    private void setLabelBorder(boolean focused) {
        this.myLabel.setBorder(TitleSelectionBorder.getLabelBorder(focused));
    }

    private void addComponents(boolean focusable) {
        if (focusable) {
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
            this.add((Component)this.mySeparator, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insets((int)8, (int)0, (int)4, (int)0), 0, 0));
            this.setBorder(null);
        } else {
            this.add((Component)this.myLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
            this.add((Component)this.mySeparator, new GridBagConstraints(1, 0, 0, 1, 1.0, 1.0, 10, 2, (Insets)JBUI.insets((int)2, (int)6, (int)0, (int)0), 0, 0));
            this.setBorder(TitledSeparator.createEmptyBorder());
        }
    }

    private void updateLabelFont() {
        if (this.myLabel != null) {
            Font labelFont = StartupUiUtil.getLabelFont();
            this.myLabel.setFont(RelativeFont.NORMAL.fromResource("TitledSeparator.fontSizeOffset", 0).derive(labelFont));
        }
    }

    @NlsContexts.Separator
    public String getText() {
        return this.originalText;
    }

    public void setText(@NlsContexts.Separator String text) {
        this.originalText = text;
        this.myLabel.setText(text != null && text.startsWith("<html>") ? text : UIUtil.replaceMnemonicAmpersand((String)this.originalText));
    }

    public void setTitleFont(Font font) {
        this.myLabel.setFont(font);
    }

    public Font getTitleFont() {
        return this.myLabel.getFont();
    }

    public JLabel getLabel() {
        return this.myLabel;
    }

    public JSeparator getSeparator() {
        return this.mySeparator;
    }

    public Component getLabelFor() {
        return this.myLabel.getLabelFor();
    }

    public void setLabelFor(Component labelFor) {
        this.myLabel.setLabelFor(labelFor);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myLabel.setEnabled(enabled);
        this.mySeparator.setEnabled(enabled);
        this.mySeparator.setForeground(enabled ? ENABLED_SEPARATOR_FOREGROUND : DISABLED_SEPARATOR_FOREGROUND);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = super.getAccessibleContext();
            this.accessibleContext.setAccessibleName(this.myLabel.getText());
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/TitledSeparator", "createEmptyBorder"));
    }

    private static class TitleSelectionBorder {
        private static final int INSIDE_BOTTOM_RIGHT_INSET = 2;
        private static final int FOCUS_THICKNESS = 1;

        private TitleSelectionBorder() {
        }

        private static Border getLabelBorder(boolean focused) {
            if (!focused) {
                return new EmptyBorder(TitleSelectionBorder.getInsets());
            }
            int arcSize = JBUIScale.scale((int)Registry.intValue((String)"ide.link.button.focus.round.arc", (int)4));
            return JBUI.Borders.compound((Border[])new Border[]{new EmptyBorder(TitleSelectionBorder.getOutsideFrameInsets()), new RoundedLineBorder(JBUI.CurrentTheme.Link.FOCUSED_BORDER_COLOR, arcSize, 1), new EmptyBorder(TitleSelectionBorder.getInsideFrameInsets())});
        }

        private static void add(Insets destInsets, Insets insetsToAdd) {
            destInsets.top += insetsToAdd.top;
            destInsets.bottom += insetsToAdd.bottom;
            destInsets.left += insetsToAdd.left;
            destInsets.right += insetsToAdd.right;
        }

        private static Insets getInsideFrameInsets() {
            return new JBInsets(0, 0, 2, 2);
        }

        private static Insets getFrameInsets() {
            return new Insets(1, 1, 1, 1);
        }

        private static Insets getOutsideFrameInsets() {
            Insets insets = TitleSelectionBorder.getInsideFrameInsets();
            TitleSelectionBorder.add(insets, TitleSelectionBorder.getFrameInsets());
            return new Insets(JBUIScale.scale((int)7) - insets.top, insets.left + 1, JBUIScale.scale((int)5) - insets.bottom, 6 - insets.right);
        }

        private static Insets getInsets() {
            Insets result2 = TitleSelectionBorder.getInsideFrameInsets();
            TitleSelectionBorder.add(result2, TitleSelectionBorder.getFrameInsets());
            TitleSelectionBorder.add(result2, TitleSelectionBorder.getOutsideFrameInsets());
            return result2;
        }
    }
}

