/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.ui.scale.JBUIScale;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B'\b\u0016\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0004\b\u0002\u0010\rB\u001f\b\u0017\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\fH\u0016J\u0006\u0010\u001d\u001a\u00020\fJ\u0006\u0010\u001e\u001a\u00020\fJ\u0006\u0010\u001f\u001a\u00020\fJ\u0006\u0010 \u001a\u00020\fJ\u0016\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020)H\u0016R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R$\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/intellij/ui/components/ActionLink;", "Ljavax/swing/JButton;", "<init>", "()V", "action", "Ljavax/swing/Action;", "(Ljavax/swing/Action;)V", "text", "", "perform", "Lkotlin/Function1;", "Ljava/awt/event/ActionEvent;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "listener", "Ljava/awt/event/ActionListener;", "(Ljava/lang/String;Ljava/awt/event/ActionListener;)V", "getUIClassID", "updateUI", "newValue", "", "autoHideOnDisable", "getAutoHideOnDisable", "()Z", "setAutoHideOnDisable", "(Z)V", "visited", "getVisited", "setVisited", "setLinkIcon", "setContextHelpIcon", "setExternalLinkIcon", "setDropDownLinkIcon", "setIcon", "anIcon", "Ljavax/swing/Icon;", "atRight", "withFont", "font", "Ljava/awt/Font;", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nActionLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionLink.kt\ncom/intellij/ui/components/ActionLink\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public class ActionLink
extends JButton {
    private boolean autoHideOnDisable;
    private boolean visited;

    public ActionLink() {
        this.addPropertyChangeListener("enabled", arg_0 -> ActionLink._init_$lambda$0(this, arg_0));
        this.autoHideOnDisable = true;
    }

    @Override
    @NotNull
    public String getUIClassID() {
        return "LinkButtonUI";
    }

    @Override
    public void updateUI() {
        Object object = UIManager.get(this.getUIClassID());
        if (object == null) {
            object = UIManager.put(this.getUIClassID(), "com.intellij.ui.components.DefaultLinkButtonUI");
        }
        super.updateUI();
    }

    public ActionLink(@NotNull Action action) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        this();
        this.setAction(action);
    }

    public ActionLink(@Nls @NotNull String text, @NotNull Function1<? super ActionEvent, Unit> perform) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(perform, (String)"perform");
        this(text, arg_0 -> ActionLink._init_$lambda$1(perform, arg_0));
    }

    @JvmOverloads
    public ActionLink(@Nls @NotNull String text, @Nullable ActionListener listener2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this();
            this.setText(text);
            ActionListener actionListener = listener2;
            if (actionListener == null) break block0;
            ActionListener it = actionListener;
            boolean bl = false;
            this.addActionListener(it);
        }
    }

    public /* synthetic */ ActionLink(String string, ActionListener actionListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            actionListener = null;
        }
        this(string, actionListener);
    }

    public final boolean getAutoHideOnDisable() {
        return this.autoHideOnDisable;
    }

    public final void setAutoHideOnDisable(boolean newValue) {
        boolean oldValue = this.autoHideOnDisable;
        if (oldValue == newValue) {
            return;
        }
        this.autoHideOnDisable = newValue;
        this.firePropertyChange("autoHideOnDisable", oldValue, newValue);
        this.setVisible(!newValue || this.isEnabled());
    }

    public final boolean getVisited() {
        return this.visited;
    }

    public final void setVisited(boolean newValue) {
        boolean oldValue = this.visited;
        if (oldValue == newValue) {
            return;
        }
        this.visited = newValue;
        this.firePropertyChange("visited", oldValue, newValue);
        this.repaint();
    }

    public final void setLinkIcon() {
        Icon icon = AllIcons.Ide.Link;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Link");
        this.setIcon(icon, false);
    }

    public final void setContextHelpIcon() {
        Icon icon = AllIcons.General.ContextHelp;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ContextHelp");
        this.setIcon(icon, false);
    }

    public final void setExternalLinkIcon() {
        Icon icon = AllIcons.Ide.External_link_arrow;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"External_link_arrow");
        this.setIcon(icon, true);
    }

    public final void setDropDownLinkIcon() {
        Icon icon = AllIcons.General.LinkDropTriangle;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"LinkDropTriangle");
        this.setIcon(icon, true);
    }

    public final void setIcon(@NotNull Icon anIcon, boolean atRight) {
        Intrinsics.checkNotNullParameter((Object)anIcon, (String)"anIcon");
        this.setIcon(anIcon);
        this.setIconTextGap(JBUIScale.scale((int)(atRight ? 1 : 4)));
        this.setHorizontalTextPosition(atRight ? 10 : 11);
    }

    @NotNull
    public final ActionLink withFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.setFont(font);
        return this;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AbstractButton.AccessibleAbstractButton(this){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.HYPERLINK;
                }

                public AccessibleValue getAccessibleValue() {
                    return null;
                }
            };
        }
        AccessibleContext accessibleContext = this.accessibleContext;
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"accessibleContext");
        return accessibleContext;
    }

    @JvmOverloads
    public ActionLink(@Nls @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this(text, null, 2, null);
    }

    private static final void _init_$lambda$0(ActionLink this$0, PropertyChangeEvent it) {
        if (this$0.autoHideOnDisable) {
            this$0.setVisible(this$0.isEnabled());
        }
    }

    private static final void _init_$lambda$1$0(Function1 $perform, ActionEvent $it) {
        Intrinsics.checkNotNull((Object)$it);
        $perform.invoke((Object)$it);
    }

    private static final void _init_$lambda$1(Function1 $perform, ActionEvent it) {
        WriteIntentReadAction.run(() -> ActionLink._init_$lambda$1$0($perform, it));
    }
}

