/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.components.BulkUpdateListSelectionModel;
import com.intellij.ui.components.BulkUpdateListUi;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.WideSelectionListCache;
import com.intellij.ui.hover.ListHoverListener;
import com.intellij.ui.list.ListCellBackgroundSupplier;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class WideSelectionListUI
extends BasicListUI
implements BulkUpdateListUi {
    private static final Logger LOG = Logger.getInstance(WideSelectionListUI.class);
    private Rectangle myPaintBounds;
    @ApiStatus.Internal
    @VisibleForTesting
    public WideSelectionListCache cacheSupport;

    @Override
    public void paint(Graphics g, JComponent c) {
        this.myPaintBounds = 0 != this.list.getLayoutOrientation() ? null : g.getClipBounds();
        super.paint(g, c);
    }

    protected void paintCell(Graphics g, int row, Rectangle rowBounds, ListCellRenderer renderer, ListModel model, ListSelectionModel selectionModel, int leadSelectionIndex) {
        if (0 > row || row >= model.getSize()) {
            return;
        }
        boolean selected2 = selectionModel.isSelectedIndex(row);
        Rectangle paintBounds = this.myPaintBounds;
        if (paintBounds != null) {
            Component component;
            boolean focused = row == leadSelectionIndex && (!this.list.isFocusable() || this.list.hasFocus());
            Object value2 = model.getElementAt(row);
            Color background = WideSelectionListUI.getBackground(this.list, value2, row, selected2);
            if (background != null) {
                g.setColor(background);
                g.fillRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
            if ((component = renderer.getListCellRendererComponent(this.list, value2, row, selected2, focused)) != null) {
                if (this.rendererPane != component.getParent()) {
                    this.rendererPane.add(component);
                }
                g.setClip(paintBounds.x, paintBounds.y, paintBounds.width, paintBounds.height);
                WideSelectionListUI.paintRenderer(g, rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height, this.list, component);
                g.clipRect(rowBounds.x, rowBounds.y, rowBounds.width, rowBounds.height);
            }
        }
        try {
            super.paintCell(g, row, rowBounds, renderer, model, selectionModel, leadSelectionIndex);
        }
        catch (IndexOutOfBoundsException exception) {
            LOG.error("model asynchronously modified: " + String.valueOf(model.getClass()) + " in " + String.valueOf(this.list), (Throwable)exception);
        }
        if (!SystemInfo.isMac && g instanceof Graphics2D && row == leadSelectionIndex && this.list.hasFocus()) {
            int x = rowBounds.x;
            int width = rowBounds.width;
            if (0 == this.list.getLayoutOrientation()) {
                x = 0;
                width = this.list.getWidth();
                JViewport viewport = ComponentUtil.getViewport((Component)this.list);
                if (viewport != null) {
                    x = -this.list.getX();
                    width = viewport.getWidth();
                }
            }
            if (!selected2) {
                g.setColor(UIUtil.getListSelectionBackground((boolean)true));
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x, rowBounds.y, width, rowBounds.height, (Object)0);
            } else if (WideSelectionListUI.isLeadSelectionNeeded(this.list, row)) {
                g.setColor(UIUtil.getListBackground());
                g.setClip(x, rowBounds.y, width, rowBounds.height);
                RectanglePainter.DRAW.paint((Graphics2D)g, x + 1, rowBounds.y + 1, width - 2, rowBounds.height - 2, (Object)0);
            }
        }
    }

    private static boolean isLeadSelectionNeeded(@NotNull JList list, int row) {
        if (list == null) {
            WideSelectionListUI.$$$reportNull$$$0(0);
        }
        return list.getMinSelectionIndex() < list.getMaxSelectionIndex() && list.isSelectedIndex(row - 1) && list.isSelectedIndex(row + 1);
    }

    @Nullable
    private static Color getBackground(@NotNull JList<Object> list, @Nullable Object value2, int row, boolean selected2) {
        BackgroundSupplier supplier;
        Color background;
        Color background2;
        if (list == null) {
            WideSelectionListUI.$$$reportNull$$$0(1);
        }
        if (selected2) {
            return RenderingUtil.getSelectionBackground(list);
        }
        if (row == ListHoverListener.getHoveredIndex(list) && (background2 = RenderingUtil.getHoverBackground(list)) != null) {
            return background2;
        }
        if (value2 instanceof ColoredItem && (background2 = ((ColoredItem)value2).getColor()) != null) {
            return background2;
        }
        if (value2 instanceof BackgroundSupplier && (background = (supplier = (BackgroundSupplier)value2).getElementBackground(row)) != null) {
            return background;
        }
        if (list instanceof ListCellBackgroundSupplier && (background = (supplier = (ListCellBackgroundSupplier)list).getCellBackground(value2, row)) != null) {
            return background;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintRenderer(Graphics g, int x, int y, int width, int height, Component owner2, Component renderer) {
        g.clipRect(0, y, owner2.getWidth(), height);
        WideSelectionListUI.paintBackground(g, y, height, owner2, renderer);
        if (renderer instanceof Container) {
            Component[] children;
            Container container = (Container)renderer;
            Component[] componentArray = container.getTreeLock();
            synchronized (componentArray) {
                children = container.getComponents();
            }
            if (children.length > 0) {
                renderer.setBounds(x, y, width, height);
                renderer.validate();
                for (Component child : children) {
                    if (0 != child.getX() || width != child.getWidth() || 0 >= child.getHeight()) continue;
                    WideSelectionListUI.paintBackground(g, y + child.getY(), child.getHeight(), owner2, child);
                }
            }
        }
    }

    private static void paintBackground(Graphics g, int y, int height, Component owner2, Component child) {
        Color color;
        if (child.isOpaque() && (color = child.getBackground()) != null && !color.equals(owner2.getBackground())) {
            g.setColor(color);
            g.fillRect(0, y, owner2.getWidth(), height);
        }
    }

    public Rectangle getCellBounds(JList list, int index1, int index2) {
        Rectangle bounds = super.getCellBounds(list, index1, index2);
        if (bounds != null && index1 == index2 && list instanceof JBList && 0 == list.getLayoutOrientation() && ((JBList)list).getExpandableItemsHandler().getExpandedItems().contains(index1)) {
            JScrollBar bar;
            JScrollPane pane = ComponentUtil.getScrollPane((Component)list);
            JScrollBar jScrollBar = bar = pane == null ? null : pane.getVerticalScrollBar();
            if (bar != null && !bar.isOpaque()) {
                bounds.width += bar.getWidth();
            }
        }
        return bounds;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.cacheSupport = new WideSelectionListCache(this.list);
        this.cacheSupport.installListeners();
    }

    @Override
    protected void uninstallListeners() {
        this.cacheSupport.uninstallListeners();
        this.cacheSupport = null;
        super.uninstallListeners();
    }

    @Override
    protected void updateLayoutState() {
        block10: {
            int fixedCellWidth;
            if (this.list.getLayoutOrientation() != 0) {
                super.updateLayoutState();
                return;
            }
            int fixedCellHeight = this.list.getFixedCellHeight();
            this.cellWidth = fixedCellWidth = this.list.getFixedCellWidth();
            if (fixedCellHeight != -1) {
                this.cellHeight = fixedCellHeight;
                this.cellHeights = null;
            } else {
                this.cellHeight = -1;
                this.cellHeights = new int[this.list.getModel().getSize()];
            }
            if (fixedCellWidth != -1 && fixedCellHeight != -1) break block10;
            ListModel<Object> dataModel = this.list.getModel();
            int dataModelSize = dataModel.getSize();
            ListCellRenderer<Object> renderer = this.list.getCellRenderer();
            if (renderer != null) {
                boolean immutableRenderer = ClientProperty.isTrue((Component)this.list, JBList.IMMUTABLE_MODEL_AND_RENDERER);
                for (int index = 0; index < dataModelSize; ++index) {
                    Dimension cellSize = this.getItemPreferredSize(index, dataModel, renderer, immutableRenderer);
                    if (fixedCellWidth == -1) {
                        this.cellWidth = Math.max(cellSize.width, this.cellWidth);
                    }
                    if (fixedCellHeight != -1) continue;
                    this.cellHeights[index] = cellSize.height;
                }
            } else {
                if (this.cellWidth == -1) {
                    this.cellWidth = 0;
                }
                if (this.cellHeights == null) {
                    this.cellHeights = new int[dataModelSize];
                }
                for (int index = 0; index < dataModelSize; ++index) {
                    this.cellHeights[index] = 0;
                }
            }
        }
    }

    @TestOnly
    @ApiStatus.Internal
    public void updateLayoutStateTestAccessor() {
        this.updateLayoutState();
    }

    @NotNull
    private Dimension getItemPreferredSize(int index, @NotNull ListModel<Object> dataModel, @NotNull ListCellRenderer<Object> renderer, boolean immutableRenderer) {
        if (dataModel == null) {
            WideSelectionListUI.$$$reportNull$$$0(2);
        }
        if (renderer == null) {
            WideSelectionListUI.$$$reportNull$$$0(3);
        }
        Object value2 = dataModel.getElementAt(index);
        Dimension dimension = this.cacheSupport.getCachedPreferredSizeOrCalculate(value2, immutableRenderer, (Function0<? extends Dimension>)((Function0)() -> {
            Component c = renderer.getListCellRendererComponent(this.list, value2, index, false, false);
            this.rendererPane.add(c);
            Dimension result2 = c.getPreferredSize();
            if (ClientProperty.get((Component)c, (Object)"IgnoreListRowHeight") == null) {
                result2 = UIUtil.updateListRowHeight((Dimension)result2);
            }
            return result2;
        }));
        if (dimension == null) {
            WideSelectionListUI.$$$reportNull$$$0(4);
        }
        return dimension;
    }

    @Override
    protected FocusListener createFocusListener() {
        final FocusListener superFocusListener = super.createFocusListener();
        return new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (WideSelectionListUI.this.list.getSelectionMode() == 0) {
                    superFocusListener.focusGained(e);
                } else {
                    WideSelectionListUI.this.list.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (WideSelectionListUI.this.list.getSelectionMode() == 0) {
                    superFocusListener.focusLost(e);
                } else {
                    WideSelectionListUI.this.list.repaint();
                }
            }
        };
    }

    public static ComponentUI createUI(JComponent list) {
        return new WideSelectionListUI();
    }

    @Override
    @ApiStatus.Internal
    public void beforeBulkListUpdate() {
        if (this.list == null) {
            return;
        }
        this.list.clearSelection();
        this.updateLayoutStateNeeded |= 2;
    }

    @Override
    @ApiStatus.Internal
    public void afterBulkListUpdate() {
        if (this.list == null) {
            return;
        }
        this.list.clearSelection();
        this.updateLayoutStateNeeded |= 2;
        this.maybeUpdateLayoutState();
        this.list.revalidate();
        this.list.repaint();
    }

    @Override
    protected ListSelectionListener createListSelectionListener() {
        ListSelectionListener listener2 = super.createListSelectionListener();
        return new BulkAwareListSelectionListener(listener2, this.list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/components/WideSelectionListUI";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/components/WideSelectionListUI";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemPreferredSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isLeadSelectionNeeded";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBackground";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getItemPreferredSize";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }

    private static class BulkAwareListSelectionListener
    implements ListSelectionListener {
        @NotNull
        private final ListSelectionListener myDelegate;
        @NotNull
        private final JList<?> myList;

        private BulkAwareListSelectionListener(@NotNull ListSelectionListener delegate, @NotNull JList<?> list) {
            if (delegate == null) {
                BulkAwareListSelectionListener.$$$reportNull$$$0(0);
            }
            if (list == null) {
                BulkAwareListSelectionListener.$$$reportNull$$$0(1);
            }
            this.myDelegate = delegate;
            this.myList = list;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            BulkUpdateListSelectionModel bulkModel;
            ListSelectionModel model = this.myList.getSelectionModel();
            if (model instanceof BulkUpdateListSelectionModel && (bulkModel = (BulkUpdateListSelectionModel)((Object)model)).isBulkUpdateInProgress()) {
                return;
            }
            this.myDelegate.valueChanged(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "list";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/components/WideSelectionListUI$BulkAwareListSelectionListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

