/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.list;

import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 62\u00020\u0001:\u0003456B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0005R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR*\u0010\u001d\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R*\u0010#\u001a\u0004\u0018\u00010\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0007@FX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b$\u0010\u001f\"\u0004\b%\u0010!R \u0010&\u001a\u0004\u0018\u00010'8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00067"}, d2={"Lcom/intellij/ui/popup/list/SelectablePanel;", "Ljavax/swing/JPanel;", "background", "Ljava/awt/Color;", "<init>", "(Ljava/awt/Color;)V", "selectionArc", "", "getSelectionArc", "()I", "setSelectionArc", "(I)V", "selectionArcCorners", "Lcom/intellij/ui/popup/list/SelectablePanel$SelectionArcCorners;", "getSelectionArcCorners", "()Lcom/intellij/ui/popup/list/SelectablePanel$SelectionArcCorners;", "setSelectionArcCorners", "(Lcom/intellij/ui/popup/list/SelectablePanel$SelectionArcCorners;)V", "value", "selectionColor", "getSelectionColor", "()Ljava/awt/Color;", "setSelectionColor", "selectionInsets", "Ljava/awt/Insets;", "getSelectionInsets", "()Ljava/awt/Insets;", "setSelectionInsets", "(Ljava/awt/Insets;)V", "preferredHeight", "getPreferredHeight", "()Ljava/lang/Integer;", "setPreferredHeight", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "preferredWidth", "getPreferredWidth", "setPreferredWidth", "accessibleContextProvider", "Ljava/awt/Component;", "getAccessibleContextProvider", "()Ljava/awt/Component;", "setAccessibleContextProvider", "(Ljava/awt/Component;)V", "getAccessibleContext", "Ljavax/accessibility/AccessibleContext;", "getPreferredSize", "Ljava/awt/Dimension;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "Side", "SelectionArcCorners", "Companion", "intellij.platform.ide"})
@ApiStatus.Experimental
public class SelectablePanel
extends JPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int selectionArc;
    @NotNull
    private SelectionArcCorners selectionArcCorners;
    @Nullable
    private Color selectionColor;
    @NotNull
    private Insets selectionInsets;
    @Nullable
    private Integer preferredHeight;
    @Nullable
    private Integer preferredWidth;
    @ApiStatus.Experimental
    @Nullable
    private Component accessibleContextProvider;

    public SelectablePanel(@Nullable Color background) {
        this.selectionArcCorners = SelectionArcCorners.ALL;
        JBInsets jBInsets = JBUI.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        this.selectionInsets = (Insets)jBInsets;
        if (background != null) {
            this.setBackground(background);
        }
    }

    public /* synthetic */ SelectablePanel(Color color, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            color = null;
        }
        this(color);
    }

    public final int getSelectionArc() {
        return this.selectionArc;
    }

    public final void setSelectionArc(int n) {
        this.selectionArc = n;
    }

    @NotNull
    public final SelectionArcCorners getSelectionArcCorners() {
        return this.selectionArcCorners;
    }

    public final void setSelectionArcCorners(@NotNull SelectionArcCorners selectionArcCorners) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectionArcCorners), (String)"<set-?>");
        this.selectionArcCorners = selectionArcCorners;
    }

    @Nullable
    public final Color getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(@Nullable Color value2) {
        if (!Intrinsics.areEqual((Object)this.selectionColor, (Object)value2)) {
            this.selectionColor = value2;
            this.repaint();
        }
    }

    @NotNull
    public final Insets getSelectionInsets() {
        return this.selectionInsets;
    }

    public final void setSelectionInsets(@NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)insets, (String)"<set-?>");
        this.selectionInsets = insets;
    }

    @Nullable
    public final Integer getPreferredHeight() {
        return this.preferredHeight;
    }

    public final void setPreferredHeight(@Nullable Integer value2) {
        this.preferredHeight = value2;
        this.invalidate();
    }

    @Nullable
    public final Integer getPreferredWidth() {
        return this.preferredWidth;
    }

    public final void setPreferredWidth(@Nullable Integer value2) {
        this.preferredWidth = value2;
        this.invalidate();
    }

    @Nullable
    public final Component getAccessibleContextProvider() {
        return this.accessibleContextProvider;
    }

    public final void setAccessibleContextProvider(@Nullable Component component) {
        this.accessibleContextProvider = component;
    }

    @Override
    @NotNull
    public AccessibleContext getAccessibleContext() {
        Component component = this.accessibleContextProvider;
        if (component != null) {
            Component it = component;
            boolean bl = false;
            AccessibleContext accessibleContext = it.getAccessibleContext();
            Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"getAccessibleContext(...)");
            return accessibleContext;
        }
        AccessibleContext accessibleContext = super.getAccessibleContext();
        Intrinsics.checkNotNullExpressionValue((Object)accessibleContext, (String)"getAccessibleContext(...)");
        return accessibleContext;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Integer preferredWidth = this.preferredWidth;
        Integer preferredHeight = this.preferredHeight;
        if (preferredWidth != null && preferredHeight != null) {
            return new Dimension(preferredWidth, preferredHeight);
        }
        Dimension preferredSize = super.getPreferredSize();
        Integer n = preferredWidth;
        Integer n2 = preferredHeight;
        return new Dimension(n != null ? n : preferredSize.width, n2 != null ? n2 : preferredSize.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            block22: {
                block21: {
                    Color color = this.getBackground();
                    if (color != null) {
                        Color it = color;
                        boolean bl = false;
                        if (this.isOpaque()) {
                            g2.setColor(it);
                            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                    }
                    if (this.selectionColor == null) break block21;
                    if (!Intrinsics.areEqual((Object)this.getBackground(), (Object)this.selectionColor)) break block22;
                }
                return;
            }
            g2.setColor(this.selectionColor);
            GraphicsUtil.setupAAPainting((Graphics)g2);
            int rectX = this.selectionInsets.left;
            int rectY = this.selectionInsets.top;
            int rectWidth = this.getWidth() - rectX - this.selectionInsets.right;
            int rectHeight = this.getHeight() - rectY - this.selectionInsets.bottom;
            if (this.selectionArc == 0 || this.selectionArcCorners == SelectionArcCorners.ALL) {
                g2.fillRoundRect(rectX, rectY, rectWidth, rectHeight, this.selectionArc, this.selectionArc);
            } else {
                g2.clipRect(rectX, rectY, rectWidth, rectHeight);
                rectX -= this.selectionArc;
                rectY -= this.selectionArc;
                rectHeight += 2 * this.selectionArc;
                rectWidth += 2 * this.selectionArc;
                block10: for (Side side : this.selectionArcCorners.getSides$intellij_platform_ide()) {
                    switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
                        case 1: {
                            rectY += this.selectionArc;
                            rectHeight -= this.selectionArc;
                            continue block10;
                        }
                        case 2: {
                            rectHeight -= this.selectionArc;
                            continue block10;
                        }
                        case 3: {
                            rectX += this.selectionArc;
                            rectWidth -= this.selectionArc;
                            continue block10;
                        }
                        case 4: {
                            rectWidth -= this.selectionArc;
                            continue block10;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                g2.fillRoundRect(rectX, rectY, rectWidth, rectHeight, this.selectionArc, this.selectionArc);
            }
        }
        finally {
            g2.dispose();
        }
    }

    public SelectablePanel() {
        this(null, 1, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SelectablePanel wrap(@NotNull Component component, @Nullable Color background) {
        return Companion.wrap(component, background);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SelectablePanel wrap(@NotNull Component component) {
        return Companion.wrap(component);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ui/popup/list/SelectablePanel$Companion;", "", "<init>", "()V", "wrap", "Lcom/intellij/ui/popup/list/SelectablePanel;", "component", "Ljava/awt/Component;", "background", "Ljava/awt/Color;", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SelectablePanel wrap(@NotNull Component component, @Nullable Color background) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            SelectablePanel result2 = new SelectablePanel(background);
            result2.setAccessibleContextProvider(component);
            result2.setLayout(new BorderLayout());
            result2.add(component, "Center");
            return result2;
        }

        public static /* synthetic */ SelectablePanel wrap$default(Companion companion, Component component, Color color, int n, Object object) {
            if ((n & 2) != 0) {
                color = null;
            }
            return companion.wrap(component, color);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SelectablePanel wrap(@NotNull Component component) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            return com.intellij.ui.popup.list.SelectablePanel$Companion.wrap$default(this, component, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ui/popup/list/SelectablePanel$SelectionArcCorners;", "", "sides", "", "Lcom/intellij/ui/popup/list/SelectablePanel$Side;", "<init>", "(Ljava/lang/String;ILjava/util/Set;)V", "getSides$intellij_platform_ide", "()Ljava/util/Set;", "NONE", "TOP_LEFT", "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT", "LEFT", "RIGHT", "TOP", "BOTTOM", "ALL", "intellij.platform.ide"})
    public static final class SelectionArcCorners
    extends Enum<SelectionArcCorners> {
        @NotNull
        private final Set<Side> sides;
        public static final /* enum */ SelectionArcCorners NONE = new SelectionArcCorners(SetsKt.emptySet());
        public static final /* enum */ SelectionArcCorners TOP_LEFT;
        public static final /* enum */ SelectionArcCorners TOP_RIGHT;
        public static final /* enum */ SelectionArcCorners BOTTOM_LEFT;
        public static final /* enum */ SelectionArcCorners BOTTOM_RIGHT;
        public static final /* enum */ SelectionArcCorners LEFT;
        public static final /* enum */ SelectionArcCorners RIGHT;
        public static final /* enum */ SelectionArcCorners TOP;
        public static final /* enum */ SelectionArcCorners BOTTOM;
        public static final /* enum */ SelectionArcCorners ALL;
        private static final /* synthetic */ SelectionArcCorners[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SelectionArcCorners(Set<? extends Side> sides) {
            this.sides = sides;
        }

        @NotNull
        public final Set<Side> getSides$intellij_platform_ide() {
            return this.sides;
        }

        public static SelectionArcCorners[] values() {
            return (SelectionArcCorners[])$VALUES.clone();
        }

        public static SelectionArcCorners valueOf(String value2) {
            return Enum.valueOf(SelectionArcCorners.class, value2);
        }

        @NotNull
        public static EnumEntries<SelectionArcCorners> getEntries() {
            return $ENTRIES;
        }

        static {
            Side[] sideArray = new Side[]{Side.TOP, Side.LEFT};
            TOP_LEFT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.TOP, Side.RIGHT};
            TOP_RIGHT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.BOTTOM, Side.LEFT};
            BOTTOM_LEFT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.BOTTOM, Side.RIGHT};
            BOTTOM_RIGHT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.LEFT, Side.TOP, Side.BOTTOM};
            LEFT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.TOP, Side.BOTTOM, Side.RIGHT};
            RIGHT = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.TOP, Side.LEFT, Side.RIGHT};
            TOP = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            sideArray = new Side[]{Side.BOTTOM, Side.LEFT, Side.RIGHT};
            BOTTOM = new SelectionArcCorners(SetsKt.setOf((Object[])sideArray));
            ALL = new SelectionArcCorners(ArraysKt.toSet((Object[])Side.values()));
            $VALUES = selectionArcCornersArray = new SelectionArcCorners[]{SelectionArcCorners.NONE, SelectionArcCorners.TOP_LEFT, SelectionArcCorners.TOP_RIGHT, SelectionArcCorners.BOTTOM_LEFT, SelectionArcCorners.BOTTOM_RIGHT, SelectionArcCorners.LEFT, SelectionArcCorners.RIGHT, SelectionArcCorners.TOP, SelectionArcCorners.BOTTOM, SelectionArcCorners.ALL};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ui/popup/list/SelectablePanel$Side;", "", "<init>", "(Ljava/lang/String;I)V", "TOP", "BOTTOM", "LEFT", "RIGHT", "intellij.platform.ide"})
    public static final class Side
    extends Enum<Side> {
        public static final /* enum */ Side TOP = new Side();
        public static final /* enum */ Side BOTTOM = new Side();
        public static final /* enum */ Side LEFT = new Side();
        public static final /* enum */ Side RIGHT = new Side();
        private static final /* synthetic */ Side[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Side[] values() {
            return (Side[])$VALUES.clone();
        }

        public static Side valueOf(String value2) {
            return Enum.valueOf(Side.class, value2);
        }

        @NotNull
        public static EnumEntries<Side> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sideArray = new Side[]{Side.TOP, Side.BOTTOM, Side.LEFT, Side.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Side.values().length];
            try {
                nArray[Side.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.LEFT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Side.RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

