/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.diagnostic.LoadingState;
import com.intellij.ide.IdeCoreBundle;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.JdkProxyProvider;
import com.intellij.util.net.ssl.CertificateManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class PlatformHttpClient {
    @NotNull
    public static HttpClient client() {
        HttpClient httpClient = PlatformHttpClient.clientBuilder().build();
        if (httpClient == null) {
            PlatformHttpClient.$$$reportNull$$$0(0);
        }
        return httpClient;
    }

    public static @NotNull HttpClient.Builder clientBuilder() {
        Application app;
        HttpClient.Builder builder = new DelegatingHttpClientBuilder().executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).connectTimeout(Duration.ofMillis(HttpRequests.CONNECTION_TIMEOUT)).followRedirects(HttpClient.Redirect.NORMAL);
        if (LoadingState.CONFIGURATION_STORE_INITIALIZED.isOccurred() && (app = ApplicationManager.getApplication()) != null && !app.isDisposed()) {
            CertificateManager certificateManager = (CertificateManager)app.getServiceIfCreated(CertificateManager.class);
            if (certificateManager != null) {
                builder = builder.sslContext(certificateManager.getSslContext());
            }
            builder = builder.authenticator(JdkProxyProvider.getInstance().getAuthenticator());
        }
        HttpClient.Builder builder2 = builder;
        if (builder2 == null) {
            PlatformHttpClient.$$$reportNull$$$0(1);
        }
        return builder2;
    }

    public static HttpRequest request(@NotNull URI uri) {
        if (uri == null) {
            PlatformHttpClient.$$$reportNull$$$0(2);
        }
        return PlatformHttpClient.requestBuilder(uri).build();
    }

    public static @NotNull HttpRequest.Builder requestBuilder(@NotNull URI uri) {
        if (uri == null) {
            PlatformHttpClient.$$$reportNull$$$0(3);
        }
        HttpRequest.Builder builder = (uri.getScheme().equals("file") ? new FileRequestBuilder().uri(uri) : HttpRequest.newBuilder(uri)).timeout(Duration.ofMillis(HttpRequests.READ_TIMEOUT)).header("User-Agent", PlatformHttpClient.userAgent());
        if (builder == null) {
            PlatformHttpClient.$$$reportNull$$$0(4);
        }
        return builder;
    }

    @NotNull
    public static String userAgent() {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            String productName = ApplicationNamesInfo.getInstance().getFullProductName();
            String version = ApplicationInfo.getInstance().getBuild().asStringWithoutProductCode();
            String string = productName + "/" + version;
            if (string == null) {
                PlatformHttpClient.$$$reportNull$$$0(5);
            }
            return string;
        }
        return "IntelliJ";
    }

    public static <T> HttpResponse<T> checkResponse(@NotNull HttpResponse<T> response) throws HttpRequests.HttpStatusException {
        int statusCode;
        if (response == null) {
            PlatformHttpClient.$$$reportNull$$$0(6);
        }
        if ((statusCode = response.statusCode()) < 200 || statusCode >= 300) {
            if (statusCode == 407) {
                JdkProxyProvider.showProxyAuthNotification();
                Logger logger = Logger.getInstance(PlatformHttpClient.class);
                if (logger.isDebugEnabled()) {
                    logger.debug("proxy auth failed for " + String.valueOf(response.uri()) + "; Proxy-Authenticate=" + String.valueOf(response.headers().firstValue("Proxy-Authenticate")), (Throwable)new Exception());
                }
            }
            throw new HttpRequests.HttpStatusException(PlatformHttpClient.errorMessage(response), statusCode, response.uri().toString());
        }
        return response;
    }

    private static String errorMessage(HttpResponse<?> response) {
        String message = null;
        if (response.statusCode() == 451) {
            message = response.headers().firstValue("Error-Message").orElse(null);
        }
        if (message == null) {
            message = IdeCoreBundle.message((String)"error.connection.failed.status", (Object[])new Object[]{response.statusCode()});
        }
        return message;
    }

    public static HttpResponse.BodyHandler<String> gzipStringBodyHandler() {
        return responseInfo -> {
            Boolean isGzip = responseInfo.headers().firstValue("Content-Encoding").map(v -> "gzip".equalsIgnoreCase((String)v)).orElse(false);
            final Charset charset = PlatformHttpClient.findCharset(responseInfo.headers());
            if (!isGzip.booleanValue()) {
                return HttpResponse.BodySubscribers.ofString(charset);
            }
            return new HttpResponse.BodySubscriber<String>(){
                private final HttpResponse.BodySubscriber<byte[]> delegate = HttpResponse.BodySubscribers.ofByteArray();

                @Override
                public void onSubscribe(Flow.Subscription subscription) {
                    this.delegate.onSubscribe(subscription);
                }

                @Override
                public void onNext(List<ByteBuffer> item) {
                    this.delegate.onNext((byte[])item);
                }

                @Override
                public void onError(Throwable throwable) {
                    this.delegate.onError(throwable);
                }

                @Override
                public void onComplete() {
                    this.delegate.onComplete();
                }

                @Override
                public CompletionStage<String> getBody() {
                    return this.delegate.getBody().thenApply(bytes -> {
                        String string;
                        GZIPInputStream stream = new GZIPInputStream(new ByteArrayInputStream((byte[])bytes));
                        try {
                            string = new String(stream.readAllBytes(), charset);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new CompletionException(e);
                            }
                        }
                        stream.close();
                        return string;
                    });
                }
            };
        };
    }

    private static Charset findCharset(HttpHeaders headers) {
        return headers.firstValue("Content-Type").map(v -> {
            int p = v.indexOf("charset=");
            if (p > 0) {
                try {
                    return Charset.forName(v.substring(p + 8).trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }).orElse(StandardCharsets.UTF_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/PlatformHttpClient";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "client";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "clientBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/PlatformHttpClient";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "requestBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "userAgent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "request";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "requestBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkResponse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 6 -> new IllegalArgumentException(string);
        };
    }

    private static final class DelegatingHttpClientBuilder
    implements HttpClient.Builder {
        private final HttpClient.Builder delegate = HttpClient.newBuilder();

        private DelegatingHttpClientBuilder() {
        }

        @Override
        public HttpClient.Builder cookieHandler(CookieHandler cookieHandler) {
            this.delegate.cookieHandler(cookieHandler);
            return this;
        }

        @Override
        public HttpClient.Builder connectTimeout(Duration duration) {
            this.delegate.connectTimeout(duration);
            return this;
        }

        @Override
        public HttpClient.Builder sslContext(SSLContext sslContext) {
            this.delegate.sslContext(sslContext);
            return this;
        }

        @Override
        public HttpClient.Builder sslParameters(SSLParameters sslParameters) {
            this.delegate.sslParameters(sslParameters);
            return this;
        }

        @Override
        public HttpClient.Builder executor(Executor executor) {
            this.delegate.executor(executor);
            return this;
        }

        @Override
        public HttpClient.Builder followRedirects(HttpClient.Redirect policy) {
            this.delegate.followRedirects(policy);
            return this;
        }

        @Override
        public HttpClient.Builder version(HttpClient.Version version) {
            this.delegate.version(version);
            return this;
        }

        @Override
        public HttpClient.Builder priority(int priority) {
            this.delegate.priority(priority);
            return this;
        }

        @Override
        public HttpClient.Builder proxy(ProxySelector proxySelector) {
            this.delegate.proxy(proxySelector);
            return this;
        }

        @Override
        public HttpClient.Builder authenticator(Authenticator authenticator2) {
            this.delegate.authenticator(authenticator2);
            return this;
        }

        @Override
        public HttpClient build() {
            return new DelegatingHttpClient(this.delegate.build());
        }
    }

    private static class FileRequestBuilder
    implements HttpRequest.Builder {
        private URI uri;

        private FileRequestBuilder() {
        }

        @Override
        public HttpRequest.Builder uri(@NotNull URI uri) {
            if (uri == null) {
                FileRequestBuilder.$$$reportNull$$$0(0);
            }
            this.uri = uri;
            return this;
        }

        @Override
        public HttpRequest.Builder expectContinue(boolean enable) {
            return this;
        }

        @Override
        public HttpRequest.Builder version(HttpClient.Version version) {
            return this;
        }

        @Override
        public HttpRequest.Builder header(String name, String value2) {
            return this;
        }

        @Override
        public HttpRequest.Builder headers(String ... headers) {
            return this;
        }

        @Override
        public HttpRequest.Builder timeout(Duration duration) {
            return this;
        }

        @Override
        public HttpRequest.Builder setHeader(String name, String value2) {
            return this;
        }

        @Override
        public HttpRequest.Builder GET() {
            return this;
        }

        @Override
        public HttpRequest.Builder POST(HttpRequest.BodyPublisher bodyPublisher) {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpRequest.Builder PUT(HttpRequest.BodyPublisher bodyPublisher) {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpRequest.Builder DELETE() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpRequest.Builder method(String method, HttpRequest.BodyPublisher bodyPublisher) {
            throw new UnsupportedOperationException();
        }

        @Override
        public HttpRequest build() {
            return new FileHttpRequest(this.uri);
        }

        @Override
        public HttpRequest.Builder copy() {
            return new FileRequestBuilder().uri(this.uri);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/util/net/PlatformHttpClient$FileRequestBuilder", "uri"));
        }
    }

    private static final class FileHttpResponse<T>
    implements HttpResponse<T> {
        private final FileHttpRequest request;
        private final FileResponseInfo responseInfo;
        private final T body;

        private FileHttpResponse(FileHttpRequest request, FileResponseInfo responseInfo, T body) {
            this.request = request;
            this.responseInfo = responseInfo;
            this.body = body;
        }

        @Override
        public int statusCode() {
            return this.responseInfo.statusCode();
        }

        @Override
        public HttpRequest request() {
            return this.request;
        }

        @Override
        public Optional<HttpResponse<T>> previousResponse() {
            return Optional.empty();
        }

        @Override
        public HttpHeaders headers() {
            return this.responseInfo.headers();
        }

        @Override
        public T body() {
            return this.body;
        }

        @Override
        public Optional<SSLSession> sslSession() {
            return Optional.empty();
        }

        @Override
        public URI uri() {
            return this.request().uri();
        }

        @Override
        public HttpClient.Version version() {
            return this.responseInfo.version();
        }
    }

    private static final class FileResponseInfo
    implements HttpResponse.ResponseInfo {
        private final int responseCode;

        private FileResponseInfo(int responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        public int statusCode() {
            return this.responseCode;
        }

        @Override
        public HttpHeaders headers() {
            return FileHttpRequest.EMPTY_HEADERS;
        }

        @Override
        public HttpClient.Version version() {
            return HttpClient.Version.HTTP_1_1;
        }
    }

    private static final class FileHttpRequest
    extends HttpRequest {
        private static final HttpHeaders EMPTY_HEADERS = HttpHeaders.of(Map.of(), (name, value2) -> true);
        private final URI uri;

        private FileHttpRequest(URI uri) {
            this.uri = uri;
        }

        @Override
        public Optional<HttpRequest.BodyPublisher> bodyPublisher() {
            return Optional.empty();
        }

        @Override
        public String method() {
            return "GET";
        }

        @Override
        public Optional<Duration> timeout() {
            return Optional.empty();
        }

        @Override
        public boolean expectContinue() {
            return false;
        }

        @Override
        public URI uri() {
            return this.uri;
        }

        @Override
        public Optional<HttpClient.Version> version() {
            return Optional.empty();
        }

        @Override
        public HttpHeaders headers() {
            return EMPTY_HEADERS;
        }
    }

    private static final class DelegatingHttpClient
    extends HttpClient {
        private static final Flow.Subscription NULL_SUBSCRIPTION = new Flow.Subscription(){

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
            }
        };
        private final HttpClient delegate;

        private DelegatingHttpClient(HttpClient delegate) {
            this.delegate = delegate;
        }

        @Override
        public Optional<CookieHandler> cookieHandler() {
            return this.delegate.cookieHandler();
        }

        @Override
        public Optional<Duration> connectTimeout() {
            return this.delegate.connectTimeout();
        }

        @Override
        public HttpClient.Redirect followRedirects() {
            return this.delegate.followRedirects();
        }

        @Override
        public Optional<ProxySelector> proxy() {
            return this.delegate.proxy();
        }

        @Override
        public SSLContext sslContext() {
            return this.delegate.sslContext();
        }

        @Override
        public SSLParameters sslParameters() {
            return this.delegate.sslParameters();
        }

        @Override
        public Optional<Authenticator> authenticator() {
            return this.delegate.authenticator();
        }

        @Override
        public HttpClient.Version version() {
            return this.delegate.version();
        }

        @Override
        public Optional<Executor> executor() {
            return this.delegate.executor();
        }

        @Override
        public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseHandler) throws IOException, InterruptedException {
            if (request instanceof FileHttpRequest) {
                try {
                    return this.sendAsync(request, responseHandler).get();
                }
                catch (ExecutionException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        IOException ioe = (IOException)cause;
                        throw ioe;
                    }
                    throw new RuntimeException(cause);
                }
            }
            return this.delegate.send(request, responseHandler);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseHandler) {
            return this.sendAsync(request, responseHandler, null);
        }

        @Override
        public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
            if (request instanceof FileHttpRequest) {
                FileHttpRequest fhr = (FileHttpRequest)request;
                CompletableFuture result2 = new CompletableFuture();
                this.delegate.executor().orElseGet(() -> ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getIO())).execute(() -> {
                    try {
                        byte[] data = Files.readAllBytes(Path.of(request.uri()));
                        DelegatingHttpClient.completeResult(responseHandler, fhr, data, result2);
                    }
                    catch (NoSuchFileException e) {
                        DelegatingHttpClient.completeResult(responseHandler, fhr, null, result2);
                    }
                    catch (InvalidPathException e) {
                        result2.completeExceptionally(new IOException(e));
                    }
                    catch (IOException e) {
                        result2.completeExceptionally(e);
                    }
                });
                return result2;
            }
            return this.delegate.sendAsync(request, responseHandler, pushPromiseHandler);
        }

        private static <T> void completeResult(HttpResponse.BodyHandler<T> responseHandler, FileHttpRequest request, byte @Nullable [] data, CompletableFuture<HttpResponse<T>> result2) {
            FileResponseInfo responseInfo = new FileResponseInfo(data != null ? 200 : 404);
            HttpResponse.BodySubscriber<List<ByteBuffer>> subscriber = responseHandler.apply(responseInfo);
            subscriber.onSubscribe(NULL_SUBSCRIPTION);
            if (data != null) {
                subscriber.onNext(List.of(ByteBuffer.wrap(data)));
            }
            subscriber.onComplete();
            subscriber.getBody().whenComplete((body, ex) -> {
                if (ex != null) {
                    result2.completeExceptionally((Throwable)ex);
                } else {
                    result2.complete(new FileHttpResponse<Object>(request, responseInfo, body));
                }
            });
        }
    }
}

