/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.crypto.BadPaddingException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="CertificateManager", storages={@Storage(value="certificates.xml", roamingType=RoamingType.DISABLED)}, reportStatistic=false, category=SettingsCategory.TOOLS, exportable=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u0002H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0002H\u0016R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\u000f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006$"}, d2={"Lcom/intellij/util/net/ssl/CertificateManager;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/util/net/ssl/CertificateManager$Config;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "config", "trustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager;", "getTrustManager", "()Lcom/intellij/util/net/ssl/ConfirmingTrustManager;", "trustManager$delegate", "Lkotlin/Lazy;", "sslContext", "Ljavax/net/ssl/SSLContext;", "getSslContext", "()Ljavax/net/ssl/SSLContext;", "sslContext$delegate", "computeSslContext", "cacertsPath", "", "getCacertsPath", "()Ljava/lang/String;", "password", "getPassword", "customTrustManager", "Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "getCustomTrustManager", "()Lcom/intellij/util/net/ssl/ConfirmingTrustManager$MutableTrustManager;", "getState", "loadState", "", "state", "Companion", "Config", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nCertificateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateManager.kt\ncom/intellij/util/net/ssl/CertificateManager\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,322:1\n13#2:323\n*S KotlinDebug\n*F\n+ 1 CertificateManager.kt\ncom/intellij/util/net/ssl/CertificateManager\n*L\n105#1:323\n*E\n"})
public final class CertificateManager
implements PersistentStateComponent<Config> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Config config;
    @NotNull
    private final Lazy trustManager$delegate;
    @NotNull
    private final Lazy sslContext$delegate;
    @NotNull
    public static final String COMPONENT_NAME = "Certificate Manager";
    @JvmField
    @NotNull
    public static final String DEFAULT_PATH;
    @NotNull
    public static final String DEFAULT_PASSWORD = "changeit";
    @NotNull
    private static final Logger LOG;
    public static final long DIALOG_VISIBILITY_TIMEOUT = 5000L;

    public CertificateManager(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.config = new Config(false, 1, null);
        this.trustManager$delegate = LazyKt.lazy(CertificateManager::trustManager_delegate$lambda$0);
        this.sslContext$delegate = LazyKt.lazy(() -> CertificateManager.sslContext_delegate$lambda$0(this));
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ CertificateManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SSLContext.setDefault(this.this$0.getSslContext());
                        LOG.info("Default SSL context initialized");
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @NotNull
    public final ConfirmingTrustManager getTrustManager() {
        Lazy lazy = this.trustManager$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (ConfirmingTrustManager)object;
    }

    @NotNull
    public final SSLContext getSslContext() {
        Lazy lazy = this.sslContext$delegate;
        return (SSLContext)lazy.getValue();
    }

    private final SSLContext computeSslContext() {
        SSLContext context = Companion.getSystemSslContext();
        try {
            ConfirmingTrustManager[] confirmingTrustManagerArray = new ConfirmingTrustManager[]{this.getTrustManager()};
            context.init(Companion.getDefaultKeyManagers(), confirmingTrustManagerArray, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        return context;
    }

    @NotNull
    public final String getCacertsPath() {
        return DEFAULT_PATH;
    }

    @NotNull
    public final String getPassword() {
        return DEFAULT_PASSWORD;
    }

    @NotNull
    public final ConfirmingTrustManager.MutableTrustManager getCustomTrustManager() {
        ConfirmingTrustManager.MutableTrustManager mutableTrustManager = this.getTrustManager().getCustomManager();
        Intrinsics.checkNotNullExpressionValue((Object)mutableTrustManager, (String)"getCustomManager(...)");
        return mutableTrustManager;
    }

    @NotNull
    public Config getState() {
        return this.config;
    }

    public void loadState(@NotNull Config state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.config = state;
    }

    private static final ConfirmingTrustManager trustManager_delegate$lambda$0() {
        return ConfirmingTrustManager.createForStorage(CertificateManager.Companion.tryMigratingDefaultTruststore(), DEFAULT_PASSWORD);
    }

    private static final SSLContext sslContext_delegate$lambda$0(CertificateManager this$0) {
        return this$0.computeSslContext();
    }

    @JvmStatic
    @NotNull
    public static final CertificateManager getInstance() {
        return Companion.getInstance();
    }

    @JvmStatic
    @NotNull
    public static final SSLContext getSystemSslContext() {
        return Companion.getSystemSslContext();
    }

    @JvmStatic
    @Nullable
    public static final KeyManager[] getDefaultKeyManagers() {
        return Companion.getDefaultKeyManagers();
    }

    static {
        Path path = PathManager.getOriginalConfigDir().resolve("ssl").resolve("cacerts");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        DEFAULT_PATH = ((Object)path).toString();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CertificateManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\u0005H\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014H\u0007\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u000e\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001b0\u001aH\u0007\u00a2\u0006\u0002\u0010\u001cR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/util/net/ssl/CertificateManager$Companion;", "", "<init>", "()V", "COMPONENT_NAME", "", "Lorg/jetbrains/annotations/NonNls;", "DEFAULT_PATH", "DEFAULT_PASSWORD", "getDEFAULT_PASSWORD$annotations", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DIALOG_VISIBILITY_TIMEOUT", "", "getInstance", "Lcom/intellij/util/net/ssl/CertificateManager;", "tryMigratingDefaultTruststore", "getSystemSslContext", "Ljavax/net/ssl/SSLContext;", "getDefaultKeyManagers", "", "Ljavax/net/ssl/KeyManager;", "()[Ljavax/net/ssl/KeyManager;", "showAcceptDialog", "", "dialogFactory", "Ljava/util/concurrent/Callable;", "Lcom/intellij/openapi/ui/DialogWrapper;", "(Ljava/util/concurrent/Callable;)Ljava/lang/Boolean;", "intellij.platform.ide"})
    @SourceDebugExtension(value={"SMAP\nCertificateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CertificateManager.kt\ncom/intellij/util/net/ssl/CertificateManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,322:1\n30#2,2:323\n*S KotlinDebug\n*F\n+ 1 CertificateManager.kt\ncom/intellij/util/net/ssl/CertificateManager$Companion\n*L\n114#1:323,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public static /* synthetic */ void getDEFAULT_PASSWORD$annotations() {
        }

        @JvmStatic
        @NotNull
        public final CertificateManager getInstance() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$service$iv = (ComponentManager)application;
            boolean $i$f$service = false;
            Class<CertificateManager> serviceClass$iv = CertificateManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CertificateManager)object;
        }

        private final String tryMigratingDefaultTruststore() {
            String[] stringArray = new String[]{"tasks", "cacerts"};
            Path legacySystemPath = Paths.get(PathManager.getSystemPath(), stringArray);
            Path configPath = Paths.get(DEFAULT_PATH, new String[0]);
            if (Files.notExists(configPath, new LinkOption[0]) && Files.exists(legacySystemPath, new LinkOption[0])) {
                LOG.info("Migrating the default truststore from " + legacySystemPath + " to " + configPath);
                try {
                    Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                    try {
                        Path path = Files.move(legacySystemPath, configPath, new CopyOption[0]);
                    }
                    catch (FileAlreadyExistsException ignored) {
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (NoSuchFileException ignored) {
                        Unit unit = Unit.INSTANCE;
                    }
                }
                catch (IOException e) {
                    LOG.error("Cannot move the default truststore from " + legacySystemPath + " to " + configPath, (Throwable)e);
                    return ((Object)legacySystemPath).toString();
                }
            }
            return DEFAULT_PATH;
        }

        @JvmStatic
        @NotNull
        public final SSLContext getSystemSslContext() {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, null, null);
                Intrinsics.checkNotNull((Object)context);
                return context;
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Throwable)e);
                throw new AssertionError((Object)"Cannot get system SSL context");
            }
            catch (KeyManagementException e) {
                LOG.error((Throwable)e);
                throw new AssertionError((Object)"Cannot initialize system SSL context");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @Nullable
        public final KeyManager[] getDefaultKeyManagers() {
            String string = System.getProperty("javax.net.ssl.keyStore");
            if (string == null) {
                return null;
            }
            String keyStorePath = string;
            LOG.info("Loading custom key store specified with VM options: " + keyStorePath);
            try {
                KeyStore keyStore;
                KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                String keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
                try {
                    keyStore = KeyStore.getInstance(keyStoreType);
                }
                catch (KeyStoreException e) {
                    if (e.getCause() instanceof NoSuchAlgorithmException) {
                        LOG.error("Wrong key store type: " + keyStoreType, (Throwable)e);
                        return null;
                    }
                    throw e;
                }
                KeyStore keyStore2 = keyStore;
                Path keyStoreFile = Paths.get(keyStorePath, new String[0]);
                String password = null;
                String string2 = password = System.getProperty("javax.net.ssl.keyStorePassword", "");
                Intrinsics.checkNotNull((Object)string2);
                if (((CharSequence)string2).length() == 0 && SystemInfoRt.isMac) {
                    try {
                        String string3 = FileUtilRt.getNameWithoutExtension((String)((Object)keyStoreFile.getFileName()).toString());
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getNameWithoutExtension(...)");
                        String itemName = string3;
                        password = PasswordSafe.Companion.getInstance().getPassword(new CredentialAttributes(itemName, itemName));
                        if (password == null) {
                            password = "";
                        }
                    }
                    catch (Throwable e) {
                        LOG.error("Cannot get password for " + keyStorePath, e);
                    }
                }
                try {
                    Closeable e = Files.newInputStream(keyStoreFile, new OpenOption[0]);
                    Throwable throwable = null;
                    try {
                        InputStream inputStream = (InputStream)e;
                        boolean bl = false;
                        String string4 = password;
                        Intrinsics.checkNotNull((Object)string4);
                        char[] cArray = string4.toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                        keyStore2.load(inputStream, cArray);
                        char[] cArray2 = password.toCharArray();
                        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
                        factory.init(keyStore2, cArray2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
                    }
                }
                catch (NoSuchFileException e) {
                    LOG.error("Key store file not found: " + keyStorePath);
                    return null;
                }
                catch (Exception e) {
                    if (e.getCause() instanceof BadPaddingException || e.getCause() instanceof UnrecoverableKeyException) {
                        Logger logger = LOG;
                        String string5 = password;
                        Intrinsics.checkNotNull((Object)string5);
                        String string6 = string5;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                        byte[] byArray = string6.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                        logger.error("Wrong key store password (sha-256): " + DigestUtil.sha256Hex((byte[])byArray), (Throwable)e);
                        return null;
                    }
                    throw e;
                }
                return factory.getKeyManagers();
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        @ApiStatus.Internal
        @Nullable
        public final Boolean showAcceptDialog(@NotNull Callable<? extends DialogWrapper> dialogFactory) {
            Intrinsics.checkNotNullParameter(dialogFactory, (String)"dialogFactory");
            Application app = ApplicationManager.getApplication();
            AtomicBoolean shouldShow = new AtomicBoolean(true);
            CountDownLatch finishedShowing = new CountDownLatch(1);
            AtomicReference accepted = new AtomicReference();
            AtomicReference dialogRef = new AtomicReference();
            Runnable showDialog = () -> Companion.showAcceptDialog$lambda$0(shouldShow, dialogFactory, dialogRef, accepted, finishedShowing);
            if (app.isDispatchThread()) {
                showDialog.run();
            } else {
                app.invokeLater(showDialog, ModalityState.any());
            }
            try {
                boolean inTime = finishedShowing.await(5000L, TimeUnit.MILLISECONDS);
                if (!inTime && shouldShow.compareAndSet(true, false)) {
                    LOG.debug("After 5000 ms dialog was not shown. Rejecting certificate. Current thread: " + Thread.currentThread().getName());
                    return null;
                }
                finishedShowing.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                shouldShow.set(false);
            }
            return (Boolean)accepted.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void showAcceptDialog$lambda$0(AtomicBoolean $shouldShow, Callable $dialogFactory, AtomicReference $dialogRef, AtomicReference $accepted, CountDownLatch $finishedShowing) {
            try {
                if (!$shouldShow.compareAndSet(true, false)) {
                    return;
                }
                DialogWrapper dialog = (DialogWrapper)$dialogFactory.call();
                $dialogRef.set(dialog);
                $accepted.set(dialog.showAndGet());
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
            finally {
                $finishedShowing.countDown();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0006\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\b\u001a\u00020\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\n\u001a\u00020\u000bH\u00d6\u0081\u0004J\n\u0010\f\u001a\u00020\rH\u00d6\u0081\u0004R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/util/net/ssl/CertificateManager$Config;", "", "ACCEPT_AUTOMATICALLY", "", "<init>", "(Z)V", "component1", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ide"})
    public static final class Config {
        @JvmField
        public boolean ACCEPT_AUTOMATICALLY;

        public Config(boolean ACCEPT_AUTOMATICALLY) {
            this.ACCEPT_AUTOMATICALLY = ACCEPT_AUTOMATICALLY;
        }

        public /* synthetic */ Config(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean component1() {
            return this.ACCEPT_AUTOMATICALLY;
        }

        @NotNull
        public final Config copy(boolean ACCEPT_AUTOMATICALLY) {
            return new Config(ACCEPT_AUTOMATICALLY);
        }

        public static /* synthetic */ Config copy$default(Config config, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = config.ACCEPT_AUTOMATICALLY;
            }
            return config.copy(bl);
        }

        @NotNull
        public String toString() {
            return "Config(ACCEPT_AUTOMATICALLY=" + this.ACCEPT_AUTOMATICALLY + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.ACCEPT_AUTOMATICALLY);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Config)) {
                return false;
            }
            Config config = (Config)other;
            return this.ACCEPT_AUTOMATICALLY == config.ACCEPT_AUTOMATICALLY;
        }

        public Config() {
            this(false, 1, null);
        }
    }
}

