/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.ClassMetadata;
import com.intellij.rt.coverage.data.NameEnumerator;
import com.intellij.rt.coverage.data.TestDiscoveryDataListener;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntIntHashMap;
import org.jetbrains.coverage.gnu.trove.TIntIntIterator;

public abstract class TestDiscoveryProtocolDataListener
implements TestDiscoveryDataListener {
    public static final int START_MARKER = 1;
    public static final int FINISH_MARKER = 0;
    public static final int NAMES_DICTIONARY_PART_MARKER = 2;
    public static final int TEST_FINISHED_MARKER = 3;
    public static final int METADATA_MARKER = 5;
    public static final int CLASS_METADATA_MARKER = 6;
    protected final byte myVersion;

    /*
     * WARNING - void declaration
     */
    public TestDiscoveryProtocolDataListener(byte version) {
        void var1_1;
        this.myVersion = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void writeTestFinished(DataOutput output, String className, String methodName, Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, List<int[]> openedFiles) throws IOException {
        void var1_1;
        void var3_5;
        void var2_3;
        NameEnumerator.Incremental nameEnumerator = this.getNameEnumerator();
        int testClassNameId = nameEnumerator.enumerate(className);
        int testMethodNameId = nameEnumerator.enumerate(methodName);
        this.writeDictionaryIncrementIfNeeded(output);
        output.writeByte(3);
        CoverageIOUtil.writeINT(output, (int)var2_3);
        CoverageIOUtil.writeINT(output, (int)var3_5);
        this.writeVisitedMethod(classToVisitedMethods, classToMethodNames, output);
        this.writeAffectedFiles((DataOutput)var1_1, openedFiles);
    }

    /*
     * WARNING - void declaration
     */
    private void writeAffectedFiles(DataOutput output, List<int[]> files) throws IOException {
        Iterator iterator;
        if (this.myVersion < 3) {
            return;
        }
        CoverageIOUtil.writeINT(output, files.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            int[] file = (int[])iterator.next();
            CoverageIOUtil.writeINT(output, file.length);
            for (void i : var3_3) {
                CoverageIOUtil.writeINT(output, (int)i);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void start(DataOutput output) throws IOException {
        void var1_1;
        output.writeByte(1);
        var1_1.writeByte(this.myVersion);
    }

    protected void finish(DataOutput output) throws IOException {
        output.writeByte(0);
    }

    @Override
    public abstract NameEnumerator.Incremental getNameEnumerator();

    /*
     * WARNING - void declaration
     */
    protected void writeDictionaryIncrementIfNeeded(DataOutput output) throws IOException {
        void var2_2;
        void var1_1;
        List<NameEnumerator.Incremental.NameAndId> increment = this.getNameEnumerator().getAndClearDataIncrement();
        if (increment.isEmpty()) {
            return;
        }
        output.writeByte(2);
        this.writeEnumeratorIncrement((DataOutput)var1_1, (List<NameEnumerator.Incremental.NameAndId>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected void writeEnumeratorIncrement(DataOutput output, List<NameEnumerator.Incremental.NameAndId> increment) throws IOException {
        Iterator iterator;
        CoverageIOUtil.writeINT(output, increment.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            NameEnumerator.Incremental.NameAndId nameAndId = (NameEnumerator.Incremental.NameAndId)iterator.next();
            CoverageIOUtil.writeINT(output, nameAndId.getId());
            CoverageIOUtil.writeUTF(output, var3_3.getName());
        }
    }

    protected void writeVisitedMethod(Map<Integer, boolean[]> classToVisitedMethods, Map<Integer, int[]> classToMethodNames, DataOutput os) throws IOException {
        int usedMethodsCount;
        TIntIntHashMap classToUsedMethods = new TIntIntHashMap();
        for (Map.Entry<Integer, boolean[]> o : classToVisitedMethods.entrySet()) {
            boolean[] used22 = o.getValue();
            usedMethodsCount = 0;
            boolean[] blArray = used22;
            int used22 = used22.length;
            for (int i = 0; i < used22; ++i) {
                boolean bl = blArray[i];
                if (!bl) continue;
                ++usedMethodsCount;
            }
            if (usedMethodsCount <= 0) continue;
            classToUsedMethods.put(o.getKey(), usedMethodsCount);
        }
        int size = classToUsedMethods.size();
        CoverageIOUtil.writeINT(os, size);
        if (size == 0) {
            return;
        }
        TIntIntIterator iterator = classToUsedMethods.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            int className = iterator.key();
            usedMethodsCount = iterator.value();
            CoverageIOUtil.writeINT(os, className);
            CoverageIOUtil.writeINT(os, usedMethodsCount);
            int[] methodNames = classToMethodNames.get(className);
            boolean[] used = classToVisitedMethods.get(className);
            int len = used.length;
            for (int i = 0; i < len; ++i) {
                if (!used[i] || usedMethodsCount-- <= 0) continue;
                CoverageIOUtil.writeINT(os, methodNames[i]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeMetadata(DataOutput os, Map<String, String> metadata) throws IOException {
        Iterator iterator;
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(metadata);
        os.writeByte(5);
        CoverageIOUtil.writeINT(os, map.size());
        for (Map.Entry entry : ((LinkedHashMap)((Object)iterator)).entrySet()) {
            void var3_3;
            CoverageIOUtil.writeUTF(os, (String)entry.getKey());
            CoverageIOUtil.writeUTF(os, (String)var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void writeClassMetadata(DataOutput os, List<ClassMetadata> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            return;
        }
        if (this.myVersion < 2) {
            return;
        }
        NameEnumerator.Incremental enumerator = this.getNameEnumerator();
        Iterator<Object> iterator = metadata.iterator();
        while (iterator.hasNext()) {
            ClassMetadata data = (ClassMetadata)iterator.next();
            enumerator.enumerate(data.getFqn());
            if (data.getFiles() != null) {
                for (String file : data.getFiles()) {
                    enumerator.enumerate(file);
                }
            }
            if (data.getMethods() == null) continue;
            for (String method : data.getMethods().keySet()) {
                enumerator.enumerate(method);
            }
        }
        this.writeDictionaryIncrementIfNeeded(os);
        ArrayList list = new ArrayList(metadata);
        os.writeByte(6);
        CoverageIOUtil.writeINT(os, list.size());
        for (ClassMetadata data : list) {
            CoverageIOUtil.writeINT(os, enumerator.enumerate(data.getFqn()));
            List<String> files = data.getFiles();
            if (files == null) {
                CoverageIOUtil.writeINT(os, 0);
            } else {
                CoverageIOUtil.writeINT(os, files.size());
                for (String file : files) {
                    CoverageIOUtil.writeINT(os, enumerator.enumerate(file));
                }
            }
            Map<String, byte[]> methods = data.getMethods();
            if (methods == null) {
                CoverageIOUtil.writeINT(os, 0);
                continue;
            }
            CoverageIOUtil.writeINT(os, methods.size());
            for (Map.Entry method : methods.entrySet()) {
                void var2_8;
                CoverageIOUtil.writeINT(os, enumerator.enumerate((String)method.getKey()));
                CoverageIOUtil.writeINT(os, ((byte[])method.getValue()).length);
                os.write((byte[])var2_8.getValue());
            }
        }
    }
}

