/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassWriter;

class ClassWriterImpl
extends ClassWriter {
    private final ClassLoader myClassLoader;
    private final Map<ClassLoader, Map<String, ClassReader>> myClassReaders;

    /*
     * WARNING - void declaration
     */
    ClassWriterImpl(int flags, ClassLoader classLoader, Map<ClassLoader, Map<String, ClassReader>> classReaders) {
        super((int)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.myClassLoader = var2_2;
        this.myClassReaders = var3_3;
    }

    @Override
    protected ClassLoader getClassLoader() {
        if (this.myClassLoader != null) {
            return this.myClassLoader;
        }
        return super.getClassLoader();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getCommonSuperClass(String type1, String type2) {
        try {
            String result;
            block8: {
                ClassReader info1 = this.getOrLoadClassReader(type1);
                ClassReader info2 = this.getOrLoadClassReader(type2);
                String superType = this.checkImplementInterface(type1, type2, info1, info2);
                if (superType != null) {
                    return superType;
                }
                superType = this.checkImplementInterface(type2, type1, info2, info1);
                if (superType != null) {
                    return superType;
                }
                StringBuilder b1 = this.typeAncestors(type1, info1);
                StringBuilder b2 = this.typeAncestors(type2, info2);
                result = "java/lang/Object";
                int end1 = b1.length();
                int end2 = b2.length();
                while (true) {
                    String p2;
                    int start1 = b1.lastIndexOf(";", end1 - 1);
                    int start2 = b2.lastIndexOf(";", end2 - 1);
                    if (start1 == -1 || start2 == -1 || end1 - start1 != end2 - start2) break block8;
                    String p1 = b1.substring(start1 + 1, end1);
                    if (!p1.equals(p2 = b2.substring(start2 + 1, end2))) break;
                    result = p1;
                    int n = start1;
                    int n2 = start2;
                }
                return result;
            }
            return result;
        }
        catch (FrameComputationClassNotFoundException e) {
            try {
                void var2_2;
                void var1_1;
                return super.getCommonSuperClass((String)var1_1, (String)var2_2);
            }
            catch (TypeNotPresentException typeNotPresentException) {
                throw e;
            }
        }
        catch (IOException e) {
            void var3_5;
            throw new RuntimeException(var3_5.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private String checkImplementInterface(String type1, String type2, ClassReader info1, ClassReader info2) throws IOException {
        if ((info1.getAccess() & 0x200) != 0) {
            void var2_2;
            if (this.typeImplements((String)var2_2, info2, type1)) {
                void var1_1;
                return var1_1;
            }
            return "java/lang/Object";
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private StringBuilder typeAncestors(String type, ClassReader info) throws IOException {
        void var3_3;
        StringBuilder b = new StringBuilder();
        while (!"java/lang/Object".equals(type)) {
            b.append(';').append(type);
            type = info.getSuperName();
            info = this.getOrLoadClassReader(type);
        }
        return var3_3;
    }

    private boolean typeImplements(String type, ClassReader classReader, String interfaceName) throws IOException {
        while (!"java/lang/Object".equals(type)) {
            String string;
            String[] interfaces;
            String[] stringArray = interfaces = classReader.getInterfaces();
            int n = interfaces.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                if (!string2.equals(interfaceName)) continue;
                return true;
            }
            for (String itf : string) {
                if (!this.typeImplements(itf, this.getOrLoadClassReader(itf), interfaceName)) continue;
                return true;
            }
            string = classReader.getSuperName();
            classReader = this.getOrLoadClassReader(string);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized ClassReader getOrLoadClassReader(String className) throws IOException {
        ClassReader classReader;
        ClassReader classReader2;
        Map<String, ClassReader> loaderClassReaders = this.myClassReaders.get(this.myClassLoader);
        if (loaderClassReaders == null) {
            loaderClassReaders = new HashMap<String, ClassReader>();
            this.myClassReaders.put(this.myClassLoader, loaderClassReaders);
        }
        if ((classReader2 = loaderClassReaders.get(className)) == null) {
            InputStream is = null;
            try {
                void var1_1;
                void var2_3;
                String resource = className + ".class";
                if (this.myClassLoader != null) {
                    is = this.myClassLoader.getResourceAsStream(resource);
                }
                if (is == null) {
                    is = ClassLoader.getSystemResourceAsStream((String)((Object)classReader));
                }
                if (is == null) {
                    throw new FrameComputationClassNotFoundException("Class " + className + " not found");
                }
                classReader = new ClassReader(is);
                var2_3.put(var1_1, classReader);
            }
            catch (Throwable throwable) {
                CoverageIOUtil.close(is);
                throw throwable;
            }
            CoverageIOUtil.close(is);
        }
        return classReader;
    }

    static class FrameComputationClassNotFoundException
    extends RuntimeException {
        /*
         * WARNING - void declaration
         */
        public FrameComputationClassNotFoundException(String message) {
            super((String)var1_1);
            void var1_1;
        }
    }
}

