/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.target;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.text.StringKt;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.tooling.ResultHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleServerEnvironmentSetup;
import org.jetbrains.plugins.gradle.execution.target.GradleServerProgressIndicator;
import org.jetbrains.plugins.gradle.execution.target.GradleServerRunner;
import org.jetbrains.plugins.gradle.execution.target.ToolingProxyConnector;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\u001b\u0010\u001b\u001a\u00020\u0014*\u00020\u001c2\r\u0010\u001d\u001a\t\u0018\u00010\u001e\u00a2\u0006\u0002\b\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProcessListener;", "Lcom/intellij/execution/process/ProcessListener;", "targetProgressIndicator", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProgressIndicator;", "serverEnvironmentSetup", "Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;", "resultHandler", "Lorg/gradle/tooling/ResultHandler;", "", "connectorFactory", "Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector$ToolingProxyConnectorFactory;", "buildEventConsumer", "Lorg/gradle/initialization/BuildEventConsumer;", "<init>", "(Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProgressIndicator;Lorg/jetbrains/plugins/gradle/execution/target/GradleServerEnvironmentSetup;Lorg/gradle/tooling/ResultHandler;Lorg/jetbrains/plugins/gradle/execution/target/ToolingProxyConnector$ToolingProxyConnectorFactory;Lorg/gradle/initialization/BuildEventConsumer;)V", "listenerJob", "Ljava/util/concurrent/Future;", "connectionAddressReceived", "Ljava/util/concurrent/atomic/AtomicBoolean;", "waitForServerShutdown", "", "processTerminated", "event", "Lcom/intellij/execution/process/ProcessEvent;", "onTextAvailable", "outputType", "Lcom/intellij/openapi/util/Key;", "traceIfNotEmpty", "Lcom/intellij/openapi/diagnostic/Logger;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "runListener", "host", "port", "", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nGradleServerProcessListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleServerProcessListener.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerProcessListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,91:1\n1#2:92\n67#3,4:93\n13#3:97\n*S KotlinDebug\n*F\n+ 1 GradleServerProcessListener.kt\norg/jetbrains/plugins/gradle/execution/target/GradleServerProcessListener\n*L\n70#1:93,4\n35#1:97\n*E\n"})
public final class GradleServerProcessListener
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GradleServerProgressIndicator targetProgressIndicator;
    @NotNull
    private final GradleServerEnvironmentSetup serverEnvironmentSetup;
    @NotNull
    private final ResultHandler<Object> resultHandler;
    @NotNull
    private final ToolingProxyConnector.ToolingProxyConnectorFactory connectorFactory;
    @NotNull
    private final BuildEventConsumer buildEventConsumer;
    @Nullable
    private volatile Future<?> listenerJob;
    @NotNull
    private final AtomicBoolean connectionAddressReceived;
    @NotNull
    private static final String CONNECTION_CONF_LINE_PREFIX = "Gradle target server hostAddress: ";
    @NotNull
    private static final Logger log;

    public GradleServerProcessListener(@NotNull GradleServerProgressIndicator targetProgressIndicator, @NotNull GradleServerEnvironmentSetup serverEnvironmentSetup, @NotNull ResultHandler<Object> resultHandler, @NotNull ToolingProxyConnector.ToolingProxyConnectorFactory connectorFactory, @NotNull BuildEventConsumer buildEventConsumer) {
        Intrinsics.checkNotNullParameter((Object)targetProgressIndicator, (String)"targetProgressIndicator");
        Intrinsics.checkNotNullParameter((Object)serverEnvironmentSetup, (String)"serverEnvironmentSetup");
        Intrinsics.checkNotNullParameter(resultHandler, (String)"resultHandler");
        Intrinsics.checkNotNullParameter((Object)connectorFactory, (String)"connectorFactory");
        Intrinsics.checkNotNullParameter((Object)buildEventConsumer, (String)"buildEventConsumer");
        this.targetProgressIndicator = targetProgressIndicator;
        this.serverEnvironmentSetup = serverEnvironmentSetup;
        this.resultHandler = resultHandler;
        this.connectorFactory = connectorFactory;
        this.buildEventConsumer = buildEventConsumer;
        this.connectionAddressReceived = new AtomicBoolean(false);
    }

    @RequiresBackgroundThread
    public final void waitForServerShutdown() {
        block0: {
            Future<?> future = this.listenerJob;
            if (future == null) break block0;
            future.get();
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        ProcessOutputType outputType;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        ProcessOutputType processOutputType = outputType = event.getExitCode() == 0 ? ProcessOutputType.STDOUT : ProcessOutputType.STDERR;
        if (event.getText() != null) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            Intrinsics.checkNotNull((Object)outputType);
            this.targetProgressIndicator.addText(string, (Key)outputType);
        }
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        this.traceIfNotEmpty(log, event.getText());
        if (this.connectionAddressReceived.get()) {
            return;
        }
        if (outputType == ProcessOutputTypes.STDERR) {
            String string = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            this.targetProgressIndicator.addText(string, outputType);
        }
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.startsWith$default((String)string, (String)CONNECTION_CONF_LINE_PREFIX, (boolean)false, (int)2, null) && this.connectionAddressReceived.compareAndSet(false, true)) {
            String string2 = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            String hostName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)string2, (String)CONNECTION_CONF_LINE_PREFIX, null, (int)2, null), (String)" port: ", null, (int)2, null);
            String string3 = event.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            int port = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)string3, (String)" port: ", null, (int)2, null))).toString());
            this.runListener(hostName, port);
        }
    }

    private final void traceIfNotEmpty(Logger $this$traceIfNotEmpty, String text) {
        block1: {
            String string;
            String string2 = StringKt.nullize((String)text, (boolean)true);
            if (string2 == null) break block1;
            String it = string = string2;
            boolean bl = false;
            Logger $this$trace$iv = $this$traceIfNotEmpty;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl2 = false;
                logger.trace(((Object)StringsKt.trimEnd((CharSequence)it)).toString());
            }
        }
    }

    private final void runListener(String host, int port) {
        this.listenerJob = ApplicationManager.getApplication().executeOnPooledThread(() -> GradleServerProcessListener.runListener$lambda$0(this, host, port));
    }

    private static final void runListener$lambda$0$0(GradleServerProcessListener this$0, String $host, int $port) {
        ToolingProxyConnector toolingProxyConnection = this$0.connectorFactory.getConnector($host, $port);
        toolingProxyConnection.collectAllEvents(this$0.serverEnvironmentSetup.getTargetBuildParameters(), this$0.resultHandler, this$0.buildEventConsumer, this$0.serverEnvironmentSetup.getTargetIntermediateResultHandler());
    }

    private static final void runListener$lambda$0(GradleServerProcessListener this$0, String $host, int $port) {
        ProgressManager.getInstance().executeProcessUnderProgress(() -> GradleServerProcessListener.runListener$lambda$0$0(this$0, $host, $port), this$0.targetProgressIndicator.getProgressIndicator());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleServerRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/gradle/execution/target/GradleServerProcessListener$Companion;", "", "<init>", "()V", "CONNECTION_CONF_LINE_PREFIX", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

