/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.execution;

import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.util.GradleVersion;
import org.gradle.wrapper.PathAssembler;
import org.gradle.wrapper.WrapperConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.execution.target.GradleTargetUtil;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.service.execution.BuildLayoutParameters;
import org.jetbrains.plugins.gradle.service.execution.GradleUserHomeUtil;
import org.jetbrains.plugins.gradle.service.execution.LocalGradleExecutionAware;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleLocalSettings;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.gradle.util.GradleUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0010\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014J\r\u0010\u0018\u001a\u00070\u0019\u00a2\u0006\u0002\b\u001aH\u0002J\n\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0017H\u0002J\n\u0010#\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\u000e\u001a\u0004\u0018\u00010\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\r\u001a\u0004\b\u0010\u0010\u0011R!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\r\u001a\u0004\b\u0014\u0010\u000bR\u001d\u0010\u001b\u001a\u0004\u0018\u00010\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\r\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters;", "Lorg/jetbrains/plugins/gradle/service/execution/BuildLayoutParameters;", "project", "Lcom/intellij/openapi/project/Project;", "projectPath", "Ljava/nio/file/Path;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/nio/file/Path;)V", "gradleHome", "Lcom/intellij/execution/target/value/TargetValue;", "getGradleHome", "()Lcom/intellij/execution/target/value/TargetValue;", "gradleHome$delegate", "Lkotlin/Lazy;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradleVersion$delegate", "gradleUserHomePath", "getGradleUserHomePath", "gradleUserHomePath$delegate", "getGradleProjectSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleProjectSettings;", "getGradleSettings", "Lorg/jetbrains/plugins/gradle/settings/GradleSettings;", "Lorg/jetbrains/annotations/NotNull;", "wrapperConfiguration", "Lorg/gradle/wrapper/WrapperConfiguration;", "getWrapperConfiguration", "()Lorg/gradle/wrapper/WrapperConfiguration;", "wrapperConfiguration$delegate", "findGradleHome", "tryToFindGradleInstallation", "gradleProjectSettings", "guessGradleVersion", "findGradleUserHomeDir", "Companion", "intellij.gradle"})
@SourceDebugExtension(value={"SMAP\nLocalBuildLayoutParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n1#2:130\n13#3:131\n*S KotlinDebug\n*F\n+ 1 LocalBuildLayoutParameters.kt\norg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters\n*L\n127#1:131\n*E\n"})
public class LocalBuildLayoutParameters
implements BuildLayoutParameters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Path projectPath;
    @NotNull
    private final Lazy gradleHome$delegate;
    @NotNull
    private final Lazy gradleVersion$delegate;
    @NotNull
    private final Lazy gradleUserHomePath$delegate;
    @NotNull
    private final Lazy wrapperConfiguration$delegate;
    @NotNull
    private static final Logger log;

    public LocalBuildLayoutParameters(@NotNull Project project, @Nullable Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.projectPath = projectPath;
        this.gradleHome$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleHome_delegate$lambda$0(this));
        this.gradleVersion$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleVersion_delegate$lambda$0(this));
        this.gradleUserHomePath$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.gradleUserHomePath_delegate$lambda$0(this));
        this.wrapperConfiguration$delegate = LazyKt.lazy(() -> LocalBuildLayoutParameters.wrapperConfiguration_delegate$lambda$0(this));
    }

    @Override
    @Nullable
    public TargetValue<Path> getGradleHome() {
        Lazy lazy = this.gradleHome$delegate;
        return (TargetValue)lazy.getValue();
    }

    @Override
    @Nullable
    public GradleVersion getGradleVersion() {
        Lazy lazy = this.gradleVersion$delegate;
        return (GradleVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public TargetValue<Path> getGradleUserHomePath() {
        Lazy lazy = this.gradleUserHomePath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (TargetValue)object;
    }

    @Nullable
    protected GradleProjectSettings getGradleProjectSettings() {
        GradleProjectSettings gradleProjectSettings;
        Path path = this.projectPath;
        if (path != null) {
            Path it = path;
            boolean bl = false;
            gradleProjectSettings = (GradleProjectSettings)this.getGradleSettings().getLinkedProjectSettings(NioPathUtil.toCanonicalPath((Path)it));
        } else {
            gradleProjectSettings = null;
        }
        return gradleProjectSettings;
    }

    private final GradleSettings getGradleSettings() {
        GradleSettings gradleSettings = GradleSettings.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleSettings), (String)"getInstance(...)");
        return gradleSettings;
    }

    private final WrapperConfiguration getWrapperConfiguration() {
        Lazy lazy = this.wrapperConfiguration$delegate;
        return (WrapperConfiguration)lazy.getValue();
    }

    private final Path findGradleHome() {
        Path path;
        GradleProjectSettings gradleProjectSettings = this.getGradleProjectSettings();
        if (gradleProjectSettings == null) {
            return null;
        }
        GradleProjectSettings gradleProjectSettings2 = gradleProjectSettings;
        DistributionType distributionType = gradleProjectSettings2.getDistributionType();
        switch (distributionType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[distributionType.ordinal()]) {
            case -1: {
                path = GradleInstallationManager.Companion.getInstance().getAutodetectedGradleHome(this.project);
                break;
            }
            case 3: {
                path = gradleProjectSettings2.getGradleHomePath();
                break;
            }
            case 4: {
                Path path2;
                Path path3 = this.projectPath;
                String projectNioPath = path3 != null ? NioPathUtil.toCanonicalPath((Path)path3) : null;
                GradleLocalSettings gradleLocalSettings = GradleLocalSettings.getInstance(this.project);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gradleLocalSettings), (String)"getInstance(...)");
                GradleLocalSettings localSettings = gradleLocalSettings;
                String string = localSettings.getGradleHome(projectNioPath);
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    path2 = Path.of(it, new String[0]);
                } else {
                    path2 = null;
                }
                return path2;
            }
            default: {
                path = this.tryToFindGradleInstallation(gradleProjectSettings2);
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Path tryToFindGradleInstallation(GradleProjectSettings gradleProjectSettings) {
        if (this.getWrapperConfiguration() == null) {
            return null;
        }
        Path path = GradleTargetUtil.maybeGetLocalValue(this.getGradleUserHomePath());
        if (path == null) {
            return null;
        }
        Path localGradleUserHome = path;
        PathAssembler.LocalDistribution localDistribution = new PathAssembler(localGradleUserHome.toFile(), new File(gradleProjectSettings.getExternalProjectPath())).getDistribution(this.getWrapperConfiguration());
        Path path2 = localDistribution.getDistributionDir().toPath();
        if (path2 == null) {
            return null;
        }
        Path distributionDir = path2;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(distributionDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        try {
            List list;
            AutoCloseable autoCloseable = Files.list(distributionDir);
            Throwable throwable = null;
            try {
                Stream it = (Stream)autoCloseable;
                boolean bl = false;
                list = ((Stream)it.filter(arg_0 -> LocalBuildLayoutParameters.tryToFindGradleInstallation$lambda$0$1(LocalBuildLayoutParameters::tryToFindGradleInstallation$lambda$0$0, arg_0)).unordered()).limit(2L).toList();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            List dirs = list;
            if (dirs.size() == 1) {
                Intrinsics.checkNotNull(dirs);
                return (Path)CollectionsKt.first(dirs);
            }
        }
        catch (Exception e) {
            log.debug("Can not find Gradle installation inside " + distributionDir, (Throwable)e);
        }
        return null;
    }

    private final GradleVersion guessGradleVersion() {
        Object object = this.getGradleProjectSettings();
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 2: {
                return GradleVersion.current();
            }
            case 3: {
                GradleVersion gradleVersion;
                TargetValue<Path> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.Companion.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u240 = string;
                    boolean bl = false;
                    gradleVersion = GradleInstallationManager.Companion.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u240);
                } else {
                    gradleVersion = null;
                }
                return gradleVersion;
            }
            case 1: {
                GradleVersion gradleVersion;
                TargetValue<Path> targetValue = this.getGradleHome();
                String string = GradleInstallationManager.Companion.getGradleVersion(targetValue != null ? GradleTargetUtil.maybeGetLocalValue(targetValue) : null);
                if (string != null) {
                    String $this$guessGradleVersion_u24lambda_u241 = string;
                    boolean bl = false;
                    v6 = GradleInstallationManager.Companion.getGradleVersionSafe($this$guessGradleVersion_u24lambda_u241);
                } else {
                    v6 = gradleVersion = null;
                }
                if (gradleVersion == null) {
                    String path;
                    Object object2 = this.getWrapperConfiguration();
                    String string2 = object2 != null && (object2 = object2.getDistribution()) != null ? ((URI)object2).getRawPath() : (path = null);
                    if (path == null) break;
                    return GradleInstallationManager.Companion.parseDistributionVersion(path);
                }
                return gradleVersion;
            }
            case 4: {
                return null;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    private final Path findGradleUserHomeDir(Project project) {
        Path maybeGradleUserHome;
        if (this.projectPath == null) {
            EelDescriptor descriptor = project.isDefault() ? (EelDescriptor)LocalEelDescriptor.INSTANCE : EelProviderUtil.getEelDescriptor((Project)project);
            return GradleUserHomeUtil.gradleUserHomeDir(descriptor);
        }
        String string = this.getGradleSettings().getServiceDirectoryPath();
        if (string != null) {
            String it = string;
            boolean bl = false;
            v1 = Path.of(it, new String[0]);
        } else {
            v1 = maybeGradleUserHome = null;
        }
        if (maybeGradleUserHome != null) {
            return maybeGradleUserHome;
        }
        return GradleUserHomeUtil.gradleUserHomeDir(EelProviderUtil.getEelDescriptor((Path)this.projectPath));
    }

    private static final TargetValue gradleHome_delegate$lambda$0(LocalBuildLayoutParameters this$0) {
        TargetValue targetValue;
        Path path = this$0.findGradleHome();
        if (path != null) {
            Path it = path;
            boolean bl = false;
            targetValue = TargetValue.fixed((Object)it);
        } else {
            targetValue = null;
        }
        return targetValue;
    }

    private static final GradleVersion gradleVersion_delegate$lambda$0(LocalBuildLayoutParameters this$0) {
        return this$0.guessGradleVersion();
    }

    private static final TargetValue gradleUserHomePath_delegate$lambda$0(LocalBuildLayoutParameters this$0) {
        return TargetValue.fixed((Object)this$0.findGradleUserHomeDir(this$0.project));
    }

    private static final WrapperConfiguration wrapperConfiguration_delegate$lambda$0(LocalBuildLayoutParameters this$0) {
        Object object = this$0.getGradleProjectSettings();
        if (object == null || (object = object.getDistributionType()) == null) {
            return null;
        }
        GradleProjectSettings distributionType = object;
        return switch (WhenMappings.$EnumSwitchMapping$0[((Enum)((Object)distributionType)).ordinal()]) {
            case 1 -> GradleUtil.getWrapperConfiguration(this$0.projectPath);
            case 2 -> {
                WrapperConfiguration var2_2;
                WrapperConfiguration $this$wrapperConfiguration_delegate_u24lambda_u240_u240 = var2_2 = new WrapperConfiguration();
                boolean $i$a$-apply-LocalBuildLayoutParameters$wrapperConfiguration$2$1 = false;
                $this$wrapperConfiguration_delegate_u24lambda_u240_u240.setDistribution(GradleUtil.getWrapperDistributionUri(GradleVersion.current()));
                yield var2_2;
            }
            default -> null;
        };
    }

    private static final boolean tryToFindGradleInstallation$lambda$0$0(Path it) {
        Intrinsics.checkNotNull((Object)it);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
    }

    private static final boolean tryToFindGradleInstallation$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LocalGradleExecutionAware.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/gradle/service/execution/LocalBuildLayoutParameters$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.DEFAULT_WRAPPED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.BUNDLED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.WRAPPED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

