/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueIdentifier;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueList;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "findClosestListElement", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOptionValueIdentifier;", "list", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigOptionValueList;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigRemoveUnexpectedValuesQuickFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigRemoveUnexpectedValuesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,37:1\n2469#2,14:38\n*S KotlinDebug\n*F\n+ 1 EditorConfigRemoveUnexpectedValuesQuickFix.kt\norg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveUnexpectedValuesQuickFix\n*L\n31#1:38,14\n*E\n"})
public final class EditorConfigRemoveUnexpectedValuesQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.list.remove.others", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueList");
        EditorConfigOptionValueList list = (EditorConfigOptionValueList)psiElement;
        EditorConfigOptionValueIdentifier editorConfigOptionValueIdentifier = this.findClosestListElement(list);
        if (editorConfigOptionValueIdentifier == null) {
            return;
        }
        EditorConfigOptionValueIdentifier identifier = editorConfigOptionValueIdentifier;
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        String string = identifier.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        EditorConfigOptionValueIdentifier replacement = factory.createValueIdentifier((CharSequence)string);
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> EditorConfigRemoveUnexpectedValuesQuickFix.applyFix$lambda$0(list, replacement));
    }

    private final EditorConfigOptionValueIdentifier findClosestListElement(EditorConfigOptionValueList list) {
        Object v2;
        Editor editor = FileEditorManager.getInstance((Project)list.getProject()).getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        Editor editor2 = editor;
        List list2 = list.getOptionValueIdentifierList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOptionValueIdentifierList(...)");
        Iterable $this$minByOrNull$iv = list2;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = minElem$iv;
            } else {
                PsiElement element = (PsiElement)minElem$iv;
                boolean bl = false;
                int minValue$iv = Math.min(Math.abs(element.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset()), Math.abs(element.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset()));
                do {
                    Object e$iv = iterator$iv.next();
                    PsiElement element2 = (PsiElement)e$iv;
                    $i$a$-minByOrNull-EditorConfigRemoveUnexpectedValuesQuickFix$findClosestListElement$1 = false;
                    int v$iv = Math.min(Math.abs(element2.getTextRange().getStartOffset() - editor2.getCaretModel().getOffset()), Math.abs(element2.getTextRange().getEndOffset() - editor2.getCaretModel().getOffset()));
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = minElem$iv;
            }
        }
        return v2;
    }

    private static final void applyFix$lambda$0(EditorConfigOptionValueList $list, EditorConfigOptionValueIdentifier $replacement) {
        $list.replace((PsiElement)$replacement);
    }
}

