/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.schema.parser.handlers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaException;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H$J\u0016\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006H\u0004J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0006H\u0004\u00a2\u0006\u0002\u0010\u001fR\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006 "}, d2={"Lorg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase;", "", "<init>", "()V", "requiredKeys", "", "", "getRequiredKeys", "()Ljava/util/List;", "optionalKeys", "getOptionalKeys", "forbiddenChildren", "getForbiddenChildren", "doHandle", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "jsonObject", "Lcom/google/gson/JsonObject;", "parser", "Lorg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser;", "handle", "assertContents", "", "tryGetElement", "Lcom/google/gson/JsonElement;", "key", "tryGetString", "tryGetInt", "", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/Integer;", "tryGetBoolean", "", "(Lcom/google/gson/JsonObject;Ljava/lang/String;)Ljava/lang/Boolean;", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigDescriptorParseHandlerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigDescriptorParseHandlerBase.kt\norg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1786#2,3:76\n*S KotlinDebug\n*F\n+ 1 EditorConfigDescriptorParseHandlerBase.kt\norg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase\n*L\n36#1:76,3\n*E\n"})
public abstract class EditorConfigDescriptorParseHandlerBase {
    @NotNull
    private final List<String> optionalKeys;
    @NotNull
    private final List<String> forbiddenChildren;

    public EditorConfigDescriptorParseHandlerBase() {
        Object[] objectArray = new String[]{"documentation", "type_alias", "deprecated"};
        this.optionalKeys = CollectionsKt.listOf((Object[])objectArray);
        this.forbiddenChildren = CollectionsKt.emptyList();
    }

    @NotNull
    protected abstract List<String> getRequiredKeys();

    @NotNull
    protected List<String> getOptionalKeys() {
        return this.optionalKeys;
    }

    @NotNull
    public List<String> getForbiddenChildren() {
        return this.forbiddenChildren;
    }

    @NotNull
    protected abstract EditorConfigDescriptor doHandle(@NotNull JsonObject var1, @NotNull EditorConfigJsonSchemaParser var2);

    @NotNull
    public final EditorConfigDescriptor handle(@NotNull JsonObject jsonObject, @NotNull EditorConfigJsonSchemaParser parser) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        this.assertContents(jsonObject, parser);
        EditorConfigDescriptor result2 = this.doHandle(jsonObject, parser);
        String alias = this.tryGetString(jsonObject, "type_alias");
        if (alias != null) {
            parser.registerTypeAlias(alias, jsonObject);
        }
        return result2;
    }

    private final void assertContents(JsonObject jsonObject, EditorConfigJsonSchemaParser parser) {
        boolean bl;
        Set keys;
        block5: {
            keys = jsonObject.keySet();
            if (!keys.containsAll((Collection)this.getRequiredKeys())) {
                throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
            }
            Intrinsics.checkNotNull((Object)keys);
            Iterable $this$all$iv = keys;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (this.getRequiredKeys().contains(it) || this.getOptionalKeys().contains(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (!bl) {
            parser.warn("Unexpected option value descriptor key in " + keys);
        }
    }

    private final JsonElement tryGetElement(JsonObject jsonObject, String key) {
        return jsonObject.has(key) ? jsonObject.get(key) : null;
    }

    @Nullable
    protected final String tryGetString(@NotNull JsonObject jsonObject, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        catch (ClassCastException ex) {
            string = null;
        }
        catch (IllegalStateException ex) {
            string = null;
        }
        return string;
    }

    @Nullable
    protected final Integer tryGetInt(@NotNull JsonObject jsonObject, @NotNull String key) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            n = jsonElement != null ? Integer.valueOf(jsonElement.getAsInt()) : null;
        }
        catch (ClassCastException ex) {
            n = null;
        }
        catch (IllegalStateException ex) {
            n = null;
        }
        return n;
    }

    @Nullable
    protected final Boolean tryGetBoolean(@NotNull JsonObject jsonObject, @NotNull String key) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            JsonElement jsonElement = this.tryGetElement(jsonObject, key);
            bl = jsonElement != null ? Boolean.valueOf(jsonElement.getAsBoolean()) : null;
        }
        catch (ClassCastException ex) {
            bl = null;
        }
        catch (IllegalStateException ex) {
            bl = null;
        }
        return bl;
    }
}

