/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiMethodUtil {
    private JavaPsiMethodUtil() {
    }

    public static @Nullable Couple<@NotNull PsiMethod> getUnrelatedSuperMethods(@NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethod> overrideEquivalentSuperMethods) {
        if (aClass == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(0);
        }
        if (overrideEquivalentSuperMethods == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(1);
        }
        if (overrideEquivalentSuperMethods.size() <= 1) {
            return null;
        }
        ArrayList<PsiMethod> defaults = null;
        PsiMethod abstractMethod = null;
        for (PsiMethod psiMethod : overrideEquivalentSuperMethods) {
            boolean isDefault = psiMethod.hasModifierProperty("default");
            boolean isAbstract = psiMethod.hasModifierProperty("abstract");
            boolean isStatic = psiMethod.hasModifierProperty("static");
            if (!(isDefault || isAbstract || isStatic)) {
                return null;
            }
            if (isDefault) {
                if (defaults == null) {
                    defaults = new ArrayList<PsiMethod>(2);
                }
                defaults.add(psiMethod);
            }
            if (!isAbstract || abstractMethod != null) continue;
            abstractMethod = psiMethod;
        }
        if (defaults == null) {
            return null;
        }
        PsiMethod defaultMethod = (PsiMethod)defaults.getFirst();
        PsiClass psiClass = defaultMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (abstractMethod == null) {
            return JavaPsiMethodUtil.findUnrelatedCouple((List<PsiMethod>)defaults);
        }
        PsiClass abstractMethodContainingClass = abstractMethod.getContainingClass();
        if (abstractMethodContainingClass == null) {
            return null;
        }
        if (aClass.isInterface() || abstractMethodContainingClass.isInterface()) {
            Couple<@NotNull PsiMethod> unrelatedCouple = JavaPsiMethodUtil.findUnrelatedCouple((List<PsiMethod>)defaults);
            if (unrelatedCouple != null) {
                return unrelatedCouple;
            }
            if (JavaPsiMethodUtil.hasNotOverriddenAbstract(defaults, abstractMethodContainingClass)) {
                return Couple.of((Object)((PsiMethod)defaults.getFirst()), (Object)abstractMethod);
            }
        }
        return null;
    }

    @Nullable
    public static PsiMethod getAbstractMethodToImplementWhenDefaultPresent(@NotNull PsiClass aClass, @NotNull Collection<? extends PsiMethod> overrideEquivalentSuperMethods, boolean skipSelf) {
        MethodSignature unrelatedMethodSignature;
        if (aClass == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(2);
        }
        if (overrideEquivalentSuperMethods == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(3);
        }
        if (aClass.hasModifierProperty("abstract") || aClass instanceof PsiTypeParameter) {
            return null;
        }
        if (overrideEquivalentSuperMethods.size() <= 1) {
            return null;
        }
        PsiMethod abstractMethod = null;
        PsiMethod defaultMethod = null;
        for (PsiMethod psiMethod : overrideEquivalentSuperMethods) {
            if (psiMethod.hasModifierProperty("default")) {
                if (defaultMethod != null) continue;
                defaultMethod = psiMethod;
                continue;
            }
            if (psiMethod.hasModifierProperty("abstract")) {
                if (abstractMethod != null) continue;
                abstractMethod = psiMethod;
                continue;
            }
            if (psiMethod.hasModifierProperty("static")) continue;
            return null;
        }
        if (abstractMethod == null || defaultMethod == null) {
            return null;
        }
        if (!skipSelf && MethodSignatureUtil.findMethodBySuperMethod((PsiClass)aClass, defaultMethod, (boolean)false) != null) {
            return null;
        }
        PsiClass abstractMethodContainingClass = abstractMethod.getContainingClass();
        if (abstractMethodContainingClass == null || !abstractMethodContainingClass.isInterface()) {
            return null;
        }
        PsiClass psiClass = defaultMethod.getContainingClass();
        if (psiClass == null) {
            return null;
        }
        if (psiClass.isInheritor(abstractMethodContainingClass, true) && MethodSignatureUtil.isSubsignature((MethodSignature)(unrelatedMethodSignature = abstractMethod.getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)abstractMethodContainingClass, (PsiClass)psiClass, (PsiSubstitutor)PsiSubstitutor.EMPTY))), (MethodSignature)defaultMethod.getSignature(PsiSubstitutor.EMPTY))) {
            return null;
        }
        return abstractMethod;
    }

    private static @Nullable Couple<@NotNull PsiMethod> findUnrelatedCouple(List<PsiMethod> methods) {
        if (methods.size() <= 1) {
            return null;
        }
        List classes = ContainerUtil.map(methods, method -> method.getContainingClass());
        ArrayList<PsiMethod> resultMethods = new ArrayList<PsiMethod>(methods);
        for (PsiClass aClass1 : classes) {
            resultMethods.removeIf(method -> aClass1.isInheritor(Objects.requireNonNull(method.getContainingClass()), true));
        }
        if (resultMethods.size() > 1) {
            return Couple.of((Object)resultMethods.get(0), (Object)resultMethods.get(1));
        }
        return null;
    }

    private static boolean belongToOneHierarchy(@Nullable PsiClass class1, @Nullable PsiClass class2) {
        return class1 != null && class2 != null && (class1.isInheritor(class2, true) || class2.isInheritor(class1, true));
    }

    private static boolean hasNotOverriddenAbstract(@NotNull List<PsiMethod> defaults, @NotNull PsiClass abstractMethodContainingClass) {
        if (defaults == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(4);
        }
        if (abstractMethodContainingClass == null) {
            JavaPsiMethodUtil.$$$reportNull$$$0(5);
        }
        return !ContainerUtil.exists(defaults, method -> JavaPsiMethodUtil.belongToOneHierarchy(method.getContainingClass(), abstractMethodContainingClass));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrideEquivalentSuperMethods";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "abstractMethodContainingClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiMethodUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnrelatedSuperMethods";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAbstractMethodToImplementWhenDefaultPresent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNotOverriddenAbstract";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

