/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.codeserver.core;

import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiDefaultCaseLabelElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.ConstantExpressionUtil;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaPsiSwitchUtil {
    private JavaPsiSwitchUtil() {
    }

    @NotNull
    public static SelectorKind getSwitchSelectorKind(@NotNull PsiType selectorType) {
        PsiType unboxedType;
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(0);
        }
        if (TypeConversionUtil.getTypeRank((PsiType)selectorType) <= 4) {
            SelectorKind selectorKind = SelectorKind.INT;
            if (selectorKind == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(1);
            }
            return selectorKind;
        }
        Object object = unboxedType = selectorType instanceof PsiClassType && JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS.isSufficient(((PsiClassType)selectorType).getLanguageLevel()) ? PsiPrimitiveType.getOptionallyUnboxedType((PsiType)selectorType) : selectorType;
        if (unboxedType != null) {
            if (unboxedType.equals(PsiTypes.longType())) {
                SelectorKind selectorKind = SelectorKind.LONG;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(2);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.booleanType())) {
                SelectorKind selectorKind = SelectorKind.BOOLEAN;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(3);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.floatType())) {
                SelectorKind selectorKind = SelectorKind.FLOAT;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(4);
                }
                return selectorKind;
            }
            if (unboxedType.equals(PsiTypes.doubleType())) {
                SelectorKind selectorKind = SelectorKind.DOUBLE;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(5);
                }
                return selectorKind;
            }
        }
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)selectorType)) {
            SelectorKind selectorKind = SelectorKind.INVALID;
            if (selectorKind == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(6);
            }
            return selectorKind;
        }
        PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)selectorType);
        if (psiClass != null) {
            if (psiClass.isEnum()) {
                SelectorKind selectorKind = SelectorKind.ENUM;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(7);
                }
                return selectorKind;
            }
            String fqn = psiClass.getQualifiedName();
            if (Comparing.strEqual((String)fqn, (String)"java.lang.String")) {
                SelectorKind selectorKind = SelectorKind.STRING;
                if (selectorKind == null) {
                    JavaPsiSwitchUtil.$$$reportNull$$$0(8);
                }
                return selectorKind;
            }
        }
        SelectorKind selectorKind = SelectorKind.CLASS_OR_ARRAY;
        if (selectorKind == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(9);
        }
        return selectorKind;
    }

    @Contract(pure=true)
    public static boolean hasAnyCaseLabels(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(10);
        }
        if ((body = block.getBody()) == null) {
            return false;
        }
        for (PsiElement st = body.getFirstChild(); st != null; st = st.getNextSibling()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (labelStatement.isDefaultCase()) {
                return true;
            }
            PsiCaseLabelElementList labelElementList = labelStatement.getCaseLabelElementList();
            if (labelElementList == null || labelElementList.getElementCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static PsiEnumConstant getEnumConstant(@Nullable PsiCaseLabelElement element) {
        PsiReferenceExpression ref;
        PsiElement psiElement;
        if (element instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)element).resolve()) instanceof PsiEnumConstant) {
            PsiEnumConstant enumConstant = (PsiEnumConstant)psiElement;
            return enumConstant;
        }
        return null;
    }

    @Nullable
    private static Object getBranchConstant(@NotNull PsiCaseLabelElement labelElement, @NotNull PsiType selectorType) {
        if (labelElement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(11);
        }
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(12);
        }
        if (labelElement instanceof PsiExpression) {
            PsiReferenceExpression ref;
            PsiElement psiElement;
            PsiExpression expr = (PsiExpression)labelElement;
            if (expr instanceof PsiReferenceExpression && (psiElement = (ref = (PsiReferenceExpression)expr).resolve()) instanceof PsiEnumConstant) {
                PsiEnumConstant constant = (PsiEnumConstant)psiElement;
                return constant;
            }
            Object operand = JavaPsiFacade.getInstance((Project)labelElement.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)labelElement, false);
            if (operand != null) {
                if (operand instanceof Boolean && JavaPsiSwitchUtil.getSwitchSelectorKind(selectorType) == SelectorKind.BOOLEAN) {
                    return (boolean)((Boolean)operand);
                }
                return ConstantExpressionUtil.computeCastTo((Object)operand, (PsiType)selectorType);
            }
            if (labelElement instanceof PsiLiteralExpression && ((PsiLiteralExpression)labelElement).getType() == PsiTypes.nullType()) {
                return SwitchSpecialValue.NULL_VALUE;
            }
        } else {
            if (labelElement instanceof PsiDefaultCaseLabelElement) {
                return SwitchSpecialValue.DEFAULT_VALUE;
            }
            if (JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)labelElement, (PsiType)selectorType)) {
                return SwitchSpecialValue.UNCONDITIONAL_PATTERN;
            }
        }
        return null;
    }

    @NotNull
    public static MultiMap<Object, PsiElement> getValuesAndLabels(@NotNull PsiSwitchBlock block) {
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(13);
        }
        MultiMap elementsToCheckDuplicates = new MultiMap();
        PsiCodeBlock body = block.getBody();
        if (body == null) {
            MultiMap multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(14);
            }
            return multiMap;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            MultiMap multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(15);
            }
            return multiMap;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            MultiMap multiMap = elementsToCheckDuplicates;
            if (multiMap == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(16);
            }
            return multiMap;
        }
        for (PsiStatement st : body.getStatements()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (labelStatement.isDefaultCase()) {
                elementsToCheckDuplicates.putValue((Object)SwitchSpecialValue.DEFAULT_VALUE, (Object)Objects.requireNonNull(labelStatement.getFirstChild()));
                continue;
            }
            PsiCaseLabelElementList labelElementList = labelStatement.getCaseLabelElementList();
            if (labelElementList == null) continue;
            for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                Object constant = JavaPsiSwitchUtil.getBranchConstant(labelElement, selectorType);
                if (constant == null) continue;
                elementsToCheckDuplicates.putValue(constant, (Object)labelElement);
            }
        }
        MultiMap multiMap = elementsToCheckDuplicates;
        if (multiMap == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    public static boolean isDominated(@NotNull PsiCaseLabelElement overWhom, @NotNull PsiElement who, @NotNull PsiType selectorType) {
        PsiExpression expression;
        boolean isOverWhomUnconditionalForSelector;
        if (overWhom == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(18);
        }
        if (who == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(19);
        }
        if (selectorType == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(20);
        }
        if (!(isOverWhomUnconditionalForSelector = JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)overWhom, (PsiType)selectorType)) && ((!(overWhom instanceof PsiExpression) || ExpressionUtil.isNullLiteral((PsiElement)(expression = (PsiExpression)overWhom))) && who instanceof PsiKeyword && "default".equals(who.getText()) || JavaPsiSwitchUtil.isInCaseNullDefaultLabel(who))) {
            return true;
        }
        if (who instanceof PsiCaseLabelElement) {
            PsiCaseLabelElement currentElement = (PsiCaseLabelElement)who;
            if (JavaPsiPatternUtil.isGuarded((PsiCaseLabelElement)currentElement)) {
                return false;
            }
            if (JavaPsiSwitchUtil.isConstantLabelElement(overWhom)) {
                PsiExpression constExpr = (PsiExpression)ObjectUtils.tryCast((Object)overWhom, PsiExpression.class);
                assert (constExpr != null);
                if (JavaPsiPatternUtil.dominatesOverConstant((PsiCaseLabelElement)currentElement, (PsiExpression)constExpr)) {
                    return true;
                }
            } else if (JavaPsiPatternUtil.dominates((PsiCaseLabelElement)currentElement, (PsiCaseLabelElement)overWhom)) {
                return true;
            }
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.PATTERNS_WITH_TIGHTENED_DOMINANCE, (PsiElement)overWhom) && (overWhom instanceof PsiPattern || JavaPsiSwitchUtil.isConstantLabelElement(overWhom)) && JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)currentElement, (PsiType)selectorType)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isInCaseNullDefaultLabel(@NotNull PsiElement element) {
        PsiExpression expr;
        PsiCaseLabelElementList list;
        if (element == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(21);
        }
        if ((list = (PsiCaseLabelElementList)ObjectUtils.tryCast((Object)element.getParent(), PsiCaseLabelElementList.class)) == null || list.getElementCount() != 2) {
            return false;
        }
        PsiCaseLabelElement[] elements = list.getElements();
        PsiCaseLabelElement psiCaseLabelElement = elements[0];
        return psiCaseLabelElement instanceof PsiExpression && ExpressionUtil.isNullLiteral((PsiElement)(expr = (PsiExpression)psiCaseLabelElement)) && elements[1] instanceof PsiDefaultCaseLabelElement;
    }

    private static boolean isConstantLabelElement(@NotNull PsiCaseLabelElement labelElement) {
        Object value;
        if (labelElement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(22);
        }
        return (value = JavaPsiFacade.getInstance((Project)labelElement.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)labelElement, false)) != null || JavaPsiSwitchUtil.getEnumConstant(labelElement) != null;
    }

    @NotNull
    public static Map<PsiCaseLabelElement, PsiElement> findDominatedLabels(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(23);
        }
        if ((body = block.getBody()) == null) {
            Map<PsiCaseLabelElement, PsiElement> map = Collections.emptyMap();
            if (map == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(24);
            }
            return map;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            Map<PsiCaseLabelElement, PsiElement> map = Collections.emptyMap();
            if (map == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(25);
            }
            return map;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            Map<PsiCaseLabelElement, PsiElement> map = Collections.emptyMap();
            if (map == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(26);
            }
            return map;
        }
        ArrayList<Object> elementsToCheckDominance = new ArrayList<Object>();
        for (PsiStatement st : body.getStatements()) {
            if (!(st instanceof PsiSwitchLabelStatementBase)) continue;
            PsiSwitchLabelStatementBase labelStatement = (PsiSwitchLabelStatementBase)st;
            if (labelStatement.isDefaultCase()) {
                elementsToCheckDominance.add(Objects.requireNonNull(labelStatement.getFirstChild()));
                continue;
            }
            PsiCaseLabelElementList labelElementList = labelStatement.getCaseLabelElementList();
            if (labelElementList == null) continue;
            for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                if (!JavaPsiSwitchUtil.shouldConsiderForDominance(labelElement)) continue;
                elementsToCheckDominance.add(labelElement);
            }
        }
        HashMap<PsiCaseLabelElement, PsiElement> result = new HashMap<PsiCaseLabelElement, PsiElement>();
        for (int i = 0; i < elementsToCheckDominance.size() - 1; ++i) {
            PsiElement current = (PsiElement)elementsToCheckDominance.get(i);
            if (result.containsKey(current)) continue;
            for (int j = i + 1; j < elementsToCheckDominance.size(); ++j) {
                PsiCaseLabelElement nextElement;
                boolean dominated;
                PsiElement next = (PsiElement)elementsToCheckDominance.get(j);
                if (!(next instanceof PsiCaseLabelElement) || !(dominated = JavaPsiSwitchUtil.isDominated(nextElement = (PsiCaseLabelElement)next, current, selectorType))) continue;
                result.put(nextElement, current);
            }
        }
        HashMap<PsiCaseLabelElement, PsiElement> hashMap = result;
        if (hashMap == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    private static boolean shouldConsiderForDominance(@NotNull PsiCaseLabelElement labelElement) {
        if (labelElement == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(28);
        }
        if (labelElement instanceof PsiPattern) {
            return true;
        }
        if (labelElement instanceof PsiExpression) {
            boolean isNullType = ExpressionUtil.isNullLiteral((PsiElement)labelElement);
            if (isNullType && JavaPsiSwitchUtil.isInCaseNullDefaultLabel((PsiElement)labelElement)) {
                return false;
            }
            return isNullType || JavaPsiSwitchUtil.isConstantLabelElement(labelElement);
        }
        return labelElement instanceof PsiDefaultCaseLabelElement;
    }

    public static PsiCaseLabelElement getUnconditionalPatternLabel(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(29);
        }
        if ((body = block.getBody()) == null) {
            return null;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            return null;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null) {
            return null;
        }
        List types = JavaPsiPatternUtil.deconstructSelectorType((PsiType)selectorType);
        for (PsiStatement st : body.getStatements()) {
            PsiCaseLabelElementList labelElementList;
            PsiSwitchLabelStatementBase labelStatement;
            if (!(st instanceof PsiSwitchLabelStatementBase) || (labelStatement = (PsiSwitchLabelStatementBase)st).isDefaultCase() || (labelElementList = labelStatement.getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                if (!ContainerUtil.exists((Iterable)types, type -> JavaPsiPatternUtil.isUnconditionalForType((PsiCaseLabelElement)labelElement, (PsiType)type))) continue;
                return labelElement;
            }
        }
        return null;
    }

    public static boolean isBooleanSwitchWithTrueAndFalse(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(30);
        }
        if ((body = block.getBody()) == null) {
            return false;
        }
        PsiExpression selector = block.getExpression();
        if (selector == null) {
            return false;
        }
        PsiType selectorType = selector.getType();
        if (selectorType == null || JavaPsiSwitchUtil.getSwitchSelectorKind(selector.getType()) != SelectorKind.BOOLEAN) {
            return false;
        }
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)block.getProject()).getConstantEvaluationHelper();
        boolean hasTrue = false;
        boolean hasFalse = false;
        for (PsiStatement st : body.getStatements()) {
            PsiCaseLabelElementList labelElementList;
            PsiSwitchLabelStatementBase labelStatement;
            if (!(st instanceof PsiSwitchLabelStatementBase) || (labelStatement = (PsiSwitchLabelStatementBase)st).isDefaultCase() || (labelElementList = labelStatement.getCaseLabelElementList()) == null) continue;
            for (PsiCaseLabelElement labelElement : labelElementList.getElements()) {
                Object object;
                if (!(labelElement instanceof PsiExpression)) continue;
                PsiExpression expression = (PsiExpression)labelElement;
                if (!PsiTypes.booleanType().equals((Object)expression.getType()) || !((object = helper.computeConstantExpression((PsiElement)expression, false)) instanceof Boolean)) continue;
                Boolean res = (Boolean)object;
                if (res.booleanValue()) {
                    hasTrue = true;
                } else {
                    hasFalse = true;
                }
                if (!hasTrue || !hasFalse) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiElement findDefaultElement(@NotNull PsiSwitchBlock switchBlock) {
        PsiCodeBlock body;
        if (switchBlock == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(31);
        }
        if ((body = switchBlock.getBody()) == null) {
            return null;
        }
        for (PsiStatement statement : body.getStatements()) {
            PsiElement defaultElement;
            PsiSwitchLabelStatementBase switchLabelStatement = (PsiSwitchLabelStatementBase)ObjectUtils.tryCast((Object)statement, PsiSwitchLabelStatementBase.class);
            if (switchLabelStatement == null || (defaultElement = JavaPsiSwitchUtil.findDefaultElement(switchLabelStatement)) == null) continue;
            return defaultElement;
        }
        return null;
    }

    @Nullable
    public static PsiElement findDefaultElement(@NotNull PsiSwitchLabelStatementBase label) {
        if (label == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(32);
        }
        if (label.isDefaultCase()) {
            return label;
        }
        PsiCaseLabelElementList labelElementList = label.getCaseLabelElementList();
        if (labelElementList == null) {
            return null;
        }
        return (PsiElement)ContainerUtil.find((Object[])labelElementList.getElements(), labelElement -> labelElement instanceof PsiDefaultCaseLabelElement);
    }

    @NotNull
    public static List<PsiElement> getSwitchBranches(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(33);
        }
        if ((body = block.getBody()) == null) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(34);
            }
            return list;
        }
        SmartList result = new SmartList();
        for (PsiSwitchLabelStatementBase child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)body, PsiSwitchLabelStatementBase.class)) {
            if (child.isDefaultCase()) {
                result.add(child);
                continue;
            }
            PsiCaseLabelElementList labelElementList = child.getCaseLabelElementList();
            if (labelElementList == null) continue;
            Collections.addAll(result, labelElementList.getElements());
        }
        SmartList smartList = result;
        if (smartList == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(35);
        }
        return smartList;
    }

    @NotNull
    public static List<PsiCaseLabelElement> getCaseLabelElements(@NotNull PsiSwitchBlock block) {
        PsiCodeBlock body;
        if (block == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(36);
        }
        if ((body = block.getBody()) == null) {
            List<PsiCaseLabelElement> list = List.of();
            if (list == null) {
                JavaPsiSwitchUtil.$$$reportNull$$$0(37);
            }
            return list;
        }
        ArrayList<PsiCaseLabelElement> elementsToCheckCompleteness = new ArrayList<PsiCaseLabelElement>();
        for (PsiStatement st : body.getStatements()) {
            PsiCaseLabelElementList labelElementList;
            PsiSwitchLabelStatementBase labelStatement;
            if (!(st instanceof PsiSwitchLabelStatementBase) || (labelStatement = (PsiSwitchLabelStatementBase)st).isDefaultCase() || (labelElementList = labelStatement.getCaseLabelElementList()) == null) continue;
            Collections.addAll(elementsToCheckCompleteness, labelElementList.getElements());
        }
        ArrayList<PsiCaseLabelElement> arrayList = elementsToCheckCompleteness;
        if (arrayList == null) {
            JavaPsiSwitchUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15, 16, 17, 24, 25, 26, 27, 34, 35, 37, 38 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectorType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/java/codeserver/core/JavaPsiSwitchUtil";
                break;
            }
            case 10: 
            case 13: 
            case 23: 
            case 29: 
            case 30: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 11: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "labelElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overWhom";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBlock";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/java/codeserver/core/JavaPsiSwitchUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchSelectorKind";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuesAndLabels";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "findDominatedLabels";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getSwitchBranches";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getCaseLabelElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchSelectorKind";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 34: 
            case 35: 
            case 37: 
            case 38: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyCaseLabels";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBranchConstant";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getValuesAndLabels";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDominated";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isInCaseNullDefaultLabel";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isConstantLabelElement";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findDominatedLabels";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "shouldConsiderForDominance";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getUnconditionalPatternLabel";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanSwitchWithTrueAndFalse";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultElement";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getSwitchBranches";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getCaseLabelElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 14, 15, 16, 17, 24, 25, 26, 27, 34, 35, 37, 38 -> new IllegalStateException(string);
        };
    }

    public static enum SelectorKind {
        INT(null),
        ENUM(JavaFeature.ENUMS),
        STRING(JavaFeature.STRING_SWITCH),
        CLASS_OR_ARRAY(JavaFeature.PATTERNS_IN_SWITCH),
        BOOLEAN(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        LONG(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        FLOAT(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        DOUBLE(JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS),
        INVALID(null);

        @Nullable
        private final JavaFeature myFeature;

        private SelectorKind(JavaFeature feature) {
            this.myFeature = feature;
        }

        @Nullable
        public JavaFeature getFeature() {
            return this.myFeature;
        }
    }

    public static enum SwitchSpecialValue {
        UNCONDITIONAL_PATTERN,
        DEFAULT_VALUE,
        NULL_VALUE;

    }
}

