/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.memory.agent.extractor;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor;", "", "<init>", "()V", "extractedFile", "Ljava/io/File;", "lastModified", "", "extract", "Ljava/nio/file/Path;", "agentType", "Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor$AgentLibraryType;", "directory", "AgentLibraryType", "intellij.java.debugger.memory.agent"})
public final class AgentExtractor {
    @NotNull
    public static final AgentExtractor INSTANCE = new AgentExtractor();
    private static File extractedFile;
    private static long lastModified;

    private AgentExtractor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final synchronized Path extract(@NotNull AgentLibraryType agentType, @NotNull Path directory) {
        File file;
        block18: {
            block17: {
                Intrinsics.checkNotNullParameter((Object)((Object)agentType), (String)"agentType");
                Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
                if (extractedFile == null) break block17;
                File file2 = extractedFile;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file2 = null;
                }
                if (!file2.exists()) break block17;
                File file3 = extractedFile;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file3 = null;
                }
                if (file3.lastModified() == lastModified) break block18;
            }
            String agentFileName = agentType.getPrefix() + "memory_agent" + agentType.getSuffix();
            File file4 = FileUtilRt.createTempFile((File)directory.toFile(), (String)(agentType.getPrefix() + "memory_agent"), (String)agentType.getSuffix(), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"createTempFile(...)");
            File file5 = file4;
            InputStream inputStream = AgentExtractor.class.getClassLoader().getResourceAsStream("bin/" + agentFileName);
            if (inputStream == null) {
                throw new FileNotFoundException(agentFileName);
            }
            InputStream inputStream2 = inputStream;
            Closeable closeable = inputStream2;
            Throwable throwable = null;
            try {
                InputStream input = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = Files.newOutputStream(file5.toPath(), new OpenOption[0]);
                Throwable throwable2 = null;
                try {
                    OutputStream output = (OutputStream)closeable2;
                    boolean bl2 = false;
                    FileUtil.copy((InputStream)input, (OutputStream)output);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            extractedFile = file5;
            lastModified = file5.lastModified();
        }
        if ((file = extractedFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
            file = null;
        }
        Path path = file.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        return path;
    }

    static {
        lastModified = -1L;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/memory/agent/extractor/AgentExtractor$AgentLibraryType;", "", "prefix", "", "suffix", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "getPrefix", "()Ljava/lang/String;", "getSuffix", "WINDOWS32", "WINDOWS64", "WINDOWS_ARM64", "LINUX_X64", "LINUX_AARCH64", "MACOS", "intellij.java.debugger.memory.agent"})
    public static final class AgentLibraryType
    extends Enum<AgentLibraryType> {
        @NotNull
        private final String prefix;
        @NotNull
        private final String suffix;
        public static final /* enum */ AgentLibraryType WINDOWS32 = new AgentLibraryType("", "32.dll");
        public static final /* enum */ AgentLibraryType WINDOWS64 = new AgentLibraryType("", ".dll");
        public static final /* enum */ AgentLibraryType WINDOWS_ARM64 = new AgentLibraryType("", "64a.dll");
        public static final /* enum */ AgentLibraryType LINUX_X64 = new AgentLibraryType("lib", ".so");
        public static final /* enum */ AgentLibraryType LINUX_AARCH64 = new AgentLibraryType("lib", "_aarch64.so");
        public static final /* enum */ AgentLibraryType MACOS = new AgentLibraryType("lib", ".dylib");
        private static final /* synthetic */ AgentLibraryType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AgentLibraryType(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        public static AgentLibraryType[] values() {
            return (AgentLibraryType[])$VALUES.clone();
        }

        public static AgentLibraryType valueOf(String value) {
            return Enum.valueOf(AgentLibraryType.class, value);
        }

        @NotNull
        public static EnumEntries<AgentLibraryType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = agentLibraryTypeArray = new AgentLibraryType[]{AgentLibraryType.WINDOWS32, AgentLibraryType.WINDOWS64, AgentLibraryType.WINDOWS_ARM64, AgentLibraryType.LINUX_X64, AgentLibraryType.LINUX_AARCH64, AgentLibraryType.MACOS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

